globals [ colist rockbred rockspawn scissorbred scissorspawn paperbred paperspawn rockkill scissorkill paperkill ]
turtles-own [ energy adjust ]
breed [ rocks rock ]
breed [ papers paper ]
breed [ scissors scissor ]

to setup

  clear-all
  set colist (list random 255 random 255 random 255)
  ask patches
  [
    set pcolor black
  ]
  create-rocks number-rocks
  [
    create "rockblob" red - 1
  ]
  create-papers number-papers
  [
    create "paperblob" lime - 1
  ]
  create-scissors number-scissors
  [
    create "scissorblob" blue - 1
  ]
  reset-ticks
end

to create [form col]
  set shape form
  setxy random-xcor random-ycor
  right random 360
  set color col
end

to go
  if (ticks >= duration) and Timed [ stop ]  ;; stop after set duration of ticks
  ask turtles
  [
    ifelse Draw [pendown][pen-erase]
  ]
  resources
  moveall
  feed
  kills
  reproduce
  if respawn-interval > 0 [ respawns ] ;; switch off respawns of interval zero
  tick
end

to moveall
  if r-hunt [ hunt rocks]
  if s-hunt [ hunt scissors]
  if p-hunt [ hunt papers]
  if r-find [ find rocks ]
  if s-find [ find scissors ]
  if p-find [ find papers ]
  if r-evade [ evade rocks]
  if s-evade [ evade scissors]
  if p-evade [ evade papers]
  if r-avoid [ avoid rocks]
  if s-avoid [ avoid scissors]
  if p-avoid [ avoid papers]
  move rocks rock%
  move scissors scissor%
  move papers paper%
end

to move [brd var]
  ask brd
  [
    forward 0.01 * speed * (var / 100)
  ]
end

to kills
  ask papers
  [
    if predation and p-gain [ set energy energy + (count rocks-here) * predation-gain ]
    ask rocks-here
    [
      set rockkill rockkill + 1
      die
    ]
  ]
  ask rocks
  [
    if predation and r-gain [ set energy energy + (count scissors-here) * predation-gain ]
    ask scissors-here
    [
      set scissorkill scissorkill + 1
      die
    ]
  ]
  ask scissors
  [
    if predation and s-gain [ set energy energy + (count papers-here) * predation-gain ]
    ask papers-here
    [
      set paperkill paperkill + 1
      die
    ]
  ]
end

to resources
  ask patches
  [
    let erg-available random 100
    if (erg-available < energy-input-chance) and (ticks mod energy-input-delay = 0)
    [
      set pcolor black + 1
    ]
  ]
end

to feed
  ask turtles [
    if pcolor = black + 1 [
      set pcolor black
      set energy energy + 1
    ]
  ifelse show-energy
    [ set label energy ] ;; the label is set to be the value of the energy
    [ set label "" ]     ;; the label is set to an empty text value
  ]
end

to reproduce
  ask rocks
  [
    set adjust rocks+
  ]
  ask scissors
  [
    set adjust scissors+
  ]
  ask papers
  [
    set adjust papers+
  ]
  ask turtles [
    if energy > (reproduction-energy + adjust)[
      set energy energy - (reproduction-energy + adjust)  ;; take away reproduction-energy for mitosis
      hatch 1 [
        right random 360
      if breed = rocks
      [ set rockbred rockbred + 1 ]
      if breed = scissors
      [ set scissorbred scissorbred + 1 ]
      if breed = papers
      [ set paperbred paperbred + 1 ]
      ]
    ]
  ]
end

to respawns
  if ticks mod respawn-interval = 0
  [
    create-rocks 1
    [
      create "rockblob" red - 1
      set rockspawn rockspawn + 1
    ]
    create-papers 1
    [
      create "paperblob" lime - 1
      set paperspawn paperspawn + 1
    ]
    create-scissors 1
    [
      create "scissorblob" blue - 1
      set scissorspawn scissorspawn + 1
    ]
  ]
end

to hunt [brd]
  if brd = rocks
  [
    ask brd
    [
      let found (one-of scissors-on neighbors)
      if found != nobody [set heading towards found]
    ]
  ]
  if brd = scissors
  [
    ask brd
    [
      let found (one-of papers-on neighbors)
      if found != nobody [set heading towards found]
    ]
  ]
  if brd = papers
  [
    ask brd
    [
      let found (one-of rocks-on neighbors)
      if found != nobody [set heading towards found]
    ]
  ]
end

to evade [brd]
  if brd = rocks
  [
    ask brd
    [
      let found (one-of papers-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
  if brd = scissors
  [
    ask brd
    [
      let found (one-of rocks-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
  if brd = papers
  [
    ask brd
    [
      let found (one-of scissors-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
end

to avoid [brd]
  if brd = rocks
  [
    ask brd
    [
      let found (one-of scissors-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
  if brd = scissors
  [
    ask brd
    [
      let found (one-of papers-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
  if brd = papers
  [
    ask brd
    [
      let found (one-of rocks-on neighbors)
      if found != nobody [set heading (towards found + 180)]
    ]
  ]
end

to find [brd]
  ask brd
  [
    let found (one-of neighbors with [ pcolor = black + 1 ])
    if found != nobody [set heading towards found]
  ]
end

to reset
  set rock% 100
  set scissor% 100
  set paper% 100
  
  set rocks+ 0
  set scissors+ 0
  set papers+ 0
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
945
725
17
16
20.73
1
10
1
1
1
0
1
1
1
-17
17
-16
16
1
1
1
ticks
30.0

BUTTON
15
10
105
43
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
105
10
195
43
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
15
490
195
523
speed
speed
0
100
40
1
1
NIL
HORIZONTAL

SWITCH
15
70
105
103
Draw
Draw
1
1
-1000

SLIDER
15
195
195
228
number-rocks
number-rocks
0
100
30
1
1
NIL
HORIZONTAL

PLOT
960
10
1610
470
Numbers
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"rocks" 1.0 0 -5298144 true "" "plot count rocks"
"scissors" 1.0 0 -14070903 true "" "plot count scissors"
"papers" 1.0 0 -14439633 true "" "plot count papers"
"turtles" 1.0 0 -9276814 true "" "plot count turtles"

SLIDER
15
235
195
268
number-scissors
number-scissors
0
100
30
1
1
NIL
HORIZONTAL

SLIDER
15
275
195
308
number-papers
number-papers
0
100
30
1
1
NIL
HORIZONTAL

MONITOR
960
510
1065
555
NIL
count rocks
17
1
11

MONITOR
1070
510
1175
555
NIL
count scissors
17
1
11

MONITOR
1180
510
1285
555
NIL
count papers
17
1
11

SLIDER
960
475
1610
508
duration
duration
0
20000
20000
1
1
NIL
HORIZONTAL

SLIDER
15
345
195
378
energy-input-chance
energy-input-chance
0
10
5
1
1
NIL
HORIZONTAL

SWITCH
15
105
162
138
show-energy
show-energy
0
1
-1000

SLIDER
15
635
195
668
reproduction-energy
reproduction-energy
25
100
25
1
1
NIL
HORIZONTAL

MONITOR
1290
510
1395
555
NIL
count turtles
17
1
11

TEXTBOX
15
150
165
168
World Settings
12
0.0
1

MONITOR
1400
510
1505
555
system energy
count patches with [pcolor = black + 1]
17
1
11

MONITOR
1510
510
1610
555
NIL
count patches
17
1
11

SLIDER
15
385
195
418
energy-input-delay
energy-input-delay
0
50
25
1
1
NIL
HORIZONTAL

SLIDER
15
425
195
458
respawn-interval
respawn-interval
0
100
50
1
1
NIL
HORIZONTAL

MONITOR
960
555
1065
600
NIL
rockspawn
17
1
11

MONITOR
1070
555
1175
600
NIL
scissorspawn
17
1
11

MONITOR
1180
555
1285
600
NIL
paperspawn
17
1
11

MONITOR
960
600
1065
645
NIL
rockkill
17
1
11

MONITOR
1070
600
1175
645
NIL
scissorkill
17
1
11

MONITOR
1180
600
1285
645
NIL
paperkill
17
1
11

MONITOR
960
645
1065
690
NIL
rockbred
17
1
11

MONITOR
1070
645
1175
690
NIL
scissorbred
17
1
11

MONITOR
1180
645
1285
690
NIL
paperbred
17
1
11

TEXTBOX
15
175
165
193
Initial
12
0.0
1

TEXTBOX
15
50
165
68
View Settings
12
0.0
1

TEXTBOX
15
325
165
343
Variable
12
0.0
1

TEXTBOX
15
470
165
488
Turtle Settings
12
0.0
1

SLIDER
15
530
48
630
rock%
rock%
0
100
100
10
1
NIL
VERTICAL

SLIDER
85
530
118
630
scissor%
scissor%
0
100
100
10
1
NIL
VERTICAL

SLIDER
155
530
188
630
paper%
paper%
0
100
100
10
1
NIL
VERTICAL

SLIDER
15
675
48
775
rocks+
rocks+
-20
20
0
1
1
NIL
VERTICAL

SLIDER
85
675
118
775
scissors+
scissors+
-20
20
0
1
1
NIL
VERTICAL

SLIDER
155
675
188
775
papers+
papers+
-20
20
0
1
1
NIL
VERTICAL

BUTTON
210
745
387
778
Reset turtle settings
reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
105
70
195
103
Timed
Timed
0
1
-1000

TEXTBOX
1395
565
1545
583
Behaviour Strategies
12
0.0
1

SWITCH
1290
585
1395
618
r-evade
r-evade
1
1
-1000

SWITCH
1400
585
1505
618
s-evade
s-evade
1
1
-1000

SWITCH
1510
585
1615
618
p-evade
p-evade
1
1
-1000

SWITCH
1290
620
1395
653
r-hunt
r-hunt
1
1
-1000

SWITCH
1400
620
1505
653
s-hunt
s-hunt
1
1
-1000

SWITCH
1510
620
1615
653
p-hunt
p-hunt
1
1
-1000

SWITCH
1290
655
1395
688
r-find
r-find
1
1
-1000

SWITCH
1400
655
1505
688
s-find
s-find
1
1
-1000

SWITCH
1510
655
1615
688
p-find
p-find
1
1
-1000

SWITCH
395
745
522
778
predation
predation
1
1
-1000

SLIDER
530
745
702
778
predation-gain
predation-gain
0
50
3
1
1
NIL
HORIZONTAL

SWITCH
710
745
813
778
r-gain
r-gain
1
1
-1000

SWITCH
820
745
923
778
s-gain
s-gain
1
1
-1000

SWITCH
930
745
1033
778
p-gain
p-gain
1
1
-1000

SWITCH
1290
690
1395
723
r-avoid
r-avoid
1
1
-1000

SWITCH
1400
690
1505
723
s-avoid
s-avoid
1
1
-1000

SWITCH
1510
690
1617
723
p-avoid
p-avoid
1
1
-1000

@#$#@#$#@
## WHAT IS IT?

This model explores the rock paper scissors strategy of multi organism competition. Numbers are monitored to see if the model enters equilibrium or non-equilibrium state.

## HOW IT WORKS

When any two competitor species organisms meet one kills the other on the basis:
rock kills scissor, scissor kills paper, paper kills rock.

## HOW TO USE IT

View settings allow you to use the pen to draw movements, useful for tracking the changes in movement when behaviour strategies are applied, see the energy level of each agent and set a duration for the model to run, up to 20000 ticks, that can be changed in the settings for the duration slider to a new maximum at any time. Switch off Timed will leave the model to run indefinitely.

World settings is divided into initial settings and variables. Initial settings let you control the starting numbers. First section on variables allows for the setting of the energy input into the system which is used by the organisms to breed.

The next section Turtle Settings has controls for speed which lets you set the base turtle speed then modify it for each species. Reproduction energy again you create a base setting, which can then be modified for each species. Note reproduction sliders have been set up to prevent cost of zero which causes flooding and will hang the model. However this is not code protected, so if the sliders are changed outside of current settings please beware of the danger.

Respawning represents in nature the chance of an organism finding a hiding hole to prevent total extinction. It is currently designed to be equal, the frequency can be set to a high every tick to once every 100 ticks. Respawning can be turned off by setting to zero.

On the right hand of the layout are the monitors and behaviour strategy switches. Strategies coded in include hunt victim species, evade enemy species, avoid enemy species and find food. The suffix letter on the switch corresponds to the species r = rocks, s = scissors and p = papers.

To change the model dynamics you can turn on predation and set an energy gain for the prey organism eaten. This changes the model substantially from the rock paper scissors effectively just being toxic to each other and in that way acting as population control, to feeding off each other and using that energy to increase their population. Use the r-gain, s-gain and p-gain to customise the predation modelling, in that way you can create hunter species that hunt for the energy gained from prey, whilst others just kill their target species without eating them for the energy.

## THINGS TO NOTICE

You will notice that without Respawning it is not possible to find a dynamic equilibrium of species, the model leads to domination and mass reproduction of one victor species, though you can't predict which will win out.

If you try selectively setting strategies against each other, like evaders vs hunters and adjust settings to create an evolutionary arms race, it is interesting to see which species actually ends up the winner. From the models I've tested predator strategies needs a substantial return on predation to sustain numbers, this reflects the circular nature of the rock paper scissors competition, since what they hunt is also what makes the environment safer for them.

## THINGS TO TRY

The Turtle Settings section lets you change the speed and reproduction abilities of each species. Try to figure out what is advantageous or disadvantageous differences. Try to adjust cost / benefits to reflect investment cost by the species.

Behaviour Strategies section lets you turn on and off strategies of hunting, evading, avoiding and food finding. These strategies do have an order of preference if more than one is turned on, evading as a keep alive strategy has greatest priority and food finding has greater priority than hunting prey species. In this rock paper scissors world, there is actually little advantage to killing prey since they are not food, but it does model a competitive environment in a fashion that causes interesting dynamics.

## EXTENDING THE MODEL

A simple development would be to add different respawning rates, however that doesn't seem to offer a great amount of interesting investigation. New behaviours would of course be interesting as would testing different movement patterns, in this model the base movement is in a straight line.

## NETLOGO FEATURES

The behaviours are dependent on the NetLogo 'neighbours' primitive which allows the organism agent to investigate the world immediately around it and make a movement decision on it. The order of decision making when switched on in order of priority is: Evade an enemy species, find food and finally hunt a target species.

## RELATED MODELS

None searched for.

## CREDITS AND REFERENCES

Rashid Mhar email statishun(at)outlook.com
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

blob
true
0
Circle -7500403 true true 95 125 170
Circle -7500403 true true 12 72 216
Circle -7500403 true true 125 65 170
Circle -7500403 true true 45 0 210

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

paperblob
true
0
Circle -7500403 true true 95 125 170
Circle -7500403 true true 12 72 216
Circle -7500403 true true 125 65 170
Circle -7500403 true true 45 9 210
Polygon -16777216 false false 195 263 202 212 211 191 215 163 216 132 219 65 213 55 203 58 195 128 195 37 187 28 177 31 171 126 166 26 158 21 149 26 148 129 142 34 134 30 126 37 125 159 119 134 113 121 100 111 91 123 99 141 98 180 114 200 126 209 129 264 162 273

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

rockblob
true
0
Circle -7500403 true true 95 125 170
Circle -7500403 true true 12 72 216
Circle -7500403 true true 125 65 170
Circle -7500403 true true 45 9 210
Polygon -16777216 false false 186 242 187 209 201 185 208 173 208 148 207 135 205 119 203 106 196 93 185 89 176 94 172 82 163 81 153 89 149 78 139 78 132 88 123 83 114 86 112 99 110 115 108 151 110 125 101 125 94 131 82 162 84 170 110 190 119 211 120 243 153 252

scissorblob
true
0
Circle -7500403 true true 95 125 170
Circle -7500403 true true 12 72 216
Circle -7500403 true true 125 65 170
Circle -7500403 true true 45 9 210
Polygon -16777216 false false 195 263 202 212 211 191 215 163 216 132 215 127 208 121 201 124 195 128 192 121 184 117 176 120 171 126 184 31 176 24 169 28 148 129 125 39 116 32 110 41 125 159 123 151 123 142 121 133 104 145 94 157 98 180 114 200 126 209 129 264 162 273

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
