breed [countries]
breed [events]

countries-own
[ country-id-code ]

links-own [ coupling-strength source-occurrence ]

globals [ low medium high clock ] ; coupling strength levels

events-own 
[ psi_0 psi_1 ; qubit psi(0)*|no ocurrence> + psi(1)*|occurrence>
  P-threat
  occurrence
  F ]

to setup
  ca
  set-default-shape countries "flag"
  set-default-shape events "circle"
  ask patches [set pcolor white]
  set low 0.1 * random-float 1.000
  set medium 0.1 + 0.4 * random-float 1.000
  set high 0.4 + 0.9 * random-float 1.000
  setup-events
  setup-countries
  setup-morphic-web
  setup-initial-qubit
end



to play-quantum-game
  set clock clock + 1
  if clock mod updating-frequency = 0 
  [  
   ask events [ set color yellow ]
   update-qubits
   quantum-projections
   event-occurrences
   ask events with [occurrence = 1] [ set color red ] ]
  if [occurrence] of turtle 7 = 1 [ stop ]
end





;;;;;;;;;;;;;;;;;;;
; GAME PROCEDURES ;
;;;;;;;;;;;;;;;;;;;


to update-qubits
  
  ask events [ set F psi_1 * b * (1 - psi_1) ]
  
  ask links [ set source-occurrence (list [ F ] of both-ends) ]
  
  ask events [ set psi_1 (1 - epsilon - delta) * F + epsilon * (1 / (sum [coupling-strength] of my-in-links)) * sum [item 0 (reduce * source-occurrence) * coupling-strength] of my-in-links + delta * random-float 1.000 ]
  
  ask events with [who != [who] of turtle 6] [ ifelse [occurrence] of turtle 6 = 1 [ set psi_1 (1 - UN-negotiation-eff) * psi_1 + UN-negotiation-eff * (1 - UN-impact) * psi_1 ] [ set psi_1 psi_1 ] ]
  
  ask events [ set psi_0 sqrt( 1 - psi_1 ^ 2 ) ]
end


to quantum-projections
  ask events [ set P-threat psi_1 ^ 2 ]
  ask events [ set size 1 + P-threat * 3 ]
end


to event-occurrences
  ask events [ ifelse random-float 1.000 <= P-threat [ set occurrence 1 ] [ set occurrence 0 ] ]
  ask countries [ set size 2 + mean [occurrence] of events * 12 ]
  ask turtle 6 [ if ([occurrence] of turtle 4 = 1 or [occurrence] of turtle 7 = 1) [set occurrence 1] ]
end

;;;;;;;;;;;;;;;;;;;;
; SETUP PROCEDURES ;
;;;;;;;;;;;;;;;;;;;;


to setup-events
  create-ordered-events 8 [ fd 8 rt 180 ]
  ask events [ set color yellow ]
  
end



to setup-morphic-web
  ; the user should adapt this procedure to the event list linkages that the user wants to model
  ; in the present, as an example, we use the eight events:
  
  ; 1 - Growing tensions between the two countries: turtle 0
  ; 2 - Political turmoil in country-to-country relations: turtle 1
  ; 3 - Failure to negociate: turtle 2
  ; 4 - Civil unrest: turtle 3
  ; 5 - Break out of conflict: turtle 4
  ; 6 - Nuclear threat escalation: turtle 5
  ; 7 - UN intervention/mediation: turtle 6
  ; 8 - Nuclear war scenario: turtle 7
  
  ask turtle 0 
    [ set label "growing tensions"
      create-link-to turtle 1 [ set coupling-strength medium ] ; political turmoil coupling
      create-link-to turtle 2 [ set coupling-strength medium ] ; failure to negotiate coupling
      create-link-to turtle 3 [ set coupling-strength low ] ; civil unrest coupling
      create-link-to turtle 4 [ set coupling-strength low ] ; war break out
      create-link-to turtle 7 [ set coupling-strength medium ] ] ; UN intervention/mediation coupling
    
  ask turtle 1
    [ set label "political turmoil"
      create-link-to turtle 0 [ set coupling-strength high ] ; growing tensions coupling
      create-link-to turtle 2 [ set coupling-strength high ] ; failure to negotiate coupling
      create-link-to turtle 3 [ set coupling-strength high ] ] ; civil unrest coupling

  ask turtle 2
    [ set label "failure to negociate"
      create-link-to turtle 0 [ set coupling-strength high ] ; growing tensions coupling
      create-link-to turtle 1 [ set coupling-strength high ] ; political turmoil coupling
      create-link-to turtle 3 [ set coupling-strength high ] ; civil unrest coupling
      create-link-to turtle 4 [ set coupling-strength high ] ; war break out
      create-link-to turtle 6 [ set coupling-strength high ] ] ; UN intervention/mediation coupling
  
  ask turtle 3
    [ set label "civil unrest"
      create-link-to turtle 0 [ set coupling-strength high ] ; growing tensions coupling
      create-link-to turtle 1 [ set coupling-strength high ] ; political turmoil coupling
      create-link-to turtle 4 [ set coupling-strength medium ] ; conflict break out coupling
      create-link-to turtle 6 [ set coupling-strength high ] ] ; UN intervention/mediation coupling

  ask turtle 4
    [ set label "conflict break out"
      create-link-to turtle 0 [ set coupling-strength high ] ; growing tensions coupling
      create-link-to turtle 1 [ set coupling-strength high ] ; political turmoil coupling
      create-link-to turtle 2 [ set coupling-strength high ] ; failure to negotiate coupling
      create-link-to turtle 6 [ set coupling-strength 1 ] ; UN intervention/mediation coupling
      create-link-to turtle 5 [ set coupling-strength medium ] ] ; nuclear threat escalation
  
  ask turtle 5
    [ set label "nuclear threat escalation"
      create-link-to turtle 0 [ set coupling-strength high ] ; growing tensions coupling
      create-link-to turtle 1 [ set coupling-strength high ] ; political turmoil coupling
      create-link-to turtle 2 [ set coupling-strength high ] ; failure to negotiate coupling
      create-link-to turtle 6 [ set coupling-strength 1 ] ; UN intervention/mediation coupling
      create-link-to turtle 7 [ set coupling-strength high ] ] ; nuclear war coupling
  
  ask turtle 6 [ set label "UN intervention/mediation" ]
  
  ask turtle 7 
  [ set label "nuclear war"
    create-link-to turtle 6 [ set coupling-strength 1 ] ]
  
  ask events [ set label-color black ]
      
    
  
end


to setup-initial-qubit
  ask events [ set psi_0 1 set psi_1 0 set occurrence 0 ] ; no threats initially active other than...
  
  ask turtle 0 ; there is a 0.1 weight for the branch in which growing tensions begin to take hold
  [ set psi_1 sqrt(random-float 0.01000)
    set psi_0 sqrt(1 - (psi_1) ^ 2)
    set occurrence 0 ]
  
  ask events [ ask events [ set P-threat psi_1 ^ 2 ] ]
  
end


to setup-countries
  ask patch -5 20
  [ sprout-countries 1
    [ set country-id-code "A"
      set color red
      set size 2
      set label country-id-code ] ]
  
  ask patch 5 20
  [ sprout-countries 1
    [ set country-id-code "B"
      set color blue
      set size 2
      set label country-id-code ] ]
  
  ask countries [ set label-color black ]
  
end
@#$#@#$#@
GRAPHICS-WINDOW
526
24
995
514
25
25
9.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
ticks
30.0

BUTTON
37
48
100
81
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
35
106
197
139
UN-negotiation-eff
UN-negotiation-eff
0
1
0.9
0.01
1
NIL
HORIZONTAL

SLIDER
38
157
130
190
b
b
0
4
4
0.01
1
NIL
HORIZONTAL

SLIDER
147
157
239
190
epsilon
epsilon
0
1
0.7
0.01
1
NIL
HORIZONTAL

BUTTON
129
47
271
80
NIL
play-quantum-game
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
206
106
302
139
UN-impact
UN-impact
0
1
0.95
0.05
1
NIL
HORIZONTAL

MONITOR
35
266
204
311
NIL
count events with [size > 1]
17
1
11

SLIDER
259
156
351
189
delta
delta
0
1
1.0E-4
0.0001
1
NIL
HORIZONTAL

SLIDER
38
213
202
246
updating-frequency
updating-frequency
0
100000
100000
1000
1
NIL
HORIZONTAL

@#$#@#$#@
## THE MODEL

This is a risk quantum simulator that addresses the evolution of the political relations between two countries leading up to the threat of nuclear war, introduced in the article:

Gon_alves, C.P. (2012). "Risk Mathematics and Quantum Games on Quantum Risk Structures - A Nuclear War Scenario Game" arXiv:1211.6683 [physics.soc-ph] (http://arxiv.org/abs/1211.6683).


The model was built for both research and use in the classroom in roleplaying sessions on decision making techniques and risk analysis, as well as in the building up of scenario analysis.

The model applies quantum game theory with coupled stochastic chaotic gates leading to a coevolution of political scenarios, that involve increased social, military and political tension between the two countries.

There are eight main risk factors are addressed in the model:


- Growing tensions: this corresponds to situations that lead to growing political tensions between the two countries linked to conflicts of interest, possible diplomatic incidents, economic and political competition with possible military fallout.


- Political turmoil: this includes internal and external political turmoil involving the two countries tension issues, it can lead to both demonstrations and actions of supporters of each country in the streets, and political instability due to political statements and actions undertaken by both countries.


- Failure to negotiate: this corresponds to failure of both countries in finding an aggreement on key issues, that may prevent the countries from communicating and finding diplomatic sollutions to their grievances.


- Civil unrest: when people take to the streets in protest on both internal problems and problems involving both countries, it also includes the possibility of social disorder and possible escalade in street violence linked to key problems that divide the two countries.


- Conflict breakout: this corresponds to a conflict breakout between the two countries involving conventional non-nuclear arsenal.


- Nuclear threat escalation: escalation of nuclear threat, that is escalation in the threat of both countries using their nuclear arsenal.


- UN intervention/mediation: this corresponds to attempts of UN to influence both countries in finding common ground and mediating political negotiations between both countries, but it also entails deliberations and actions that can be taken by UN's Security Council in the case of military conflict between the two countries or of nuclear weapons being used.


- Nuclear war: this corresponds to both countries using nuclear weapons on each other triggering a nuclear war.


The occurrence of each risk factor-related event is addressed in terms of a quantum game played on a quantum computing network, with path-dependent unitary gate updating. The quantum game framework is explained further on in the "MODEL FORMALIZATION" section below, which provides for the full model description and interpretation.


At each game round the user clicks on the button play-quantum-game, this leads to an evolution in the relations between the two countries. As each threat increases in probability of occurrence (see the next section for a proper interpretation of probabilities), the circle corresponding to the event starts to grow, whenever the threat takes place the circle turns from yellow color to red.

Simultaneously, the countries flag size also increases from its base size with the mean number of events.

The user can apply the model in a scenario event generator by registering each event in a word file and reading afterwards the sequence of what took place. Multiple simulations, ran a number of N steps can provide for a database for the occurrence of Nuclear War.

The different possible paths to Nuclear War can be enumerated and incorporated in an analysis of early warning systems.

Likewise, in a roleplaying session, the students can be divided into groups and events are relayed to them in real time, with each group assessing scenarios risk and measures.

The user and students can control six sliders, three of these relate to UN intervention parameters (the formal explanation of each of them is addressed in the next section):

UN-negotiation-eff : this is the UN negotiation effectiveness reduces the probability of the event taking place;

UN-impact : this is the impact of the UN under UN mediation, it counts as the influence of the UN upon the two countries;

UN-analysis-coupling : this slider influences the UN threat assessment and, therefore, the propensity of the UN to intervene.



The user may address the level of UN intervention and impact to see how the risk for a nuclear escalation and nuclear war changes.

Students may also change these sliders in a on-class decision interactive game.


b : this slider controls the quantum coupled logistic map that emerges as an order parameter dynamics from each risk factor's quantum evolution;

epsilon : this slider controls the coupling of the logistic map to the mean field of linked risk situations (see the next section for further details);

delta ; this slider controls the noise level in the coupled logistic map, so that there is a stochastic chaotic unitary gate selection for the quantum evolution, expressing evolutionary social, political and military conditions between the two countries.

The updating frequency of the slider allows you to slow down each model's steps so that you can visualize better the evolution of the unfolding scenarios.


The game stops when nuclear war is reached.



## CREDITS AND REFERENCES

The main reference for the model is the article that provides the quantum theoretical background for the model as well as provides for the full model formalism:

Gon_alves, C.P. (2012). "Risk Mathematics and Quantum Games on Quantum Risk Structures - A Nuclear War Scenario Game" arXiv:1211.6683 [physics.soc-ph] (http://arxiv.org/abs/1211.6683).


The current model is also an integrating part of the research and teaching umbrella project under development by the author at Instituto Superior de Ci_ncias Sociais e Pol_ticas (ISCSP), Technical University of Lisbon:

COMPLEX QUANTUM SYSTEMS SCIENCE AND RISK MATHEMATICS (CQSSRM)

URL: https://sites.google.com/site/quantumcomplexity/

For academic reference the model should be quoted as:

Gon_alves, C.P. 2012. "Risk Simulator I - Nuclear War". CQSSRM - "Risk Simulator".


The model has been used on the author's lectures on "Decision Making Techniques" at the Masters Course in Strategy at ISCSP as a roleplaying and game theory-based scenario building tool. It has also been used in demonstrations of combined modeling and data analysis applied to geopolitical problems in the author's data analysis classes.

Other references dealing with risk mathematics and with some of the formalism introduced in arXiv:1211.6683 [physics.soc-ph] are:

- "A Systems Theoretical Formal Logic for Category Theory", 2009, Gon_alves, C.P. and Madeira, M.O., http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1396841

- "Chaos, Artificial Life and Risk Mathematics", 2010, Gon_alves, C.P. and Madeira, M.O., http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1659253.

- "Risk Governance - A Framework for Risk Science-Based Decision Support Systems", 2012, Gon_alves, C.P., http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2085482
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment4" repetitions="1000" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>play-quantum-game</go>
    <exitCondition>[occurrence] of turtle 7 = 1</exitCondition>
    <metric>clock</metric>
    <metric>count events with [size &gt; 1]</metric>
    <enumeratedValueSet variable="b">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="delta">
      <value value="1.0E-4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="UN-impact">
      <value value="0.95"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="epsilon">
      <value value="0.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="UN-negotiation-eff">
      <value value="0.9"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
