library(tidyverse)     #%>% 
library(janitor)       #Remove_empty()

#First: Create a folder called "Results" in the same project folder, and inside it place all the files created when modeling.

#Second: Import the file(s).
Folder <- "Results/"
Folder_txt <- list.files(path = Folder, pattern = "\\.txt$")

Read_txt <- function(Folder_txt) {
  DATA <- read.csv(paste0(Folder, Folder_txt), sep = ";", dec = ".", header=TRUE, stringsAsFactors = F, na.strings = "")[-1]
  DATA <- DATA %>% remove_empty("rows")
  DATA$Experiment <- str_replace(Folder_txt, "\\.txt$", "")
  return(DATA)}

Full_DATA <- map_df(Folder_txt, Read_txt)
Full_DATA <- Full_DATA %>% mutate_at(vars(Origin, Counter_who, Cytotype_who, Counter_ID, Experiment), as.factor)
Full_DATA <- Full_DATA %>% mutate_at(vars(xcor, ycor, E, Mother_E, Surrounding_2x_E, Bilateral_polyploidization, Unilateral_polyploidization, Prop_4x, Number_of_Plants, Counter, Generation), as.numeric)

#Third: Create the different data groups.
Initial_Population <- Full_DATA %>% group_by(Experiment) %>% filter(Counter_ID %in% na.omit(Counter_ID)) #& Cytotype_who == "4x"
Initial_Event <- Full_DATA %>% group_by(Experiment) %>% filter(Counter_who %in% na.omit(Counter_ID))
Polyploidization <- Full_DATA %>% group_by(Experiment) %>% filter(Bilateral_polyploidization %in% na.omit(Bilateral_polyploidization))
Unsuccessfully <- Full_DATA %>% group_by(Experiment) %>% filter(!Counter_who %in% Counter_ID)

#Fourth: Group the results by counter (repetition)
All_Counters <- expand_grid(Experiment = unique(Polyploidization$Experiment),Counter = unique(Polyploidization$Counter))
Initial_Population_counter <- All_Counters %>% left_join(Initial_Population, by = c("Experiment", "Counter")) %>%
  mutate(Generation = coalesce(Generation, Polyploidization$Generation[match(paste(Experiment, Counter), paste(Polyploidization$Experiment, Polyploidization$Counter))]))
Initial_Event_counter <- All_Counters %>% left_join(Initial_Event, by = c("Experiment", "Counter")) %>%
  mutate(Generation = coalesce(Generation, Polyploidization$Generation[match(paste(Experiment, Counter), paste(Polyploidization$Experiment, Polyploidization$Counter))]))
Unsuccessfully_Event_counter <- All_Counters %>% left_join(Unsuccessfully, by = c("Experiment", "Counter")) %>%
  mutate(Generation = coalesce(Generation, Polyploidization$Generation[match(paste(Experiment, Counter), paste(Polyploidization$Experiment, Polyploidization$Counter))]))

#############################Values Fig. 3###################################### 

DATA_Event_by_Counter <- Initial_Event_counter %>% 
  group_by(Counter, Experiment) %>%
  summarize("SPE" = sum(!is.na(Counter_who))) %>% ungroup()

DATA_polyploidization <- Polyploidization %>% 
  group_by(Counter, Experiment) %>%
  summarize("4x_proportion" = Prop_4x) %>% ungroup()               

Index <- data.frame(Experiment=DATA_polyploidization$Experiment, Index=(DATA_polyploidization$"4x_proportion" / DATA_Event_by_Counter$SPE))
Index$Index[!is.finite(Index$Index)] <- 0 #Index <- as.data.frame(Index[is.finite(rowSums(Index)),])
#write.table(Index, file="Index.csv",sep = ";", row.names = F)

Index_summary <- Index %>% 
  group_by(Experiment) %>% 
  summarize("Index Mean" = round(mean(Index),2),
            "Index SD" = round(sd(Index),2))

#write.table(Index_summary, file="Index_summary.csv",sep = ";", row.names = F)

##################################SPE########################################### 

DATA_Event_by_Counter <- Initial_Event_counter %>% 
  group_by(Counter, Experiment) %>%
  summarize("SPE" = sum(!is.na(Counter_who))) %>% ungroup()

SPE <- DATA_Event_by_Counter %>% group_by(Experiment) %>%
  summarize("m_SPE" = round(mean(SPE),2),
            "SD_SPE" = round(sd(SPE),2)) %>% ungroup()

#########################E and generation of all SPE############################

DATA_SPE <- Initial_Event_counter %>% group_by(Experiment) %>%
  summarize("all_FSPE" = ifelse(any(!is.na(E)),round(mean(E, na.rm = TRUE), 2), NA),
            "SD_all_FSPE" = ifelse(any(!is.na(E)),round(sd(E, na.rm = TRUE), 2), NA),
            "m_all_GSPE" = ifelse(any(!is.na(E)),round(mean(Generation[Generation < 1000], na.rm = TRUE), 0), NA),
            "SD_all_GSPE" = ifelse(any(!is.na(E)),round(sd(Generation[Generation < 1000], na.rm = TRUE), 0), NA)) %>% ungroup()

########################E and generation of First SPE###########################

DATA_Event_first <- Initial_Event_counter %>% group_by(Counter, Experiment) %>%     
  top_n(-1, Generation) %>%  ungroup()

DATA_SPE_first <- DATA_Event_first %>% group_by(Experiment) %>%
  summarize("m_first_FSPE" = ifelse(any(!is.na(E)),round(mean(E, na.rm = TRUE), 2), NA),
            "SD_first_FSPE" = ifelse(any(!is.na(E)),round(sd(E, na.rm = TRUE), 2), NA),
            "m_first_FSPE_Mother" = ifelse(any(!is.na(Mother_E)),round(mean(Mother_E, na.rm = TRUE), 2), NA),
            "SD_first_FSPE_Mother" = ifelse(any(!is.na(Mother_E)),round(sd(Mother_E, na.rm = TRUE), 2), NA),
            "m_first_FSPE_Surrounding_2x" = ifelse(any(!is.na(Surrounding_2x_E)),round(mean(Surrounding_2x_E, na.rm = TRUE), 2), NA),
            "SD_first_FSPE_Surrounding_2x" = ifelse(any(!is.na(Surrounding_2x_E)),round(sd(Surrounding_2x_E, na.rm = TRUE), 2), NA),
            "m_first_GSPE" = ifelse(any(!is.na(E)),round(mean(Generation[Generation < 1000], na.rm = TRUE), 0), NA),
            "SD_first_GSPE" = ifelse(any(!is.na(E)),round(sd(Generation[Generation < 1000], na.rm = TRUE), 0), NA)) %>% ungroup()

####Generation from first SPE until first Polyploid Initial Population (GPIP)###

DATA_Population_first <- Initial_Population_counter %>% group_by(Counter, Experiment) %>%      
  top_n(-1, Generation) %>% group_by(Experiment) %>%
  summarize("m_GIP" = ifelse((mean(Generation) < 1000), round((mean(Generation[Generation < 1000])),0), NA)) %>% ungroup()

GPIP <- data.frame(Experiment=DATA_Population_first$Experiment, GPIP=(DATA_Population_first$m_GIP - DATA_SPE_first$m_first_GSPE))

################################All UPE#########################################

DATA_Unsuccessfully_Event_by_Counter <- Unsuccessfully_Event_counter %>% group_by(Counter, Experiment) %>%
  summarize("UPE" = sum(!is.na(Counter_who))) %>% ungroup()

UPE <- DATA_Unsuccessfully_Event_by_Counter %>% group_by(Experiment) %>%
  summarize("m_UPE" = round(mean(UPE), 2),
            "SD_UPE" = round(sd(UPE), 2)) %>% ungroup()

################################E all UPE#######################################

DATA_UPE <- Unsuccessfully_Event_counter %>% group_by(Experiment) %>%
  summarize("all_FUPE" = ifelse(any(!is.na(E)),round(mean(E, na.rm = TRUE), 2), NA),
            "SD_all_FUPE" = ifelse(any(!is.na(E)),round(sd(E, na.rm = TRUE), 2), NA))  %>%
  ungroup()

##############################UPE, 3x and 4x####################################

DATA_Unsuccessfully_Event_by_Counter2 <- Unsuccessfully_Event_counter %>% group_by(Counter, Experiment, Cytotype_who) %>%
  summarize("UPE" = sum(!is.na(Counter_who))) %>% ungroup()

UPE2 <- DATA_Unsuccessfully_Event_by_Counter2 %>% group_by(Experiment, Cytotype_who) %>%
  summarize("m_UPE" = round(mean(UPE), 2),
            "SD_UPE" = round(sd(UPE), 2)) %>%
  ungroup() %>%
  pivot_wider(names_from = Cytotype_who,
              values_from = c("m_UPE", "SD_UPE"),
              names_sep = "_")

##############################E UPE, 3x and 4x##################################

DATA_UPE2 <- Unsuccessfully_Event_counter %>% group_by(Experiment, Cytotype_who) %>%
  summarize("all_FUPE" = ifelse(any(!is.na(E)),round(mean(E, na.rm = TRUE), 2), NA),
            "SD_all_FUPE" = ifelse(any(!is.na(E)),round(sd(E, na.rm = TRUE), 2), NA))  %>%
  ungroup() %>%
  pivot_wider(names_from = Cytotype_who,
              values_from = c("all_FUPE", "SD_all_FUPE"),
              names_sep = "_")

######################E and generation of First UPE#############################

DATA_Unsuccessfully_Event_first <- Unsuccessfully_Event_counter %>% group_by(Counter, Experiment) %>%     
  top_n(-1, Generation) %>%  ungroup()
            
DATA_UPE_first <- DATA_Unsuccessfully_Event_first %>% group_by(Experiment, Cytotype_who) %>%
  summarize("m_first_FUPE" = ifelse(any(!is.na(E)),round(mean(E, na.rm = TRUE), 2), NA),
            "SD_first_FUPE" = ifelse(any(!is.na(E)),round(sd(E, na.rm = TRUE), 2), NA),
            "m_first_FUPE_Mother" = ifelse(any(!is.na(Mother_E)),round(mean(Mother_E, na.rm = TRUE), 2), NA),
            "SD_first_FUPE_Mother" = ifelse(any(!is.na(Mother_E)),round(sd(Mother_E, na.rm = TRUE), 2), NA),
            "m_first_FUPE_Surrounding_2x" = ifelse(any(!is.na(Surrounding_2x_E)),round(mean(Surrounding_2x_E, na.rm = TRUE), 2), NA),
            "SD_first_FUPE_Surrounding_2x" = ifelse(any(!is.na(Surrounding_2x_E)),round(sd(Surrounding_2x_E, na.rm = TRUE), 2), NA),
            "m_first_GUPE" = ifelse(any(!is.na(Generation)),round(mean(Generation[Generation < 1000], na.rm = TRUE), 0), NA),
            "SD_first_GUPE" = ifelse(any(!is.na(Generation)),round(sd(Generation[Generation < 1000], na.rm = TRUE), 0), NA)) %>%
  ungroup() %>%
  pivot_wider(names_from = Cytotype_who,
              values_from = c("m_first_FUPE","SD_first_FUPE","m_first_FUPE_Mother","SD_first_FUPE_Mother","m_first_FUPE_Surrounding_2x","SD_first_FUPE_Surrounding_2x","m_first_GUPE","SD_first_GUPE"),
              names_sep = "_")

##################################Origin SPE####################################

DATA_SPE_by_Origin <- Initial_Event_counter %>% group_by(Origin, Experiment) %>%
  summarize("SPE" = ifelse(any(!is.na(Counter_who)),sum(!is.na(Counter_who)), NA)) %>% group_by(Experiment) %>%
  mutate("Total SPE" = sum(na.omit(SPE)))

DATA_SPE_Origin <- data.frame(Origin=paste0("SPE_",DATA_SPE_by_Origin$Origin), 
                              Experiment=DATA_SPE_by_Origin$Experiment, 
                              Proportion=round((DATA_SPE_by_Origin$SPE / DATA_SPE_by_Origin$`Total SPE`),2)) %>% 
                  pivot_wider(names_from = Origin,
                              values_from = Proportion,
                              values_fill = 0) %>% select_if(~ !all(is.na(.)))
  
##################################Origin UPE####################################

DATA_UPE_by_Origin <- Unsuccessfully_Event_counter %>% group_by(Origin, Experiment) %>%
  summarize("UPE" = ifelse(any(!is.na(Counter_who)),sum(!is.na(Counter_who)), NA)) %>% group_by(Experiment) %>%
  mutate("Total UPE" = sum(na.omit(UPE)))

DATA_UPE_Origin <- data.frame(Origin=paste0("UPE_",DATA_UPE_by_Origin$Origin), 
                              Experiment=DATA_UPE_by_Origin$Experiment, 
                              Proportion=round((DATA_UPE_by_Origin$UPE / DATA_UPE_by_Origin$`Total UPE`),2)) %>% pivot_wider(
                              names_from = Origin,
                              values_from = Proportion,
                              values_fill = 0) %>% select_if(~ !all(is.na(.)))

################################################################################

DATA_polyploidization <- Polyploidization %>% group_by(Experiment) %>% 
  summarize("m_Bilateral_polyploidization" = round((mean(Bilateral_polyploidization)),2),
            "SD_Bilateral_polyploidization" = round(sd(Bilateral_polyploidization),2),
            "m_Unilateral_polyploidization" = round((mean(Unilateral_polyploidization)),2),
            "SD_Unilateral_polyploidization" = round(sd(Unilateral_polyploidization),2),
            "m_4x Prop." = round(mean(Prop_4x),2),
            "SD_4x Prop." = round(sd(Prop_4x),2),
            "m_GuF" = ifelse((mean(Generation) < 1000), round((mean(Generation)),0), NA),
            "SD_GuF" = ifelse((mean(Generation) < 1000), round((sd(Generation)),0), NA))

#####################################END########################################