breed [gametes gamete]
Breed [fish a-fish]
breed [predators predator]

globals [cm iter lo]
gametes-own [allele]
fish-own [genotype plate erg speed]


;===========

to-report years
  report ticks / 150
end

to-report number-big-a
  report length (word 0 [genotype] of fish) - length (remove "A" (word 0 [genotype] of fish))      ;report total number of "A"
end

to-report number-small-a
report length (word 0 [genotype] of fish) - length (remove "a" (word 0 [genotype] of fish))      ;report total number of "a"
end

to-report freq-big-a
  report number-big-a / (number-big-a + number-small-a)   ;report allele frequency of "A"
end

to-report freq-small-a
  report number-small-a / (number-big-a + number-small-a)  ;report allele frequency of "a"
end

to-report freq-complete
  report (count fish with [plate >= 23]) /(count fish)
end

to-report freq-intermediate
  report (count fish with [plate >= 13 and plate < 23]) / (count fish)
end

to-report freq-low
  report (count fish with [plate < 13]) / (count fish)
end

to smooth-line
  set cm cm * 0.9 + ( 1 - 0.9 ) * (count fish with [plate >= 23])
  set iter iter * 0.9 + ( 1 - 0.9 ) * (count fish with [plate >= 13 and plate < 23])
  set lo lo * 0.9 + ( 1 - 0.9 ) * (count fish with [plate < 13])
end



;============

to setup
  ca
   setup-gametes
   fertilization
   setup-predator
   setup-patches

   set cm (count fish with [plate >= 23])
   set iter (count fish with [plate >= 13 and plate < 23])
   set lo (count fish with [plate < 13])

  reset-ticks
end

;==============

to setup-gametes                        ;set number of gametes     there is no need to make sperms and eggs in this case
 create-gametes starting-population-size * 2
 [gamete-traits
   ifelse random 10 < (Eda-allele-ratio * 10) [set allele "A"][set allele "a"]
 ]
end

to gamete-traits
    set shape "dot"
    set color 82   ;set gamate same as background
    set size 0.5
    setxy random-xcor random-ycor
end

to fertilization
  ask gametes [
    let mate one-of other gametes
    if mate != nobody[
    hatch-fish 1
    [;set heading -10 + random 20
      set erg 20                  ;set energy level
     set size  3
     set genotype word [allele] of myself [allele] of mate  ;set genotype
     setup-phenotype                                        ;set phenotype shape here
     setup-shape-color
     setup-fish-speed
     setxy random-xcor random-ycor]
    ask mate [die]
    die]]
end

to setup-phenotype            ;change phenotype shape here
  if genotype = "AA" [set plate (24 + random 10)]
  if genotype = "Aa" [set plate (24 + random 10)]
  if genotype = "aA" [set plate (24 + random 10)]
  if genotype = "aa" [set plate (3 + random 10)]
  if random 20 = 0 [set plate (13 + random 10)]         ;intermediate morph due to other genetic modifiers
end

to gametogenesis
   ask fish with [genotype = "AA"]
   [if erg >= 40
            [hatch-gametes 2
              [gamete-traits
                ifelse mutation?
                [ifelse random 20 = 0 [set allele "a" ][set allele "A" ]]
                [set allele "A"]]
   set erg erg - 20]]

   ask fish with [genotype = "aa"]
   [if erg >= 40
            [hatch-gametes 2
              [gamete-traits
                ifelse mutation?
                [ifelse random 20 = 0 [set allele "A" ][set allele "a" ]]
                [set allele "a"]]
   set erg erg - 20]]

   ask fish with [genotype = "Aa"]
   [if erg >= 40
           [hatch-gametes 1
             [gamete-traits
               ifelse mutation?
                [ifelse random 20 = 0 [set allele "a" ][set allele "A" ]]
                [set allele "A"]
            hatch-gametes 1
             [gamete-traits
               ifelse mutation?
                [ifelse random 20 = 0 [set allele "A" ][set allele "a" ]]
                [set allele "a"]]]
   set erg erg - 20]]

   ask fish with [genotype = "aA"]
   [if erg >= 40
           [hatch-gametes 1
             [gamete-traits
               ifelse mutation?
                [ifelse random 20 = 0 [set allele "A" ][set allele "a" ]]
                [set allele "a"]
            hatch-gametes 1
             [gamete-traits
               ifelse mutation?
                [ifelse random 20 = 0 [set allele "a" ][set allele "A" ]]
                [set allele "A"]]]
   set erg erg - 20]]


end

to setup-patches
 ask patches [set pcolor 93]
end

to setup-fish-speed
  set speed (-0.1 * plate + 9.3)
end

to setup-shape-color
  if plate >= 23 [set shape "armor-1" set color 36]
  if plate < 23 and plate >= 13 [set shape "armor-2" set color 37]
  if plate < 13 [set shape "armor-3" set color 38]
end

to setup-predator
create-predators Number-of-predators
  [set size 7
  set color 86
  set shape "predator-1"
  set heading -15 + random 30
  setxy random-xcor random-ycor]
end

;=========================================
to go
  tick
  if count fish <= 0 [stop]
  if ticks >= years-to-run * 150 [stop]
  update-setup-predator
  move
  food
  death
  predation
  reproduce
  regrow-food
  smooth-line
end

;==========================================

to update-setup-predator
  if count predators != Number-of-predators
  [ask predators [die]
    setup-predator]
end

 to move
   ask fish [
     fd 0.25 set erg erg - 1]
 end

to predation
  if any? predators
  [ask predators[
      setxy random-xcor random-ycor
      let preys fish-here
      let prey min-one-of preys with [speed < 8.6] [speed] ; prey on slowest individual among those are slower than 8.6
      if prey != nobody
      [ask prey [die]]
  ]]
end

to food       ;set food consumption
 ask fish [ if pcolor > 92 [set erg erg + 1.185 set pcolor pcolor - 0.25]]
end

to death
  ask fish [if erg <= 0 [die]]
end

to reproduce
  gametogenesis
  fertilization
end

to regrow-food
  ask patches with [pcolor <= 92 ] [if random 100 < (available-food * 0.5) [set pcolor 93]]
end
@#$#@#$#@
GRAPHICS-WINDOW
18
158
450
495
-1
-1
8.0
1
10
1
1
1
0
1
1
1
-26
26
-20
20
0
0
1
ticks
12.0

BUTTON
600
33
705
72
Setup/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
453
314
843
494
Distribution of Fish Lateral Plates
# of Plates
Frequency (#)
0.0
35.0
0.0
10.0
true
false
"" ""
PENS
"# of Plate" 1.0 1 -13791810 true "histogram [plate] of fish" "histogram [plate] of fish"

BUTTON
710
33
810
72
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
288
39
442
72
Available-food
Available-food
0
100
100.0
10
1
NIL
HORIZONTAL

PLOT
565
149
843
313
Stickleback Population Size
Year
Freqnency (#)
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"fish" 1.0 0 -16777216 true "plotxy years count fish" "plotxy years count fish"

SLIDER
16
37
246
70
starting-population-size
starting-population-size
0
450
450.0
10
1
NIL
HORIZONTAL

SLIDER
16
75
246
108
Eda-allele-ratio
Eda-allele-ratio
0
1
0.9
0.1
1
NIL
HORIZONTAL

TEXTBOX
41
112
208
130
Allele \"a\"<--      --> Allele \"A\"
11
0.0
1

PLOT
18
496
379
663
Changes in Phenotype Frequencies
Year
Frequency (#)
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"Complete" 1.0 0 -8431303 true "plotxy years cm" "plotxy years cm"
"Partial" 1.0 0 -14439633 true "plotxy years lo" "plotxy years iter"
"Low" 1.0 0 -955883 true "" "plotxy years lo"

TEXTBOX
12
10
281
28
Step 1: Set up starting population size and allele ratio.
10
125.0
1

TEXTBOX
300
10
592
28
Step 2: Choose food resource, predation and mutation. 
10
125.0
1

TEXTBOX
600
10
825
28
Step 3: Confirm settings, set years, and run.
10
125.0
1

MONITOR
453
149
564
190
Total # of fish
count fish
17
1
10

TEXTBOX
18
142
422
160
Step 4: Make observations and collect data.
10
125.0
1

MONITOR
453
190
564
231
Complete armor
count fish with [plate >= 23]
17
1
10

MONITOR
453
272
564
313
Low armor
count fish with [plate < 13]
17
1
10

MONITOR
453
231
564
272
Partial armor
count fish with [plate >= 13 and plate < 23]
17
1
10

MONITOR
705
540
774
581
freq AA
count fish with [genotype = \"AA\"]
17
1
10

MONITOR
705
581
774
622
freq Aa
count fish with [genotype = \"Aa\"] + count fish with [genotype = \"aA\"]
17
1
10

MONITOR
705
622
774
663
freq aa
count fish with [genotype = \"aa\"]
17
1
10

PLOT
381
496
703
663
 Changes in Allele Frequencies
Year
Frequency (%)
0.0
1.0
0.0
1.0
true
true
"" ""
PENS
"freq- \"A\"" 1.0 0 -6459832 true "plotxy years freq-big-a" "plotxy years freq-big-a"
"freq--\"a\"" 1.0 0 -955883 true "plotxy years freq-small-a" "plotxy years freq-small-a"

SWITCH
445
39
564
72
Mutation?
Mutation?
0
1
-1000

MONITOR
774
581
843
622
freq(A)
freq-big-a
2
1
10

MONITOR
774
622
843
663
freq(a)
freq-small-a
2
1
10

INPUTBOX
600
74
705
134
Years-to-run
30.0
1
0
Number

SLIDER
305
75
537
108
Number-of-predators
Number-of-predators
0
10
8.0
1
1
NIL
HORIZONTAL

BUTTON
710
74
811
112
Run a year
repeat 150 [go]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
779
500
843
549
Years
Years
0
1
12

TEXTBOX
15
129
589
147
-------------------------------------------------------------------------------------------------------------
9
5.0
1

@#$#@#$#@
## What is this model?

This model simulates the contemporary evolution of threespine Stickleback of a stickleback population in a hypothetical lake.  This model helps users to explore the changes in allele frequencies resulting from natural selection. 

## Underlying model mechanisms

The following processes serve as the underlying mechanisms of the model.

### Allele frequencies, genotypes, phenotypes
When setting up the simulation, an equal number of sperms and eggs are generated based on the defined population size and Eda allele ratio. Then individual fish is formed via random fertilization, and the fish genotype is determined by the sperm and egg. Once genotypes are determined, phenotypes are determined accordingly: AA, Aa, and aA produce the complete-armored morph (darker individuals), aa produces low-armored morph(lighter individuals). 5% of individuals are intermediate morph (intermediate color) due to other genetic modifiers. The fewer plates are a stickleback bearing, the faster does it swim (The Bell Lab, 2016; Genetic Science Learning Center, 2017).

### Food resource and population size
The stickleback fish needs to obtain energy from the food. The changes in the blue background represent the available food in the lake. The darker the patch is, the less food is available.

Stickleback fish only obtains food from the lighter blue patches, and every move costs some energy. If fish runs out the energy and no food is available from the current patch, it dies.

The slider of "available-food" represents the food resource available for the stickleback population. 

### Reproduction, inheritance, and mutation

When a fish cumulates a certain amount of energy, it produces gametes following Mendelian rules. These gametes randomly pair to form new individuals. Once turning on the mutation, 5 % alleles A and a could mutate to a or A every tick. 

### Predation

The "Number-of-predators" determines the number of dragonfly larvae, the predators, existing in the lake. They will prey on the slowest stickleback fish nearby. 

## Suggested exploration

1. The relationship between the available food and carrying capacity

2. Explore the relationships among allele ratio, number of predators, and mutation.


## Something to note

The food resource in the hypothetical lake is finite. So individual fish competes for food. Even though they move in the lake randomly, sampling errors still leads to slight unequally food resource for each individual. Therefore even you turn off predation and mutation, allele frequencies will change slightly owing to genetic drift.

## CREDITS 

This model is made by Dr. Lin Xiang at Weber State University. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2017). Loberg stickleback-Eda gene. Zoology Department, Weber State University, Ogden, UT.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.


## REFERENCES
1.    The bell lab: Bridging the Gap Between Developmental Genetics and Paleontology https://www.leonschools.net/site/handlers/filedownload.ashx?modelinstanceid=72882&dataid=106049&FileName=bell%20lab%20article.pdf

2.    Stickleback Evolution. Genetic Science Learning Center. (2015, January 7) Learn. Genetics. Retrieved March 21, 2017, from http://learn.genetics.utah.edu/
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

armor-1
false
0
Polygon -7500403 true true 2 147 2 143 19 135 61 125 95 122 138 125 183 138 219 144 242 147 262 148 278 136 293 128 300 135 299 147 297 159 297 171 294 182 288 185 262 161 245 160 222 161 185 165 149 179 115 185 85 186 53 181 32 171 14 160
Polygon -7500403 true true 83 178 87 185 120 210 102 185 95 177
Polygon -7500403 true true 96 133 102 117 112 105 107 121 103 131
Polygon -7500403 true true 128 180 149 189 162 191 165 185 173 178 182 175 194 171 202 162 167 166 141 173
Polygon -7500403 true true 131 126 152 117 163 115 168 121 176 128 185 131 194 136 196 142 170 140 144 133
Polygon -7500403 true true 71 133 81 112 89 98 87 115 82 130
Polygon -7500403 true true 82 172 98 185 123 192 101 179 94 171
Polygon -6459832 true false 5 143 4 143 19 158 31 155 43 164 53 152 57 141 57 127 23 133
Circle -11221820 true false 17 138 12
Circle -16777216 true false 20 141 6
Polygon -6459832 true false 41 174 57 182 66 171 66 149 56 153 48 166
Polygon -6459832 true false 82 126 81 136 81 146 84 154 88 141 86 127
Polygon -6459832 true false 75 128 74 138 74 147 77 150 80 138 79 129
Polygon -6459832 true false 91 125 90 135 90 149 94 160 97 140 96 128
Polygon -6459832 true false 100 127 99 134 99 144 99 157 102 170 105 160 105 142 104 134 103 128
Polygon -6459832 true false 109 126 108 133 108 143 108 156 111 166 114 159 114 141 113 133 112 127
Polygon -6459832 true false 119 126 118 133 118 143 118 156 121 161 124 151 124 141 123 133 122 127
Polygon -6459832 true false 129 127 128 134 128 144 129 151 131 154 134 152 134 142 133 134 132 128
Polygon -6459832 true false 139 127 138 137 138 147 143 147 145 142 143 128
Polygon -6459832 true false 150 129 149 139 149 148 153 146 155 139 154 130
Polygon -6459832 true false 223 148 223 152 222 156 226 155 228 155 227 151
Polygon -6459832 true false 213 148 212 155 212 156 217 156 218 155 217 151
Polygon -6459832 true false 202 146 201 153 201 154 206 154 207 153 206 149
Polygon -6459832 true false 193 144 192 151 192 152 197 152 198 151 197 147
Polygon -6459832 true false 184 140 183 147 185 152 188 150 189 147 188 143
Polygon -6459832 true false 175 136 174 143 176 148 179 146 180 143 179 139
Polygon -6459832 true false 167 133 166 140 167 149 171 145 172 140 171 136
Polygon -6459832 true false 158 132 157 142 157 151 161 149 163 142 162 133
Polygon -6459832 true false 69 131 69 135 70 139 66 138 64 138 65 134

armor-2
false
0
Polygon -7500403 true true 2 147 2 143 19 135 61 125 95 122 138 125 183 138 219 144 242 147 262 148 278 136 293 128 300 135 299 147 297 159 297 171 294 182 288 185 262 161 245 160 222 161 185 165 149 179 115 185 85 186 53 181 32 171 14 160
Polygon -7500403 true true 96 133 102 117 112 105 107 121 103 131
Polygon -7500403 true true 128 180 149 189 162 191 165 185 173 178 182 175 194 171 202 162 167 166 141 173
Polygon -7500403 true true 131 126 152 117 163 115 168 121 176 128 185 131 194 136 196 142 170 140 144 133
Polygon -7500403 true true 71 133 81 112 89 98 86 116 82 130
Polygon -7500403 true true 82 172 98 185 123 192 101 179 94 171
Polygon -6459832 true false 5 143 4 143 19 158 31 155 43 164 53 152 57 141 57 127 23 133
Circle -11221820 true false 17 138 12
Circle -16777216 true false 20 141 6
Polygon -6459832 true false 41 174 57 182 66 171 66 149 56 153 48 166
Polygon -6459832 true false 82 126 81 136 81 146 84 154 88 141 86 127
Polygon -6459832 true false 75 128 74 138 74 147 77 150 80 138 79 129
Polygon -6459832 true false 91 125 90 135 90 149 94 160 97 140 96 128
Polygon -6459832 true false 100 127 99 134 99 144 99 157 102 170 105 160 105 142 104 134 103 128
Polygon -6459832 true false 109 126 108 133 108 143 108 156 111 166 114 159 114 141 113 133 112 127
Polygon -6459832 true false 69 131 69 135 70 139 66 138 64 138 65 134

armor-3
false
0
Polygon -7500403 true true 2 147 2 143 19 135 61 125 95 122 138 125 183 138 219 144 242 147 262 148 278 136 293 128 300 135 299 147 297 159 297 171 294 182 288 185 262 161 245 160 222 161 185 165 149 179 115 185 85 186 53 181 32 171 14 160
Polygon -7500403 true true 96 133 102 117 112 105 107 120 103 131
Polygon -7500403 true true 128 180 149 189 162 191 165 185 173 178 182 175 194 171 202 162 167 166 141 173
Polygon -7500403 true true 131 126 152 117 163 115 168 121 176 128 185 131 194 136 196 142 170 140 144 133
Polygon -7500403 true true 71 133 81 112 89 98 86 116 82 130
Polygon -6459832 true false 5 143 4 143 19 158 31 155 43 164 53 152 57 141 57 127 23 133
Circle -11221820 true false 17 138 12
Circle -16777216 true false 20 141 6
Polygon -6459832 true false 41 174 57 182 66 171 66 149 56 153 48 166
Polygon -6459832 true false 79 128 78 138 78 147 81 150 84 138 83 129
Polygon -6459832 true false 91 125 90 135 90 149 94 160 97 140 96 128

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dead-fish-1
false
0
Circle -11221820 true false 17 138 12
Circle -16777216 true false 20 141 6
Polygon -1 true false 11 144 25 134 40 134 37 147 45 147 57 131 66 128 52 148 63 148 79 127 86 127 71 147 82 147 96 127 105 127 91 147 97 147 113 125 121 126 107 143 105 147 114 147 125 129 132 129 120 147 129 146 138 133 145 133 134 147 146 146 154 135 159 135 151 145 163 145 171 136 175 136 165 145 242 120 257 90 261 95 246 119 263 99 267 105 249 119 268 109 269 114 253 121 270 119 270 129 247 124 167 150 184 163 180 163 163 151 153 151 168 164 165 166 149 151 138 153 158 170 153 172 134 155 122 155 140 173 134 174 117 156 108 155 124 177 120 179 102 156 94 156 107 180 100 181 85 156 74 156 85 182 82 182 66 156 55 156 65 176 60 176 49 155 44 155 53 174 25 162 10 147
Circle -16777216 true false 20 140 10

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

guppy-drabbest
false
15
Polygon -14835848 true false 0 142 11 136 92 119 118 119 122 102 152 105 139 122 216 138 251 106 283 95 296 121 290 138 296 151 288 168 296 181 283 208 251 196 216 163 176 166 151 167 156 181 162 198 146 192 131 181 115 170 85 175 44 174 9 162
Circle -16777216 true false 8 142 12
Polygon -7500403 true false 40 132 90 124
Polygon -10899396 true false 39 132 90 122 120 121 142 126 114 134 90 135
Circle -13791810 true false 246 121 24

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

predator
false
0
Polygon -7500403 true true 9 147 17 144 25 141 35 141 42 140 49 135 64 134 80 134 93 134 108 133 112 130 129 126 149 126 186 126 188 122 191 119 197 119 202 124 202 131 205 136 211 136 215 140 216 145 215 150 209 152 203 150 199 145 194 144 190 146 186 154 180 156 172 156 162 156 141 156 123 155 106 155 94 155 74 154 58 151 34 151 20 153 3 153
Polygon -7500403 true true 111 151 106 163 92 168 108 167 115 153
Polygon -7500403 true true 133 152 141 160 119 173 116 181 140 206 138 217 142 217 145 206 123 179 147 163 146 150
Polygon -7500403 true true 155 152 163 160 142 177 141 182 172 200 171 211 175 208 176 199 149 179 169 163 168 150
Polygon -7500403 true true 173 150 181 158 178 173 178 180 203 181 207 183 213 181 205 177 182 177 186 159 182 149
Polygon -7500403 true true 185 148 213 164 250 142 261 147 274 150 287 142 271 142 261 139 257 135 264 125 269 117 259 121 253 128 249 136 242 143 217 158 210 158 190 143 186 144

predator-1
true
0
Polygon -7500403 true true 9 147 17 144 25 141 35 141 42 140 49 135 64 134 80 134 93 134 108 133 112 130 129 126 149 126 186 126 188 122 191 119 197 119 202 124 202 131 205 136 211 136 215 140 216 145 215 150 209 152 203 150 199 145 194 144 190 146 186 154 180 156 172 156 162 156 141 156 123 155 106 155 94 155 74 154 58 151 34 151 20 153 3 153
Polygon -7500403 true true 111 151 106 163 92 168 108 167 115 153
Polygon -7500403 true true 133 152 141 160 119 173 116 181 140 206 138 217 142 217 145 206 123 179 147 163 146 150
Polygon -7500403 true true 155 152 163 160 142 177 141 182 172 200 171 211 175 208 176 199 149 179 169 163 168 150
Polygon -7500403 true true 173 150 181 158 178 173 178 180 203 181 207 183 213 181 205 177 182 177 186 159 182 149
Polygon -7500403 true true 155 133 183 149 222 132 230 133 244 136 249 130 241 127 231 123 229 119 234 110 235 106 229 106 223 113 218 116 210 120 187 143 180 143 160 128 156 129

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

stickleback-1
false
0
Polygon -7500403 true true 40 132 90 124
Polygon -7500403 true true 1 149 29 131 53 121 75 117 93 118 97 86 102 111 109 119 117 119 128 120 141 99 139 116 138 122 167 127 178 120 191 113 209 123 218 133 226 145 249 154 266 144 282 138 294 136 298 145 295 156 290 163 293 171 295 176 292 187 281 188 267 180 254 169 247 165 227 166 193 170 137 176 91 177 30 169 1 152 10 155
Polygon -6459832 false false 91 124 92 140 90 156 84 170 94 172 99 156 100 140 100 126
Polygon -6459832 true false 78 162 80 149 106 143 114 149 109 164 104 173 87 167
Polygon -6459832 true false 57 137 53 154 48 163 38 168 47 160 53 147 54 146
Polygon -6459832 true false 78 127 78 149 73 165 58 172 77 167 81 155 82 144
Polygon -6459832 false false 107 124 108 141 106 156 100 170 110 172 115 156 116 140 116 126
Polygon -6459832 false false 122 125 123 142 121 157 117 171 125 171 130 157 131 141 131 127
Polygon -6459832 false false 138 130 138 142 136 157 132 171 140 171 145 157 146 141 147 133
Polygon -6459832 false false 154 134 153 141 151 156 147 170 155 170 161 157 162 147 162 137
Polygon -6459832 false false 170 138 170 149 167 159 163 168 171 168 175 161 178 152 178 141
Polygon -6459832 false false 185 142 184 148 181 158 177 167 185 167 189 160 192 151 194 144
Polygon -6459832 false false 201 144 200 147 197 157 193 166 201 166 205 159 208 147 207 147
Polygon -6459832 false false 220 150 216 149 214 156 210 165 218 165 222 160 224 156 226 150
Polygon -6459832 false false 237 153 233 153 230 153 227 162 234 162 238 157 235 159 239 155
Polygon -6459832 true false 111 175 129 200 121 176
Circle -1 true false 15 140 14
Circle -16777216 true false 17 142 10
Polygon -1 true false 17 144 22 149 21 147 19 141 17 141
Polygon -7500403 true true 173 174 194 183 210 178 226 165 187 170 169 171
Polygon -6459832 true false 116 175 134 190 126 176

stickleback-2
false
0
Polygon -7500403 true true 40 132 90 124
Polygon -7500403 true true 1 149 29 131 53 121 75 117 93 118 97 86 102 111 109 119 117 119 128 120 141 99 139 116 138 122 167 127 178 120 191 113 209 123 218 133 226 145 249 154 266 144 282 138 294 136 298 145 295 156 290 163 293 171 295 176 292 187 281 188 267 180 254 169 247 165 227 166 193 170 137 176 91 177 30 169 1 152 10 155
Polygon -6459832 false false 91 124 92 140 90 156 84 170 94 172 99 156 100 140 100 126
Polygon -6459832 true false 78 162 80 149 106 143 114 149 109 164 104 173 87 167
Polygon -6459832 true false 57 137 53 154 48 163 38 168 47 160 53 147 54 146
Polygon -6459832 true false 78 127 78 149 73 165 58 172 77 167 81 155 82 144
Polygon -6459832 false false 107 124 108 141 106 156 100 170 110 172 115 156 116 140 116 126
Polygon -6459832 false false 122 125 123 142 121 157 117 171 125 171 130 157 131 141 131 127
Polygon -6459832 false false 138 130 138 142 136 157 132 171 140 171 145 157 146 141 147 133
Polygon -6459832 false false 154 134 153 141 151 156 147 170 155 170 161 157 162 147 162 137
Polygon -6459832 false false 170 138 170 149 167 159 163 168 171 168 175 161 178 152 178 141
Polygon -6459832 false false 185 142 184 148 181 158 177 167 185 167 189 160 192 151 194 144
Polygon -6459832 true false 111 175 129 200 121 176
Circle -1 true false 15 140 14
Circle -16777216 true false 17 142 10
Polygon -1 true false 17 144 22 149 21 147 19 141 17 141
Polygon -7500403 true true 173 174 194 183 210 178 226 165 187 170 169 171
Polygon -6459832 true false 116 175 134 190 126 176

stickleback-3
false
0
Polygon -7500403 true true 40 132 90 124
Polygon -7500403 true true 1 149 29 131 53 121 75 117 93 118 97 86 102 111 109 119 117 119 128 120 141 99 139 116 138 122 167 127 178 120 191 113 209 123 218 133 226 145 249 154 266 144 282 138 294 136 298 145 295 156 290 163 293 171 295 176 292 187 281 188 267 180 254 169 247 165 227 166 193 170 137 176 91 177 30 169 1 152 10 155
Polygon -6459832 false false 91 124 92 140 90 156 84 170 94 172 99 156 100 140 100 126
Polygon -6459832 true false 78 162 80 149 106 143 114 149 109 164 104 173 87 167
Polygon -6459832 true false 57 137 53 154 48 163 38 168 47 160 53 147 54 146
Polygon -6459832 true false 78 127 78 149 73 165 58 172 77 167 81 155 82 144
Polygon -6459832 false false 107 124 108 141 106 156 100 170 110 172 115 156 116 140 116 126
Polygon -6459832 false false 122 125 123 142 121 157 117 171 125 171 130 157 131 141 131 127
Polygon -6459832 false false 138 130 138 142 136 157 132 171 140 171 145 157 146 141 147 133
Circle -1 true false 15 140 14
Circle -16777216 true false 17 142 10
Polygon -1 true false 17 144 22 149 21 147 19 141 17 141
Polygon -7500403 true true 173 174 194 183 210 178 226 165 187 170 169 171

stickleback-4
false
0
Polygon -7500403 true true 40 132 90 124
Polygon -7500403 true true 1 149 29 131 53 121 75 117 93 118 97 86 102 111 109 119 117 119 128 120 141 99 139 116 138 122 167 127 178 120 191 113 209 123 218 133 226 145 249 154 266 144 282 138 294 136 298 145 295 156 290 163 293 171 295 176 292 187 281 188 267 180 254 169 247 165 227 166 193 170 137 176 91 177 30 169 1 152 10 155
Polygon -6459832 false false 91 124 92 140 90 156 84 170 94 172 99 156 100 140 100 126
Polygon -6459832 true false 78 162 80 149 100 141 109 151 106 164 100 172 87 167
Polygon -6459832 true false 57 137 53 154 48 163 38 168 47 160 53 147 54 146
Polygon -6459832 true false 78 127 78 149 73 165 58 172 77 167 81 155 82 144
Polygon -6459832 false false 107 124 108 141 106 156 100 170 110 172 115 156 116 140 116 126
Circle -1 true false 15 140 14
Circle -16777216 true false 17 142 10
Polygon -1 true false 17 144 22 149 21 147 19 141 17 141
Polygon -7500403 true true 173 174 194 183 210 178 226 165 187 170 169 171

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
