globals [x y p1 p2 population-size f-x f-y fly-ID list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9]    ;p1=selected parent 1, p2=selected parent 2,
turtles-own [c1 c2 genotype phenotype gender eye-color wing-shape body-color body-color-1]

breed [sperms sperm]
breed [eggs egg]
breed [flies a-fly]
breed [crosses cross]

to setup
  ca
  set-gametes
  fertilization
  set-tray
  output-results
  reset-ticks

end

to set-gametes

set population-size 15 + random 16

if Cases = "Case 1" [              ;sex-linked eye color character. In this case, the linkage between eye color and sex can be explored.
  create-sperms population-size
  [gamete-trait
    set c1 item random 3 ["XA" "Xa" "Y"]     ;given the three possoibilities, the gender ratio does not start with 1:1 at the beginning but brias to female
    set c2 "BV"                              ;all flies are long-winged with a light body color
    set genotype word c1 c2                  ;form  genotype of gamete
    ]

  create-eggs population-size
  [gamete-trait
    set c1 item random 2 ["XA" "Xa"]
    set c2 "BV"
    set genotype word c1 c2
    ]
  ]

 if Cases = "Case 2" [             ;dihybrid cross  eye color vs wing shape
   create-sperms population-size
  [gamete-trait
    set c1 item random 2 ["XA" "Y"]         ; A and a are  red-eyed and white-eyed alleles.
    set c2 item random 2 ["BV" "Bv"]        ; V and v are wing shape alleles.
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 "XA"
    set c2 item random 2 ["BV" "Bv"]
    set genotype word c1 c2
    ]
  ]


   if Cases = "Case 3" [             ;dihybrid cross eye color vs body color
   create-sperms population-size
  [gamete-trait
    set c1 item random 3 ["XA" "Xa" "Y"]         ; A and a are  red-eyed and white-eyed alleles.
    set c2 item random 2 ["BV" "Bv"]        ; V and v are wing shape color alleles.
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 item random 2 ["XA" "Xa"]
    set c2 item random 2 ["BV" "Bv"]
    set genotype word c1 c2
    ]
  ]



 if Cases = "Case 4" [             ;non-sex-linked wing character & linkage characters. This case is more complicated. Students can explore the linkage between wing shape and body color, and the relatinship between the two chracters and the sex ratio.
   create-sperms population-size
  [gamete-trait
    set c1 item random 2 ["XA" "Y"]         ; All flies are red-eyed.
    set c2 item random 2 ["BV" "bv"]        ; genes B and V are linked, not cross-over at the beginning.
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 "XA"
    set c2 item random 2 ["BV" "bv"]
    set genotype word c1 c2
    ]
  ]



  if Cases = "Case 5" [             ;sex- and non-sex linkage characters.  White-eyed allele is added in.
   create-sperms population-size
  [gamete-trait
    set c1 item random 3 ["XA" "Xa" "Y"]
    set c2 item random 2 ["BV" "bv"]
    set genotype word c1 c2
    ]

  create-eggs population-size
  [gamete-trait
    set c1 item random 2 ["XA" "Xa"]
    set c2 item random 2 ["BV" "bv"]
    set genotype word c1 c2
    ]
  ]
end

to gamete-trait
  set shape "dot"
    set size 0.1
    setxy random-xcor random-ycor
end

to express

  ;;Determine phenotypes based on the allele, then code the phenotypes
  ifelse member? "Y" genotype = true [set gender "male" set size 0.65 set phenotype "m-" ][set gender "female" set size 0.8 set phenotype "f-"]
  ifelse member? "XA" genotype = true [set eye-color "Red-eyed" set phenotype word phenotype "r-"][set eye-color "White-eyed" set phenotype word phenotype "w-"]
  ifelse member? "V" genotype = true [set wing-shape "Long-winged" set phenotype word phenotype "lw-"][set wing-shape "Vestigial-winged" set phenotype word phenotype "vw-"]
  ifelse member? "B" genotype = true [set body-color "Light body" set phenotype word phenotype "lb"][set body-color "Black body" set phenotype word phenotype "bb"]


  ;;Determine the shape and color using phenotype codes
  if phenotype = "m-r-lw-lb" [set shape "fly-m-r-lw"]
  if phenotype = "m-r-lw-bb" [set shape "fly-m-r-lw" set color 20.5]  ;set black body color
  if phenotype = "m-r-vw-lb" [set shape "fly-m-r-vw"]
  if phenotype = "m-r-vw-bb" [set shape "fly-m-r-vw" set color 20.5]
  if phenotype = "m-w-lw-lb" [set shape "fly-m-w-lw"]
  if phenotype = "m-w-lw-bb" [set shape "fly-m-w-lw" set color 20.5]
  if phenotype = "m-w-vw-lb" [set shape "fly-m-w-vw"]
  if phenotype = "m-w-vw-bb" [set shape "fly-m-w-vw" set color 20.5]

  if phenotype = "f-r-lw-lb" [set shape "fly-f-r-lw"]
  if phenotype = "f-r-lw-bb" [set shape "fly-f-r-lw" set color 20.5]
  if phenotype = "f-r-vw-lb" [set shape "fly-f-r-vw"]
  if phenotype = "f-r-vw-bb" [set shape "fly-f-r-vw" set color 20.5]
  if phenotype = "f-w-lw-lb" [set shape "fly-f-w-lw"]
  if phenotype = "f-w-lw-bb" [set shape "fly-f-w-lw" set color 20.5]
  if phenotype = "f-w-vw-lb" [set shape "fly-f-w-vw"]
  if phenotype = "f-w-vw-bb" [set shape "fly-f-w-vw" set color 20.5]

end

to fertilization

  ask eggs
  [let mate one-of sperms
    if mate != nobody
    [hatch-flies 1
     [set color 28             ;set light body color, some will be overwritten to a black body color in express
       set heading 0
       set genotype word genotype [genotype] of mate
       express
       set-position
      ]
      ask mate [die]
      die
  ]]

  ask sperms [die]
  ask eggs [die]
end

to set-tray
  ask patches [set pcolor 113 + random-float 0.5]
  ask patches with [pxcor >= max-pxcor - 1] [set pcolor 87]

  create-crosses 1
   [set shape "x"
    setxy max-pxcor - 0.5 max-pycor / 2
    set size 0.5
    set color 35]

  create-crosses 1 [
    set shape "female"
    set heading 45
    setxy max-pxcor + 0.25 5
    set size 0.75
    set color 0]

 create-crosses 1 [
    set shape "male"
    set heading 45
    setxy max-pxcor + 0.25 min-pycor + 0.25
    set size 0.75
    set color 0]
end

to set-position
  setxy random 10 random 7
  if any? other flies-here [set-position]
end

;====================================================================================

to go

  ifelse count flies != 2
[user-message "Please choose parent flies at first."]
[
    gametogenesis
    fertilization
]

end

to pick

;clear-output
  if mouse-inside? [
    if mouse-down? [
      set x round mouse-xcor set y round mouse-ycor
      ask flies with [xcor = x and ycor = y]
        [ if gender = "male"
            [ifelse count flies with [gender = "male" and pxcor >  max-pxcor - 1] > 0
            [set p1 "Opse! You have chosen a male."]
            [set size 1.25 setxy max-pxcor - 0.5 1.5

            let dad flies with [pxcor >= max-pxcor - 1 and gender = "male"]
            set p2 [eye-color] of dad
            set p2 word p2 " "
            set p2 word p2 [wing-shape] of dad
            set p2 word p2 " "
            set p2 word p2 [body-color] of dad
          ]]

          if gender = "female"
            [ifelse count flies with [pxcor > max-pxcor - 1 and gender = "female"] > 0
            [set p2 "Opse! You have chosen a female."]
            [set size 1.25 setxy max-pxcor - 0.5 4.5

             let mom flies with [pxcor >= max-pxcor - 1 and gender = "female"]
             set p1 [eye-color] of mom
             set p1 word p1 " "
             set p1 word p1 [wing-shape] of mom
             set p1 word p1 " "
             set p1 word p1 [body-color] of mom
          ]]
  ]]]


 if count flies with [pxcor >= max-pxcor - 1] = 2 [
  ask flies with [pxcor < max-pxcor - 1 ] [die]
  ask eggs [die]
  ask sperms [die]
  stop
  ]

end

to gametogenesis

set population-size 4 * (14 + random 4)

  ;set eggs

  let mom one-of flies with [gender = "female"]

  (ifelse       ;set Xa gene
    member? "XA" [genotype] of mom = true and member? "Xa" [genotype] of mom = true
    [create-eggs 0.5 * population-size [set genotype "XA" gamete-trait ]
      create-eggs 0.5 * population-size [set genotype "Xa" gamete-trait ]]

    member? "XA" [genotype] of mom = true and member? "Xa" [genotype] of mom = false
    [create-eggs population-size [set genotype "XA" gamete-trait ]]

    member? "XA" [genotype] of mom = false and member? "Xa" [genotype] of mom = true
    [create-eggs population-size [set genotype "Xa" gamete-trait ]])

  (ifelse        ;Set B and V gene
    member? "BV" [genotype] of mom = true and member? "Bv" [genotype] of mom = false and member? "bV" [genotype] of mom = false and member? "bv" [genotype] of mom = false ;BVBV
    [ask eggs [set genotype word genotype "BV"]]

    member? "Bv" [genotype] of mom = true and member? "BV" [genotype] of mom = false and member? "bV" [genotype] of mom = false and member? "bv" [genotype] of mom = false ;BvBv
    [ask eggs [set genotype word genotype "Bv"]]

    member? "bV" [genotype] of mom = true and member? "BV" [genotype] of mom = false and member? "Bv" [genotype] of mom = false and member? "bv" [genotype] of mom = false ;bVbV
    [ask eggs [set genotype word genotype "bV"]]

    member? "bv" [genotype] of mom = true and member? "BV" [genotype] of mom = false and member? "Bv" [genotype] of mom = false and member? "bV" [genotype] of mom = false ;bvbv
    [ask eggs [set genotype word genotype "bv"]]

    member? "BV" [genotype] of mom = true and member? "Bv" [genotype] of mom = true and member? "bV" [genotype] of mom = false and member? "bv" [genotype] of mom = false ;BVBv
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "Bv"]                                                 ; XABv 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "Bv"] ]                                               ; XaBv 50%

    member? "BV" [genotype] of mom = true and member? "Bv" [genotype] of mom = false and member? "bV" [genotype] of mom = true and member? "bv" [genotype] of mom = false ;BVbV
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "bV"]                                                 ; XAbV 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "bV"] ]                                               ; XabV 50%

    member? "BV" [genotype] of mom = false and member? "Bv" [genotype] of mom = true and member? "bV" [genotype] of mom = false and member? "bv" [genotype] of mom = true ;Bvbv
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "Bv"]  ; XABv  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "Bv"]  ; XaBv  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "bv"] ]                                               ; Xabv 50%

     member? "BV" [genotype] of mom = false and member? "Bv" [genotype] of mom = false and member? "bV" [genotype] of mom = true and member? "bv" [genotype] of mom = true ;bVbv
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "bV"]  ; XAbV  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "bV"]  ; XabV  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "bv"] ]                                               ; Xabv 50%

     member? "BV" [genotype] of mom = true and member? "Bv" [genotype] of mom = false and member? "bV" [genotype] of mom = false and member? "bv" [genotype] of mom = true ;BVbv
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "bv"]                                                ; Xabv 50%

             ;cross-over

            ask n-of (0.1 * count eggs with [genotype = "XABV"]) eggs with [genotype = "XABV"] [set genotype "XABv"]  ; 10% of XABV--> XABv
            ask n-of (0.1 * count eggs with [genotype = "XAbv"]) eggs with [genotype = "XAbv"] [set genotype "XAbV"]  ; 10% of XAbv--> XAbV
            ask n-of (0.1 * count eggs with [genotype = "Xabv"]) eggs with [genotype = "Xabv"] [set genotype "XabV"]  ; 10% of Xabv--> XabV
            ask n-of (0.1 * count eggs with [genotype = "XaBV"]) eggs with [genotype = "XaBV"] [set genotype "XaBv"]  ; 10% of XaBV--> XaBv
  ]

     member? "BV" [genotype] of mom = false and member? "Bv" [genotype] of mom = true and member? "bV" [genotype] of mom = true and member? "bv" [genotype] of mom = false ;BvbV
            [ask n-of (0.5 * count eggs with [genotype = "XA"]) eggs with [genotype = "XA"] [set genotype word genotype "Bv"]  ; XABv  50%
             ask eggs with [genotype = "XA"] [set genotype word genotype "bV"]                                                 ; XAbV 50%

             ask n-of (0.5 * count eggs with [genotype = "Xa"]) eggs with [genotype = "Xa"] [set genotype word genotype "Bv"]  ; XaBv  50%
             ask eggs with [genotype = "Xa"] [set genotype word genotype "bV"]                                                ; XabV 50%

             ;cross-over

            ask n-of (0.1 * count eggs with [genotype = "XABv"]) eggs with [genotype = "XABv"] [set genotype "XABV"]  ; 10% of XABv--> XABV
            ask n-of (0.1 * count eggs with [genotype = "XAbV"]) eggs with [genotype = "XAbV"] [set genotype "XAbv"]  ; 10% of XAbV--> XAbv
            ask n-of (0.1 * count eggs with [genotype = "XabV"]) eggs with [genotype = "XabV"] [set genotype "Xabv"]  ; 10% of XabV--> Xabv
            ask n-of (0.1 * count eggs with [genotype = "XaBv"]) eggs with [genotype = "XaBv"] [set genotype "XaBV"]  ; 10% of XaBv--> XaBV
])

   ; set sperms

   let dad one-of flies with [gender = "male"]

   ifelse member? "XA" [genotype] of dad = true     ;set Xa gene
           [create-sperms 0.5 * population-size [set genotype "XA" gamete-trait ] create-sperms 0.5 * population-size [set genotype "Y" gamete-trait ]]
           [create-sperms 0.5 * population-size [set genotype "Xa" gamete-trait ] create-sperms 0.5 * population-size [set genotype "Y" gamete-trait ]]


  (ifelse        ;Set B and V gene
    member? "BV" [genotype] of dad = true and member? "Bv" [genotype] of dad = false and member? "bV" [genotype] of dad = false and member? "bv" [genotype] of dad = false ;BVBV
    [ask sperms [set genotype word genotype "BV"]]

    member? "Bv" [genotype] of dad = true and member? "BV" [genotype] of dad = false and member? "bV" [genotype] of dad = false and member? "bv" [genotype] of dad = false ;BvBv
    [ask sperms [set genotype word genotype "Bv"]]

    member? "bV" [genotype] of dad = true and member? "BV" [genotype] of dad = false and member? "Bv" [genotype] of dad = false and member? "bv" [genotype] of dad = false ;bVbV
    [ask sperms [set genotype word genotype "bV"]]

    member? "bv" [genotype] of dad = true and member? "BV" [genotype] of dad = false and member? "Bv" [genotype] of dad = false and member? "bV" [genotype] of dad = false ;bvbv
    [ask sperms [set genotype word genotype "bv"]]

    member? "BV" [genotype] of dad = true and member? "Bv" [genotype] of dad = true and member? "bV" [genotype] of dad = false and member? "bv" [genotype] of dad = false ;BVBv
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "Bv"]                                                 ; XABv 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "Bv"]                                                ; XaBv 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "BV"]  ; YBV  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "Bv"] ]                                               ; YBv 50%

    member? "BV" [genotype] of dad = true and member? "Bv" [genotype] of dad = false and member? "bV" [genotype] of dad = true and member? "bv" [genotype] of dad = false ;BVbV
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "bV"]                                                 ; XAbV 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "bV"]                                                ; XabV 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "BV"]  ; YBV  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "bV"] ]                                               ; YbV 50%

    member? "BV" [genotype] of dad = false and member? "Bv" [genotype] of dad = true and member? "bV" [genotype] of dad = false and member? "bv" [genotype] of dad = true ;Bvbv
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "Bv"]  ; XABv  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "Bv"]  ; XaBv  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "bv"]                                              ; Xabv 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "Bv"]  ; YBv  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "bv"] ]                                               ; Ybv 50%

     member? "BV" [genotype] of dad = false and member? "Bv" [genotype] of dad = false and member? "bV" [genotype] of dad = true and member? "bv" [genotype] of dad = true ;bVbv
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "bV"]  ; XAbV  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "bV"]  ; XabV  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "bv"]                                                ; Xabv 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "bV"]  ; YbV  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "bv"] ]                                               ; Ybv 50%

     member? "BV" [genotype] of dad = true and member? "Bv" [genotype] of dad = false and member? "bV" [genotype] of dad = false and member? "bv" [genotype] of dad = true ;BVbv
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "BV"]  ; XABV  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "bv"]                                                 ; XAbv 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "BV"]  ; XaBV  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "bv"]                                                ; Xabv 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "BV"]  ; YBV  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "bv"]                                               ; Ybv 50%

             ;cross-over

             ask n-of (0.1 * count sperms with [genotype = "XABV"]) sperms with [genotype = "XABV"] [set genotype "XABv"]  ; 10% of XABV--> XABv
             ask n-of (0.1 * count sperms with [genotype = "XAbv"]) sperms with [genotype = "XAbv"] [set genotype "XAbV"]  ; 10% of XAbv--> XAbV
             ask n-of (0.1 * count sperms with [genotype = "Xabv"]) sperms with [genotype = "Xabv"] [set genotype "XabV"]  ; 10% of Xabv--> XabV
             ask n-of (0.1 * count sperms with [genotype = "XaBV"]) sperms with [genotype = "XaBV"] [set genotype "XaBv"]  ; 10% of XaBV--> XaBv
             ask n-of (0.1 * count sperms with [genotype = "YBV"]) sperms with [genotype = "YBV"] [set genotype "YBv"]     ; 10% of YBV--> YBv
             ask n-of (0.1 * count sperms with [genotype = "Ybv"]) sperms with [genotype = "Ybv"] [set genotype "YbV"]     ; 10% of Ybv--> YbV
  ]

     member? "BV" [genotype] of dad = false and member? "Bv" [genotype] of dad = true and member? "bV" [genotype] of dad = true and member? "bv" [genotype] of dad = false ;BvbV
            [ask n-of (0.5 * count sperms with [genotype = "XA"]) sperms with [genotype = "XA"] [set genotype word genotype "Bv"]  ; XABv  50%
             ask sperms with [genotype = "XA"] [set genotype word genotype "bV"]                                                 ; XAbV 50%

             ask n-of (0.5 * count sperms with [genotype = "Xa"]) sperms with [genotype = "Xa"] [set genotype word genotype "Bv"]  ; XaBv  50%
             ask sperms with [genotype = "Xa"] [set genotype word genotype "bV"]                                                ; XabV 50%

             ask n-of (0.5 * count sperms with [genotype = "Y"]) sperms with [genotype = "Y"] [set genotype word genotype "Bv"]  ; YBv  50%
             ask sperms with [genotype = "Y"] [set genotype word genotype "bV"]                                                 ; YbV 50%


             ;cross-over

            ask n-of (0.1 * count sperms with [genotype = "XABv"]) sperms with [genotype = "XABv"] [set genotype  "XABV"]  ; 10% of XABv--> XABV
            ask n-of (0.1 * count sperms with [genotype = "XAbV"]) sperms with [genotype = "XAbV"] [set genotype  "XAbv"]  ; 10% of XAbV--> XAbv
            ask n-of (0.1 * count sperms with [genotype = "XabV"]) sperms with [genotype = "XabV"] [set genotype  "Xabv"]  ; 10% of XabV--> Xabv
            ask n-of (0.1 * count sperms with [genotype = "XaBv"]) sperms with [genotype = "XaBv"] [set genotype  "XaBV"]  ; 10% of XaBv--> XaBV
            ask n-of (0.1 * count sperms with [genotype = "YBv"]) sperms with [genotype = "YBv"] [set genotype  "YBV"]     ; 10% of YBv--> YBV
            ask n-of (0.1 * count sperms with [genotype = "YbV"]) sperms with [genotype = "YbV"] [set genotype  "Ybv"]     ; 10% of YbV--> Ybv
])


  ask flies [die]

end

to output-results

 if cases = "Case 1" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of their abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of their abdomen."
  output-print "~~~~~~~~~~~"
  output-print "Use case 1 to explore the inheritance patterns between eye color and gender."
  ]

 if cases = "Case 2" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of their abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of their abdomen."
  output-print "~~~~~~~~~~~"
  output-print "Use case 2 to explore the inheritance patterns between wing shape and gender."
  ]

 if cases = "Case 3" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of their abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of their abdomen."
  output-print "~~~~~~~~~~~"
  output-print "Use case 3 to explore the inheritance patterns between eye color and wing shape."
  ]

  if cases = "Case 4" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of their abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of their abdomen."
  output-print "~~~~~~~~~~~"
  output-print "Use case 4 to explore the inheritance patterns between wing shape and body color."
  ]

  if cases = "Case 5" [
  output-print "Female flies:  Bigger in size without a dark genitalia at the tip of their abdomen."
  output-print "Male flies:  Smaller in size with a dark genitalia at the tip of their abdomen."
  output-print "~~~~~~~~~~~"
  output-print "Use case 5 to explore the inheritance patterns among eye color, gender, wing shape and body color."
  ]

end

to set-lists
  if any? flies with [xcor <= 9][
         set list-1 [who] of flies with [phenotype = "m-r-lw-lb" and xcor < max-pxcor - 1]
         set list-2 [who] of flies with [phenotype = "m-r-lw-bb" and xcor < max-pxcor - 1]
         set list-1 sentence list-1 list-2

         set list-3 [who] of flies with [phenotype = "m-r-vw-lb" and xcor < max-pxcor - 1]
         set list-4 [who] of flies with [phenotype = "m-r-vw-bb" and xcor < max-pxcor - 1]
         set list-3 sentence list-3 list-4
         set list-1 sentence list-1 list-3

         set list-5 [who] of flies with [phenotype = "m-w-lw-lb" and xcor < max-pxcor - 1]
         set list-6 [who] of flies with [phenotype = "m-w-lw-bb" and xcor < max-pxcor - 1]
         set list-5 sentence list-5 list-6

         set list-7 [who] of flies with [phenotype = "m-w-vw-lb" and xcor < max-pxcor - 1]
         set list-8 [who] of flies with [phenotype = "m-w-vw-bb" and xcor < max-pxcor - 1]
         set list-7 sentence list-7 list-8
         set list-5 sentence list-5 list-7
         set list-9 sentence list-1 list-5

         set list-1 [who] of flies with [phenotype = "f-r-lw-lb" and xcor < max-pxcor - 1]
         set list-2 [who] of flies with [phenotype = "f-r-lw-bb" and xcor < max-pxcor - 1]
         set list-1 sentence list-1 list-2

         set list-3 [who] of flies with [phenotype = "f-r-vw-lb" and xcor < max-pxcor - 1]
         set list-4 [who] of flies with [phenotype = "f-r-vw-bb" and xcor < max-pxcor - 1]
         set list-3 sentence list-3 list-4
         set list-1 sentence list-1 list-3

         set list-5 [who] of flies with [phenotype = "f-w-lw-lb" and xcor < max-pxcor - 1]
         set list-6 [who] of flies with [phenotype = "f-w-lw-bb" and xcor < max-pxcor - 1]
         set list-5 sentence list-5 list-6

         set list-7 [who] of flies with [phenotype = "f-w-vw-lb" and xcor < max-pxcor - 1]
         set list-8 [who] of flies with [phenotype = "f-w-vw-bb" and xcor < max-pxcor - 1]
         set list-7 sentence list-7 list-8
         set list-5 sentence list-5 list-7
         set list-1 sentence list-1 list-5
         set list-1 sentence list-1 list-9

    sorting
      ]
end

to sorting

   set f-x 0
        set f-y max-pycor
        set fly-ID 0

        repeat length list-1
        [ask flies with [who = item fly-ID list-1] [setxy f-x f-y]
          ifelse f-y > 0 [set f-y f-y - 1][set f-y max-pycor set f-x f-x + 1]
          set fly-ID fly-ID + 1 ]

end
@#$#@#$#@
GRAPHICS-WINDOW
8
90
616
449
-1
-1
50.0
1
10
1
1
1
0
1
1
1
0
11
0
6
0
0
1
ticks
5.0

BUTTON
665
144
787
177
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
665
187
856
220
Press & Choose 2 parent flies
Pick
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
343
615
423
656
Light body
count flies with [gender = \"male\" and eye-color = \"White-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
257
520
336
561
Black body
count flies with [gender = \"female\" and eye-color = \"Red-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
343
572
423
613
Light body
count flies with [gender = \"male\" and eye-color = \"White-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
181
477
256
518
Light body
count flies with [gender = \"female\" and eye-color = \"Red-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
524
674
665
723
Total offspring flies
count flies
17
1
12

BUTTON
665
233
758
266
Cross!
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
11
457
79
477
Progeny:
14
15.0
1

CHOOSER
621
93
750
138
Cases
Cases
"Case 1" "Case 2" "Case 3" "Case 4" "Case 5"
0

TEXTBOX
625
139
664
274
|\n|-->\n|\n|\n|-->\n|\n|\n|-->\n
12
0.0
1

MONITOR
425
572
504
613
Black body
count flies with [gender = \"male\" and eye-color = \"White-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
181
520
256
561
Light body
count flies with [gender = \"female\" and eye-color = \"Red-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
425
615
504
656
Black body
count flies with [gender = \"male\" and eye-color = \"White-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
257
477
336
518
Black body
count flies with [gender = \"female\" and eye-color = \"Red-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
181
615
256
656
Light body
count flies with [gender = \"female\" and eye-color = \"White-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
257
615
336
656
Black body
count flies with [gender = \"female\" and eye-color = \"White-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Black body\"]
17
1
10

TEXTBOX
233
455
446
486
Females                               Males
12
0.0
1

MONITOR
181
572
256
613
Light body
count flies with [gender = \"female\" and eye-color = \"White-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Light body\"]
17
1
10

TEXTBOX
32
485
183
555
                   |---Long-winged\n                   |\n Red-eyed-|\n                   |\n                   |Vestigial-winged
10
0.0
1

TEXTBOX
23
580
184
651
                      |---Long-winged\n                      |\n White-eyed-|\n                      |\n                      |Vestigial-winged
10
0.0
1

MONITOR
257
572
336
613
Black body
count flies with [gender = \"female\" and eye-color = \"White-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
345
477
424
518
Light body
count flies with [gender = \"male\" and eye-color = \"Red-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
425
477
504
518
Black body
count flies with [gender = \"male\" and eye-color = \"Red-eyed\" and wing-shape = \"Long-winged\" and body-color = \"Black body\"]
17
1
10

MONITOR
345
520
424
561
Light body
count flies with [gender = \"male\" and eye-color = \"Red-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Light body\"]
17
1
10

MONITOR
425
520
504
561
Black body
count flies with [gender = \"male\" and eye-color = \"Red-eyed\" and wing-shape = \"Vestigial-winged\" and body-color = \"Black body\"]
17
1
10

OUTPUT
8
10
726
87
11

MONITOR
621
346
859
387
Female
p1
17
1
10

MONITOR
621
408
858
449
Male
p2
17
1
10

TEXTBOX
621
326
684
344
Parents:
14
15.0
1

TEXTBOX
735
391
756
409
X
14
0.0
1

MONITOR
517
501
617
542
Total red-eyed
count flies with [eye-color = \"Red-eyed\"]
17
1
10

MONITOR
517
573
617
614
Total white-eyed
count flies with [eye-color = \"White-eyed\"]
17
1
10

MONITOR
617
501
748
542
Total Long-winged
count flies with [wing-shape = \"Long-winged\"]
17
1
10

MONITOR
617
573
748
614
Total Vestigial-winged
count flies with [wing-shape = \"Vestigial-winged\"]
17
1
10

MONITOR
378
666
473
707
Total males
count flies with [gender = \"male\"]
17
1
10

MONITOR
209
667
308
708
Total females
count flies with [gender = \"female\"]
17
1
10

MONITOR
378
708
479
749
Total light body
count flies with [body-color = \"Light body\"]
17
1
10

MONITOR
209
709
314
750
Total black body
count flies with [body-color = \"Black body\"]
17
1
10

TEXTBOX
24
653
726
673
------------------------------------------------------------------------------------------------
12
7.0
1

TEXTBOX
510
449
525
771
|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|
8
7.0
1

BUTTON
665
277
758
310
Sort Flies
set-lists
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

@#$#@#$#@
## WHAT IS IT?

This is an inheritance model of genetic linkage, including both X-linkage and autosomal linkage.

## HOW TO USE

1. Select one of five cases
2. Click on the "Start/reset" button to start or start over .
3. Click on the "Press and choose 2 parent flies" button. 
4. Choose a male and a female in the simulation window. The males are smaller and have a dark abdomen tip. 
5. Click on the "cross!" button to conduct a test cross.
6. Examine offspring phenotypes in the simulation window and the "progeny" section.


## CREDITS AND REFERENCES

This model was made by Dr. Lin Xiang at Weber State University.If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2017). Patterns of Inheritance: Genetic Linkage. Zoology Department, Weber State University, Ogden, UT.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

dot
false
0
Circle -7500403 true true 90 90 120

female
false
0
Circle -7500403 false true 120 75 58
Line -7500403 true 150 210 150 135
Line -7500403 true 180 165 150 165
Line -7500403 true 120 165 150 165

fly-abd-f
false
0
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-abd-m
false
0
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-body
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16

fly-eye
false
0
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -7500403 true true 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -7500403 true true 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11

fly-f-r-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-f-r-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 122 87 120 90 90 120 75 135 75 165 90 180 105 165 120 150 120 150 120 150 120 135 120 120 120 105
Polygon -6459832 false false 178 87 180 90 210 120 225 135 225 165 210 180 195 165 180 150 180 150 180 150 180 135 180 120 180 105

fly-f-w-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107

fly-f-w-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 104 190 119 220 132 237 150 249 168 237 179 220 194 190 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 124 228 150 232 175 227 168 236 151 243 132 237
Polygon -16777216 true false 110 150 188 150 192 157 105 157
Polygon -16777216 true false 104 171 194 171 194 179 104 179
Polygon -16777216 true false 104 192 194 192 188 200 110 200
Polygon -16777216 true false 114 210 185 210 180 218 118 219
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -6459832 false false 122 87 120 90 90 120 75 135 75 165 90 180 105 165 120 150 120 150 120 150 120 135 120 120 120 105
Polygon -6459832 false false 178 87 180 90 210 120 225 135 225 165 210 180 195 165 180 150 180 150 180 150 180 135 180 120 180 105

fly-m-r-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-m-r-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -2674135 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -2674135 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 180 105 165 75 210 105 225 135 225 165 210 165 195 150 180 135 180 120 195 135 180 120 180 120 180 105
Polygon -6459832 false false 120 105 135 75 90 105 75 135 75 165 90 165 105 150 120 135 120 120 105 135 120 120 120 120 120 105

fly-m-w-lw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 178 87 179 59 201 117 219 182 220 239 204 271 179 295 153 285 122 245 119 204 129 166 152 142 172 107
Polygon -6459832 false false 122 87 121 59 99 117 81 182 80 239 96 271 121 295 147 285 178 245 181 204 171 166 148 142 128 107

fly-m-w-vw
false
0
Polygon -7500403 true true 122 89 103 108 89 91 70 81 46 76 12 78 46 80 69 86 85 97 99 121 106 121 132 106
Polygon -7500403 true true 128 124 100 138 91 141 86 171 86 192 77 218 62 246 74 231 82 218 94 192 97 153 122 145
Polygon -7500403 true true 166 62 189 57 188 42 204 20 216 14 232 9 219 16 208 23 196 44 198 62 168 77
Polygon -7500403 true true 134 62 111 57 112 42 96 20 84 14 68 9 81 16 92 23 104 44 102 62 132 77
Polygon -7500403 true true 178 89 197 108 211 91 230 81 254 76 288 78 254 80 231 86 215 97 201 121 194 121 168 106
Polygon -7500403 true true 135 15 120 45 135 45 120 60 112 82 120 105 135 120 150 135 165 120 180 105 189 81 180 60 165 45 180 45 165 15
Polygon -7500403 true true 134 115 119 130 104 160 105 180 120 210 134 219 150 225 167 219 180 210 195 180 194 160 179 130 164 115
Polygon -16777216 true false 105 180 150 195 195 180 195 180 150 195 105 180
Polygon -16777216 true false 106 158 193 158 194 162 104 163
Polygon -16777216 true false 105 172 194 172 194 180 105 180
Polygon -1 true false 165 15 170 32 179 46 188 45 194 38 192 27 187 18 179 13 171 11
Polygon -1 true false 135 15 130 32 121 46 112 45 106 38 108 27 113 18 121 13 129 11
Polygon -7500403 true true 172 124 200 138 209 141 214 171 214 192 223 218 238 246 226 231 218 218 206 192 203 153 178 145
Polygon -7500403 true true 145 16 133 5 120 1 132 7 140 16
Polygon -7500403 true true 155 16 167 5 180 1 168 7 160 16
Polygon -16777216 true false 111 191 149 194 189 190 181 208 170 217 150 224 133 218 120 209
Polygon -6459832 false false 180 105 165 75 210 105 225 135 225 165 210 165 195 150 180 135 180 120 195 135 180 120 180 120 180 105
Polygon -6459832 false false 120 105 135 75 90 105 75 135 75 165 90 165 105 150 120 135 120 120 105 135 120 120 120 120 120 105

male
true
0
Circle -7500403 false true 120 150 58
Line -7500403 true 150 150 150 75
Line -7500403 true 150 75 135 90
Line -7500403 true 150 75 165 90

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
