Turtles-own [ gender rom-com bought-ticket?  
    age female-friends male-friends possible-female-friends possible-male-friends ] ;;; Declaring which variables will be turtle variables.

Patches-own [theater?]  ;;;Declaring which variables will be patch variables. 

Globals [ max-female-friends max-male-friends rom-com-revenue action-movie-revenue social-network
  switching-chance]  ;;; Declaring which variables will be global variables, known by all agents.  

To Setup 
  ca                      ;;;When the setup button is clicked, the model is cleared of all previous data. 
  reset-ticks             ;;;When the setup button is clicked, the model resets any ticks from previous model runs. 
  crt female-population-percentage [
  set size 1
  set color pink
  set gender "female" 
  
  setxy random-xcor random-ycor ]  ;;; Creates the amount of turtles specified by the slider "female-population-percentage," sets the size of the turtle, the color of the turtle,and the gender
  
                                   ;;; of the turtle to female.  Furthermore, this portion of the code sets the location of the turtles to be completely random (random-xcor random-ycor.)
  

  
  set rom-com-revenue 0 set action-movie-revenue 0  ;;; Sets the value of rom-com-revenue and action-movie-revenue to zero. 
  
  crt 100 - female-population-percentage [ set size 1 set color blue set gender "male" setxy random-xcor random-ycor ]  ;;;Establishes the male population percentage, gender, color, size, and location. 
 
ask turtles [ ifelse gender = "female" [set rom-com true][set rom-com false]]  ;;; Sets the movie preference if a turtle is a female to a romantic comedy.
 
   if age2%31-45 > 100 - age1%15-30 [set age2%31-45 100 - age1%15-30]  ;;; These four equations determine the age range for each turtle, which helps establish a social network later in the model. 
   if age3%46-60 > 100 - age2%31-45 - age1%15-30 [set age3%46-60 100 - age2%31-45 - age1%15-30]
   if age4%61-75 > 100 - age3%46-60 - age2%31-45 - age1%15-30 [set age4%61-75 100 - age3%46-60 - age2%31-45 - age1%15-30]
   if age4%61-75 + age3%46-60 + age2%31-45 + age1%15-30 < 100 [set other% 100 - age4%61-75 - age3%46-60 - age2%31-45 - age1%15-30] 
  
   ask turtles
   [let yoage random 100 
      ifelse yoage < age1%15-30 [set age 1][ifelse yoage < age1%15-30 + age2%31-45[set age 2][ifelse yoage < age1%15-30 + age2%31-45 + age3%46-60[set age 3]
          [ifelse yoage < age1%15-30 + age2%31-45 + age3%46-60 + age4%61-75[set age 4][set age 5]]]]] ;;; Sets each age range to a definite number value. 
   
   
      
  ask n-of num-theaters patches [set theater? true set pcolor green]  ;;; Establishes the location of movie theaters, and the color of a movie theater patch. 
  
 
 
 
set max-female-friends max-social-network-size * 0.6 
set max-male-friends max-social-network-size - max-female-friends ;;; Establishes the maximum amount of friends a female or male could have based on the maximum social network size.


  
ask turtles [ 

 set possible-female-friends n-of max-female-friends other turtles with [gender = "female" and abs (age - [age] of myself) <= 1]
 set possible-male-friends n-of max-male-friends other turtles with [gender = "male" and abs (age - [age] of myself) <= 1] ;;; Establishes the possible friends of each gender based on gender and age. 
  
  

let f 0 ;;; Temporarily establishes a value for the amount of female and male friends.  It is important that it starts at 0, so that friends can be counted as they increase in number.
let m 0

ask possible-female-friends 
[ifelse [gender] of myself = "female" [if female-friends < max-female-friends [create-link-with myself 
  set female-friends female-friends + 1 
  set f f + 1]][if male-friends < max-male-friends [create-link-with myself set male-friends male-friends + 1
    set f f + 1]]] ;;;This aspect of the code initiates the "friending" for females process.


ask possible-male-friends
[ifelse [gender] of myself = "male" [if male-friends < max-male-friends [create-link-with myself
    set male-friends male-friends + 1 set m m + 1]][if female-friends < max-female-friends [create-link-with myself set female-friends female-friends + 1 
    set m m + 1]]] ;;; This aspect of the code initiates the "friending" for males process.
  
  

]
ask turtles [set bought-ticket? false]  ;;;Establishes that no turtles have purchased a ticket at this point in the model.  





end

  

  
  
To go 
  if ticks = 60 [stop] ;;; Establishes that after 60 ticks, whereas each tick is equivalent to one day, the model would conclude. 
  tick ;;; The model begins to record ticks. 
 ask turtles [let min-theater min-one-of patches with [pcolor = green][distance myself] face min-theater fd 1   ;;; Asks turtles to move towards theaters. 
 
 ifelse male-friends > female-friends [set rom-com false][set rom-com true]] ;;; Establishes that when there are more female friends than male friends in a group of friends, those turtles will be more likely to see a romantic comedy. 

 ask turtles[
 set switching-chance .3 ;;; Establishes that although a turtle may have a predisposed movie preference, that turtle also has an opportunity to change its mind based on a turtle's social network.
 let other-turtles turtles-on patch-here
 if theater? = true and count other-turtles > 0 [let other-rom-coms count other-turtles with [rom-com = true] let other-action count other-turtles with [rom-com = false]
 let pct-rom-com (other-rom-coms) / (other-rom-coms + other-action)
 let pct-action 1 - pct-rom-com
 ifelse rom-com = false [set switching-chance switching-chance * pct-rom-com let rand random-float 1
   ifelse gender = "female" and age > 1 and age < 4 [set switching-chance switching-chance * (3 / 2)][if gender = "female"and age > 4 [set switching-chance switching-chance * (4 / 3)]]
ifelse rand < switching-chance  [set rom-com true][set rom-com false]]
    [set switching-chance switching-chance * (1 - pct-rom-com) let rand random-float 1 
ifelse rand < switching-chance  [set rom-com false][set rom-com true]]
    ;;; The above code determines the amount of turtles at a theater seeing a given movie, and programs a switching chance into a turtle based on what movies turtles at a theater are seeing, as well as a decrease in preference for action movies as female turtles increase in age.  
   
 


if female-friends + male-friends > 0 [
let pct-female-friends female-friends / (female-friends + male-friends)
 let pct-male-friends 1 - pct-female-friends
 ifelse rom-com = false [set switching-chance switching-chance * pct-female-friends let rand2 random-float 1 
ifelse rand2 < switching-chance [set rom-com true][set rom-com false]][set switching-chance switching-chance * (1 - pct-female-friends) let rand2 random-float 1 
ifelse rand2 < switching-chance [set rom-com false][set rom-com true]]]]  
;;; Codes for a switch in movie preference based on switching chance based on female and male populations at a movie theater. 
 
 if theater? = true and bought-ticket? = false [ifelse rom-com = false [set action-movie-revenue action-movie-revenue + 10 set bought-ticket? true]
   [set rom-com-revenue rom-com-revenue + 10 set bought-ticket? true]] ;;; Codes for the increase in revenue based on tickets purchased.
  
 
 ]
 

 
 


 
   
  
end

To output 
 set-current-plot  "rom-com-revenue" set-current-plot "action-movie-revenue" ;;; Establishes the outputs created in the plot.  
  
  
end
 
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
56
59
120
92
Setup
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
85
148
148
181
Go
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
-6
223
211
256
female-population-percentage
female-population-percentage
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
1
272
173
305
num-theaters
num-theaters
0
5
4
1
1
NIL
HORIZONTAL

SLIDER
651
10
823
43
Age1%15-30
Age1%15-30
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
650
46
822
79
Age2%31-45
Age2%31-45
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
650
82
822
115
Age3%46-60
Age3%46-60
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
650
117
822
150
Age4%61-75
Age4%61-75
0
100
20
1
1
NIL
HORIZONTAL

INPUTBOX
674
239
829
299
Ticket-Price
10
1
0
Number

SLIDER
649
150
821
183
Other%
Other%
0
100
20
1
1
NIL
HORIZONTAL

PLOT
1019
67
1219
217
rom-com-revenue
Time
Profit
1.0
60.0
0.0
1000.0
false
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot rom-com-revenue"
"pen-1" 1.0 0 -7500403 true "" "plot action-movie-revenue"

SLIDER
1
313
183
346
max-social-network-size
max-social-network-size
0
10
8
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
