;Nov 5, 2012: More effecient statistical outputs. First and last time of maximum truth distance, first and last 
;time of convergence, mean truth distance, median truth distance.
;This version of Millian Mingling includes three different kinds of agents, millians, chums, and believers.
;Each breed of agent has a different movement rule. Believers move around randomly, millians seek out people
;they disagree with (according to a search radius set by the vision variable), and chums seek out people
;they already agree with. Agents keep a record of the recent agents they have interacted with, where this
;can be controlled by the maxhistory variable.
;new statistics, one for each breed

breed [fact-checkers fact-checker]
breed [believers believer]
breed [millians millian]
breed [chums chum]
breed [afact-checkers afact-checker]

patches-own [
 truthflux 
]

globals [
 truth-list
 false-list
 props-to-compare
 num-of-interacted-agents ; this tracks how many agents interacted
 num-chum-interacted
 num-mill-interacted
 num-believer-interacted
 num-of-attitudes-changed ; this tracks how many attitudes an agent changed in an interaction
 num-of-updated-attitude-agents ;this tracks how many agents updated an attitude
 num-of-decreased-loudness ;tracks how many decreases in loudness there were
 num-of-increased-loudness ;tracks how many increases in loudness there were
 avg-num-attitudes-changed ;
 avg-num-disagreements
 current-avg-dist-truth ;this avg includes indifference
 current-avg-dist-others ;this avg includes indifference
 current-avg-disagree-truth ; this avg ignores indifference
 current-avg-disagree-others ; this avg ignores indifference
 current-avg-millian-disagree-truth
 current-avg-believer-disagree-truth
 current-avg-chum-disagree-truth 
 current-avg-millian-loudness
 current-avg-chum-loudness
 current-avg-believer-loudness
 my-seed
 max-truthdist-b
 max-truthdist-c
 max-truthdist-m
 min-truthdist-b
 min-truthdist-c
 min-truthdist-m
 tickof-first-max-truthdist-b
 tickof-first-max-truthdist-c
 tickof-first-max-truthdist-m
 tickof-last-max-truthdist-b
 tickof-last-max-truthdist-c
 tickof-last-max-truthdist-m
 tickof-first-min-truthdist-b
 tickof-first-min-truthdist-c
 tickof-first-min-truthdist-m
 tickof-last-min-truthdist-b
 tickof-last-min-truthdist-c
 tickof-last-min-truthdist-m 
 truthdist-b
 truthdist-c
 truthdist-m
 median-truthdist-b
 median-truthdist-c
 median-truthdist-m
 mean-truthdist-b
 mean-truthdist-c
 mean-truthdist-m
]


turtles-own
[ 
  old-attitude-list ; this is a list of attitudes towards propositions
  new-attitude-list ; this is a list of attitudes towards propositions
  old-loudness-list ; this is a list of how loudly an agent voices that attitude
  new-loudness-list ; this is a list of how loudly an agent voices that attitude
  meet-history ; this is a list of past agents a turtle has met with
  minglers ; agentset of nearby turtles
  nearest-mingler ; closest of one of the minglers (that isn't also in the meet-history)
]

to setup
  clear-all
  ask patches [
    set truthflux 0
    set pcolor brown]
  set truthdist-b [ ]
  set truthdist-c [ ]
  set truthdist-m [ ]
  create-believers (num-believers - (num-millians + num-chums)) [ ; create num-believers quantity of believers
    setxy random-xcor random-ycor
    set color blue
    set shape "person"
    set old-attitude-list [ ]
    set old-loudness-list [ ]
    set meet-history []
    repeat num-props [ ; create a list of beliefs and a list of loudness degrees that is of size num-props
      let attitude -1
      if believers-facters-opposite-attitude = false[
        set attitude (random 3) - 1
      ]
      set old-attitude-list lput attitude old-attitude-list
      ifelse attitude = 0 [
        set old-loudness-list lput 0 old-loudness-list 
      ]
      [
        ifelse set-init-believer-loudness-max = true [
          set old-loudness-list lput init-max-believer-loudness old-loudness-list 
        ]
        [ 
          set old-loudness-list lput (random init-max-believer-loudness) old-loudness-list 
        ]
      ]
    ]
  ]
  create-millians num-millians [ ; create num-believers quantity of believers
    setxy random-xcor random-ycor
    set color violet
    set shape "person"
    set old-attitude-list [ ]
    set old-loudness-list [ ]
    set meet-history [ ]
    repeat num-props [ ; create a list of beliefs and a list of loudness degrees that is of size num-props
      let attitude -1
      if believers-facters-opposite-attitude = false[
        set attitude (random 3) - 1
      ]
      set old-attitude-list lput attitude old-attitude-list
      ifelse attitude = 0 [
        set old-loudness-list lput 0 old-loudness-list 
      ]
      [
        ifelse set-init-believer-loudness-max = true [
          set old-loudness-list lput init-max-believer-loudness old-loudness-list 
        ]
        [ 
          set old-loudness-list lput (random init-max-believer-loudness) old-loudness-list 
        ]
      ]
    ]
  ]  
  create-chums num-chums [ ; create num-believers quantity of believers
    setxy random-xcor random-ycor
    set color 34
    set shape "person"
    set old-attitude-list [ ]
    set old-loudness-list [ ]
    set meet-history [  ]
    repeat num-props [ ; create a list of beliefs and a list of loudness degrees that is of size num-props
      let attitude -1
      if believers-facters-opposite-attitude = false[
        set attitude (random 3) - 1
      ]
      set old-attitude-list lput attitude old-attitude-list
      ifelse attitude = 0 [
        set old-loudness-list lput 0 old-loudness-list 
      ]
      [
        ifelse set-init-believer-loudness-max = true [
          set old-loudness-list lput init-max-believer-loudness old-loudness-list 
        ]
        [ 
          set old-loudness-list lput (random init-max-believer-loudness) old-loudness-list 
        ]
      ]
    ]
  ]    
  set truth-list [ ]
  repeat num-props [ ; create a list of beliefs that is of size num-propos
    set truth-list lput one-of [1] truth-list 
  ]
  set false-list [ ]
  repeat num-props [
   set false-list lput one-of [-1] false-list 
  ]
  create-fact-checkers num-sci [ ; create agents that will be the fact checkers
    setxy random-xcor random-ycor
    set color green
    set shape "tree"
    set old-attitude-list truth-list
    set old-loudness-list []
    set meet-history []
    ;repeat num-props [ ; create a list of loudness degrees that is of size num-props
    ;  set old-loudness-list lput (random max-loudness) old-loudness-list ; fact-checkers have max loudness at start
    ;]
    repeat num-props [ ; create a list of loudness degrees that is of size num-props
      ifelse world-loudness-max = true [
        ifelse plus-one-max-world-loudness = true [
          set old-loudness-list lput (max-loudness + 1) old-loudness-list]
        [ set old-loudness-list lput max-loudness old-loudness-list
        ]
      ][
      set old-loudness-list lput (random (init-max-believer-loudness + 1) ) old-loudness-list
      ]
    ] 
  ]
  create-afact-checkers num-asci [ ; create agents that will be the afact checkers - i.e., those that speak falsehoods
    setxy random-xcor random-ycor
    set color red
    set shape "tree"
    set old-attitude-list false-list
    set old-loudness-list []
    set meet-history []
    ;repeat num-props [ ; create a list of loudness degrees that is of size num-props
    ;  set old-loudness-list lput (random max-loudness) old-loudness-list ; fact-checkers have max loudness at start
    ;]
    repeat num-props [ ; create a list of loudness degrees that is of size num-props
      ifelse world-loudness-max = true [
        ifelse plus-one-max-world-loudness = true [
          set old-loudness-list lput (max-loudness + 1) old-loudness-list]
        [ set old-loudness-list lput max-loudness old-loudness-list
        ]
      ][
      set old-loudness-list lput (random (init-max-believer-loudness + 1) ) old-loudness-list
      ]
    ] 
  ]      
  ask turtles[
    set new-attitude-list old-attitude-list ;this copies the old list 
    set new-loudness-list old-loudness-list   
  ]
  ;;ask patches [if pxcor mod 2 = 1 and pycor mod 2 = 0 [set pcolor 1] if pxcor mod 2 = 0 and pycor mod 2 = 1 [set pcolor 1]]  
  reset-ticks
end

to go 
  set num-of-interacted-agents 0
  set num-mill-interacted 0
  set num-chum-interacted 0
  set num-believer-interacted 0
  set num-of-attitudes-changed 0
  set num-of-updated-attitude-agents 0
  set num-of-decreased-loudness 0 ;tracks how many decreases in loudness there were
  set num-of-increased-loudness 0
  ask turtles [
    move
  ]
  ask patches with [count turtles-here >= 2] [
    ifelse patch-announcement = true [
      let props pick-props-to-compare
      let current-prop one-of props
      let kate max-one-of turtles-here [item current-prop old-loudness-list]
      ask turtles-here with [who != [who] of kate] [
        interact kate self
      ] 
    ]
    [
      let kate one-of turtles-here
      let john one-of turtles-here with [who != [who] of kate]
      interact kate john
      update-meet-history kate john
    ]
  ]
  ask turtles [
   if (old-attitude-list != new-attitude-list) [
     set num-of-updated-attitude-agents num-of-updated-attitude-agents + 1
   ] 
  ]
  ask turtles [
    update-attitudes
  ]
  update-truthflux
  statistics
  tick
  if num-attitude-groups = 1 and mode-attitude-group = [[1]] [
    set median-truthdist-b median truthdist-b
    set median-truthdist-c median truthdist-c
    set median-truthdist-m median truthdist-m
    set mean-truthdist-b mean truthdist-b
    set mean-truthdist-c mean truthdist-c
    set mean-truthdist-m mean truthdist-m
    stop
    ]
end


to interact [kate john]
  let kate-is-auth? false
  let john-is-auth? false
  ask kate [ ; find out if kate is a fact-checker
    if breed = fact-checkers or breed = afact-checkers [
      set kate-is-auth? true
    ]
  ]
  ask john [ ; find out if john is a fact-checker
   if breed = fact-checkers or breed = afact-checkers [
    set john-is-auth? true
   ] 
  ]
  let props pick-props-to-compare ; we set props to the list of propositions returned by pick-props...
  while [not empty? props] [ ; while props is nonempty, we compare the attidudes of the turtles towards those props 
    let current-prop first props
    set props but-first props
    
    if kate-is-auth? = false and john-is-auth? = false [ ;if neither agent is a fact-checker or afact-checker
     ifelse item current-prop [old-attitude-list] of kate != item current-prop [old-attitude-list] of john [;if they disagree
        if item current-prop [old-loudness-list] of kate > item current-prop [old-loudness-list] of john [;if kate is louder
          ifelse item current-prop [old-attitude-list] of john = 0 [;if john is at the tipping point
            ask john [;we ask john to switch to kate's attitude
              if item current-prop [old-attitude-list] of kate = 0 [user-message (word kate "shouldn't be indifferent if the code's right" )]
              set new-attitude-list replace-item current-prop new-attitude-list item current-prop [old-attitude-list] of kate
            ]
          ][ 
            ask john [ ;else, we ask john to reduce his loudness if it's above 0, else we change his attitude to 0
              ifelse item current-prop old-loudness-list = 0 [
                set new-attitude-list replace-item current-prop new-attitude-list 0
              ]
              [ 
              set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list - 1)
              set num-of-decreased-loudness num-of-decreased-loudness + 1
              ]
            ]  
          ]
        ]
        if item current-prop [old-loudness-list] of kate < item current-prop [old-loudness-list] of john [
          ifelse item current-prop [old-attitude-list] of kate = 0 [
            ask kate [
              if item current-prop [old-attitude-list] of john = 0 [user-message (word john "shouldn't be indifferent if the code's right" ) ]
                set new-attitude-list replace-item current-prop new-attitude-list item current-prop [old-attitude-list] of john
            ]
          ]
          [
            ask kate [
              ifelse item current-prop old-loudness-list = 0 [
                set new-attitude-list replace-item current-prop new-attitude-list 0
              ]
              [ 
              set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list - 1)
              set num-of-decreased-loudness num-of-decreased-loudness + 1
              ]
            ]  
          ]
        ]
     ] ;else kate and john agree
     [ 
       if item current-prop [old-attitude-list] of kate != 0 [ ;since john and kate agree and both aren't fact-checkers,
         ;we don't need to check that john's attitude is 0 as well
       ask kate [ if item current-prop old-loudness-list < max-loudness [
           set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list + 1) 
           set num-of-increased-loudness num-of-increased-loudness + 1 ] ]
       ask john [ if item current-prop old-loudness-list < max-loudness [
           set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list + 1)
           set num-of-increased-loudness num-of-increased-loudness + 1 ] ]
       ]
     ]
    ];end of decisions when neither kate nor john are fact-checkers

    if kate-is-auth? = false and john-is-auth? = true [ 
     ifelse item current-prop [old-attitude-list] of kate != item current-prop [old-attitude-list] of john [
        if item current-prop [old-loudness-list] of kate < item current-prop [old-loudness-list] of john [
          ifelse item current-prop [old-attitude-list] of kate = 0 [
            if item current-prop [old-attitude-list] of john = 0 [user-message (word "john shouldn't be indifferent" ) ]
            ask kate [
              set new-attitude-list replace-item current-prop new-attitude-list item current-prop [old-attitude-list] of john
            ]
          ]
          [ 
            if item current-prop [old-attitude-list] of john = 0 [user-message (word "john shouldn't be indifferent" ) ]
            ask kate [
              ifelse item current-prop old-loudness-list = 0 [
                set new-attitude-list replace-item current-prop new-attitude-list 0
              ]
              [ 
              set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list - 1)
              set num-of-decreased-loudness num-of-decreased-loudness + 1
              ]
            ]  
          ]
        ]
     ] ;else kate and john agree and kate should get a boost since john is the fact checker
     [ ask kate [ if item current-prop old-loudness-list < max-loudness [
           set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list + 1)
           set num-of-increased-loudness num-of-increased-loudness + 1 ] ]
     ]
    ]

    if kate-is-auth? = true and john-is-auth? = false [ 
     ifelse item current-prop [old-attitude-list] of kate != item current-prop [old-attitude-list] of john [
        if item current-prop [old-loudness-list] of kate > item current-prop [old-loudness-list] of john [
          ifelse item current-prop [old-attitude-list] of john = 0 [
            if item current-prop [old-attitude-list] of kate = 0 [user-message (word kate "shouldn't be indifferent" ) ]
            ask john [
              set new-attitude-list replace-item current-prop new-attitude-list item current-prop [old-attitude-list] of kate
            ]
          ]
          [ 
            if item current-prop [old-attitude-list] of kate = 0 [user-message (word kate "shouldn't be indifferent" ) ]
            ask john [
              ifelse item current-prop old-loudness-list = 0 [
                set new-attitude-list replace-item current-prop new-attitude-list 0
              ]
              [ 
              set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list - 1)
              set num-of-decreased-loudness num-of-decreased-loudness + 1
              ]
            ]  
          ]
        ]
     ] ;else kate and john agree and john should get a boost since kate is the fact checker
     [ ask john [ if item current-prop old-loudness-list < max-loudness [
           set new-loudness-list replace-item current-prop new-loudness-list (item current-prop old-loudness-list + 1)
           set num-of-increased-loudness num-of-increased-loudness + 1 ] ]
     ]     
    ]
   ];end of while loop for propositions to be compared 
  update-meet-history kate john
  update-interacted-agents kate john
end





to update-truthflux
  let props pick-props-to-compare ; we set props to the list of propositions returned by pick-props...
  ifelse length props > 1 [user-message (word "This model can only handle patch updates when there's one proposition in question")
  ]
  [
    let current-prop first props
    ask patches [
      if any? turtles-here[ 
        let tsum 0
        ask turtles-here [
          let att (item current-prop old-attitude-list * item current-prop old-loudness-list);;since disbelief is -1, we simply multply loudness by it to get a negative number
          set tsum tsum + att
        ]
        set truthflux truthflux * truth-decay + (tsum / count turtles-here)  
        update-patch-color
      ]
    ]
  ]
end

to update-patch-color
  set pcolor 5 + truthflux / 10
end




to update-interacted-agents [kate john]
  ask kate [ 
    if breed = millians [
      set num-mill-interacted num-mill-interacted + 1
    ]
    if breed = chums [
      set num-chum-interacted num-chum-interacted + 1
    ]
    if breed = believers [
      set num-believer-interacted num-believer-interacted + 1
    ]
  ]
  ask john [ 
    if breed = millians [
      set num-mill-interacted num-mill-interacted + 1
    ]
    if breed = chums [
      set num-chum-interacted num-chum-interacted + 1
    ]
    if breed = believers [
      set num-believer-interacted num-believer-interacted + 1
    ]
  ]  
end

to update-meet-history [kate john]
  ask kate [
    set meet-history fput [who] of john meet-history
    set meet-history remove-duplicates meet-history
    if length meet-history > maxhistory [
    set meet-history but-last meet-history
    ]
  ]
  ask john [
    set meet-history fput [who] of kate meet-history
    set meet-history remove-duplicates meet-history
    if length meet-history > maxhistory [
    set meet-history but-last meet-history
    ]
  ]
end

to-report make-new-attitudes
  repeat num-props-to-compare [
    
  ]
  report new-attitude-list
end

to update-attitudes
  set old-attitude-list new-attitude-list ;this turns the new list into the old one for the next tick
  set old-loudness-list new-loudness-list
end

to-report pick-props-to-compare ; this function selects propositions for comparison
  set props-to-compare [ ]
  repeat num-props-to-compare [
   set props-to-compare lput random num-props props-to-compare
  ]
  report props-to-compare
end

to move
  move-millians
  move-believers
  move-chums
end

to find-minglers
  set minglers other turtles in-radius vision
  set minglers minglers with [not member? [who] of self [meet-history] of myself]
;  set minglers minglers with [ color = blue ] 
end


to move-millians
  let current-prop first pick-props-to-compare ;picks the first prop from the list returned by pick-props-to-compare  
  ask millians [
    find-minglers 
    let opp-minglers minglers with [item current-prop old-attitude-list  != item current-prop [old-attitude-list] of myself]
    set nearest-mingler min-one-of opp-minglers [distance myself]
    ifelse nearest-mingler = nobody[ 
      rt random-float 90 - random-float 90; turtle turns x degrees to the right if positve, left if negative
      fd 0.1
    ]
    [
      ifelse [xcor] of nearest-mingler = [xcor] of self and [ycor] of nearest-mingler = [ycor] of self[
        fd 0.1 
      ]
      [
        set heading towardsxy [xcor] of nearest-mingler [ycor] of nearest-mingler
        fd 0.1
      ]
    ]
  ]
end

to move-believers
  ask believers [
    ifelse believers-search = true [
      find-minglers
      set nearest-mingler min-one-of minglers [distance myself]
      ifelse nearest-mingler = nobody [
          rt random-float 90 - random-float 90; turtle turns x degrees to the right if positve, left if negative
          fd 0.1 ; turtle moves forward by 1 step
      ]
      [
        ifelse [xcor] of nearest-mingler = [xcor] of self and [ycor] of nearest-mingler = [ycor] of self[
          fd 0.1 
        ]
        [
          set heading towardsxy [xcor] of nearest-mingler [ycor] of nearest-mingler
          fd 0.1
        ]        
      ]
    ]
    [
    rt random-float 90 - random-float 90; turtle turns x degrees to the right if positve, left if negative
    fd 0.1 ; turtle moves forward by 1 step
    ]
  ]
end

to move-chums
  let current-prop first pick-props-to-compare ;picks the first prop from the list returned by pick-props-to-compare  
  ask chums [
    find-minglers 
    let shared-minglers minglers with [item current-prop old-attitude-list = item current-prop [old-attitude-list] of myself]
    set nearest-mingler min-one-of shared-minglers [distance myself] 
    ifelse nearest-mingler = nobody[ 
      rt random-float 90 - random-float 90; turtle turns x degrees to the right if positve, left if negative
      fd 0.1
    ]
    [
      ifelse [xcor] of nearest-mingler = [xcor] of self and [ycor] of nearest-mingler = [ycor] of self[
        fd 0.1 
      ]
      [
        set heading towardsxy [xcor] of nearest-mingler [ycor] of nearest-mingler
        fd 0.1
      ]
    ]
  ]
end



;******************************
;******************************
;This section is for statistics
;******************************
;******************************

to statistics
  set current-avg-dist-truth avg-distance-to-truth
  set current-avg-dist-others avg-distance-to-others
  set current-avg-disagree-truth avg-disagreement-to-truth ; this avg ignores indifference
  set current-avg-disagree-others avg-disagreement-to-others; this avg ignores indifference
  set current-avg-millian-disagree-truth avg-millian-disagreement-to-truth
  set current-avg-believer-disagree-truth avg-believer-disagreement-to-truth
  set current-avg-chum-disagree-truth avg-chum-disagreement-to-truth
  set current-avg-millian-loudness avg-millian-loudness
  set current-avg-chum-loudness avg-chum-loudness
  set current-avg-believer-loudness avg-believer-loudness
  set truthdist-b fput current-avg-believer-disagree-truth truthdist-b
  set truthdist-c fput current-avg-chum-disagree-truth truthdist-c
  set truthdist-m fput current-avg-millian-disagree-truth truthdist-m
  truthdist-update
end

to truthdist-update
  ifelse ticks = 0 [initialize-truthdist]
  [
    if current-avg-believer-disagree-truth > max-truthdist-b [ set max-truthdist-b current-avg-believer-disagree-truth
      set tickof-first-max-truthdist-b ticks 
      set tickof-last-max-truthdist-b ticks]
    if current-avg-millian-disagree-truth > max-truthdist-m [ set max-truthdist-m current-avg-millian-disagree-truth
      set tickof-first-max-truthdist-m ticks
      set tickof-last-max-truthdist-m ticks ]
    if current-avg-chum-disagree-truth > max-truthdist-c [ set max-truthdist-c current-avg-chum-disagree-truth
      set tickof-first-max-truthdist-c ticks
      set tickof-last-max-truthdist-c ticks ] 
    if current-avg-believer-disagree-truth = max-truthdist-b [ set tickof-last-max-truthdist-b ticks ]
    if current-avg-millian-disagree-truth = max-truthdist-m [ set tickof-last-max-truthdist-m ticks ]
    if current-avg-chum-disagree-truth = max-truthdist-c [ set tickof-last-max-truthdist-c ticks ]
    if current-avg-believer-disagree-truth < min-truthdist-b [ set min-truthdist-b current-avg-believer-disagree-truth
      set tickof-first-min-truthdist-b ticks 
      set tickof-last-min-truthdist-b ticks]
    if current-avg-millian-disagree-truth < min-truthdist-m [ set min-truthdist-m current-avg-millian-disagree-truth
      set tickof-first-min-truthdist-m ticks
      set tickof-last-min-truthdist-m ticks ]
    if current-avg-chum-disagree-truth < min-truthdist-c [ set min-truthdist-c current-avg-chum-disagree-truth
      set tickof-first-min-truthdist-c ticks
      set tickof-last-min-truthdist-c ticks ] 
    if current-avg-believer-disagree-truth = min-truthdist-b [ set tickof-last-min-truthdist-b ticks ]
    if current-avg-millian-disagree-truth = min-truthdist-m [ set tickof-last-min-truthdist-m ticks ]
    if current-avg-chum-disagree-truth = min-truthdist-c [ set tickof-last-min-truthdist-c ticks ]    
  ]
end

to initialize-truthdist
 set max-truthdist-b current-avg-believer-disagree-truth
 set max-truthdist-c current-avg-chum-disagree-truth
 set max-truthdist-m current-avg-millian-disagree-truth
 set min-truthdist-b current-avg-believer-disagree-truth
 set min-truthdist-c current-avg-chum-disagree-truth
 set min-truthdist-m current-avg-millian-disagree-truth
 set tickof-first-max-truthdist-b 1
 set tickof-first-max-truthdist-c 1
 set tickof-first-max-truthdist-m 1
 set tickof-last-max-truthdist-b 1
 set tickof-last-max-truthdist-c 1
 set tickof-last-max-truthdist-m 1
 set tickof-first-min-truthdist-b 1
 set tickof-first-min-truthdist-c 1
 set tickof-first-min-truthdist-m 1
 set tickof-last-min-truthdist-b 1
 set tickof-last-min-truthdist-c 1
 set tickof-last-min-truthdist-m 1
end

to-report avg-millian-loudness
  let current-prop first pick-props-to-compare
  let loudness-sum 0
  ifelse num-millians != 0 [
    ask millians [
      set loudness-sum loudness-sum + item current-prop new-loudness-list
    ]
    report loudness-sum / num-millians
  ]  [ report 0]
end

to-report avg-chum-loudness
  let current-prop first pick-props-to-compare
  let loudness-sum 0
  ifelse num-chums != 0 [
    ask chums [
      set loudness-sum loudness-sum + item current-prop new-loudness-list
    ]
    report loudness-sum / num-chums
  ]  [ report 0]
end

to-report avg-believer-loudness
  let current-prop first pick-props-to-compare
  let loudness-sum 0
  ifelse num-believers != 0 [
    ask believers [
      set loudness-sum loudness-sum + item current-prop new-loudness-list
    ]
    report loudness-sum / num-believers
  ]  [ report 0]
end

to-report num-attitude-groups ;how many agents do not have identical attitude sets
  let num-groups [ ]
  ask turtles with [breed != fact-checkers] [
   set num-groups lput new-attitude-list num-groups
  ]
  set num-groups remove-duplicates num-groups
  report length num-groups
end

to-report mode-attitude-group ;
  let num-groups [ ]
  ask turtles with [breed != fact-checkers] [
   set num-groups lput new-attitude-list num-groups
  ]
  set num-groups remove-duplicates num-groups
  report modes num-groups
end

to-report avg-distance-to-truth
  let num-non-fc 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed != fact-checkers] [
     set total-dist (total-dist + hammy-distance truth-list old-attitude-list)
     set num-non-fc num-non-fc + 1
   ] 
  report total-dist / num-non-fc
end

to-report avg-distance-to-others
  let num-of-comparisons 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed != fact-checkers] [
   ask other turtles with [breed != fact-checkers] [
     set total-dist (total-dist + hammy-distance [old-attitude-list] of myself [old-attitude-list] of self)
     set num-of-comparisons num-of-comparisons + 1
   ]
  ]
  report total-dist / num-of-comparisons
end

to-report avg-disagreement-to-truth ; this distance measure ignores indifference attitudes
  let num-non-fc 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed != fact-checkers] [
     set total-dist (total-dist + truth-distance truth-list old-attitude-list)
     set num-non-fc num-non-fc + 1
   ] 
  report total-dist / num-non-fc
end

to-report avg-millian-disagreement-to-truth ; this distance measure ignores indifference attitudes
  let count-millians 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed = millians] [
     set total-dist (total-dist + truth-distance truth-list old-attitude-list)
     set count-millians count-millians + 1
   ] 
  ifelse count-millians != 0 [
    report total-dist / count-millians
  ][ report 0]
end

to-report avg-chum-disagreement-to-truth ; this distance measure ignores indifference attitudes
  let count-chums 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed = chums] [
     set total-dist (total-dist + truth-distance truth-list old-attitude-list)
     set count-chums count-chums + 1
   ] 
  ifelse count-chums != 0 [  
    report total-dist / count-chums
  ][ report 0]
end

to-report avg-believer-disagreement-to-truth ; this distance measure ignores indifference attitudes
  let count-believers 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed = believers] [
     set total-dist (total-dist + truth-distance truth-list old-attitude-list)
     set count-believers count-believers + 1
   ] 
  ifelse count-believers != 0 [
    report total-dist / count-believers
  ][report 0]
end

to-report avg-disagreement-to-others ; this distance measure ignores indifference attitudes
  let num-of-comparisons 0 ;variable for total num of fact-checkers
  let total-dist 0 ;variable for total distance
  ask turtles with [breed != fact-checkers] [
   ask other turtles with [breed != fact-checkers] [
     set total-dist (total-dist + truth-distance [old-attitude-list] of myself [old-attitude-list] of self)
     set num-of-comparisons num-of-comparisons + 1
   ]
  ]
  report total-dist / num-of-comparisons
end

to-report hammy-distance [list1 list2] ; how many differences there are between two lists, which isn't quite the hamming distance
  let ham 0
  foreach n-values length list1 [?] [
   let item1 item ? list1
   let item2 item ? list2
   if item1 != item2 [
     set ham ham + 1 
    ]
  ] 
  report ham
end

to-report truth-distance [list1 list2] ; how many differences there are between two lists, ignoring indifference
  let cheese 0
  foreach n-values length list1 [?] [
   let item1 item ? list1
   let item2 item ? list2
   if item1 != 0 and item2 != 0 and item1 != item2 [
     set cheese cheese + 1 
    ]
  ] 
  report cheese
end


;; Use a seed created by the NEW-SEED reporter
to use-new-seed
  set my-seed new-seed            ;; generate a new seed
  output-print word "Generated seed: " my-seed  ;; print it out
  random-seed my-seed             ;; use the new seed
end

;; Use a seed entered by the user
to use-seed-from-user
  set my-seed read-from-string user-input "Enter a random seed (an integer):"
  output-print word "User-entered seed: " my-seed  ;; print it out
  random-seed my-seed             ;; use the new seed
end
@#$#@#$#@
GRAPHICS-WINDOW
208
10
528
351
15
15
10.0
1
10
1
1
1
0
1
1
1
-15
15
-15
15
0
0
1
ticks
30.0

BUTTON
7
253
73
286
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
75
253
130
286
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
7
10
180
43
num-sci
num-sci
0
25
10
1
1
NIL
HORIZONTAL

SLIDER
7
116
179
149
num-believers
num-believers
0
500
105
5
1
NIL
HORIZONTAL

SLIDER
13
527
185
560
num-props
num-props
1
50
1
1
1
NIL
HORIZONTAL

BUTTON
134
253
197
286
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
16
576
181
609
num-props-to-compare
num-props-to-compare
1
num-props
1
1
1
NIL
HORIZONTAL

SLIDER
9
301
181
334
max-loudness
max-loudness
0
15
3
1
1
NIL
HORIZONTAL

SLIDER
7
346
189
379
init-max-believer-loudness
init-max-believer-loudness
0
max-loudness
1
1
1
NIL
HORIZONTAL

PLOT
555
23
1147
282
Distances
time
# of props
0.0
10.0
0.0
1.0
true
true
"" ""
PENS
"All" 1.0 0 -13840069 true "" "plot current-avg-disagree-truth"
"Millians" 1.0 0 -10141563 true "" "plot current-avg-millian-disagree-truth"
"Chums" 1.0 0 -8431303 true "" "plot current-avg-chum-disagree-truth"
"Believers" 1.0 0 -13345367 true "" "plot current-avg-believer-disagree-truth"

MONITOR
424
374
543
419
NIL
num-attitude-groups
17
1
11

MONITOR
413
430
542
475
NIL
mode-attitude-group
17
1
11

SWITCH
6
477
200
510
world-loudness-max
world-loudness-max
0
1
-1000

SWITCH
12
620
214
653
plus-one-max-world-loudness
plus-one-max-world-loudness
0
1
-1000

SWITCH
10
665
264
698
set-init-believer-loudness-max
set-init-believer-loudness-max
1
1
-1000

SWITCH
204
488
481
521
believers-facters-opposite-attitude
believers-facters-opposite-attitude
1
1
-1000

SLIDER
6
158
178
191
num-millians
num-millians
0
50
0
5
1
NIL
HORIZONTAL

SLIDER
7
202
179
235
num-chums
num-chums
0
50
0
5
1
NIL
HORIZONTAL

SLIDER
9
431
181
464
vision
vision
0.0
20.0
4
0.5
1
patches
HORIZONTAL

SLIDER
9
388
181
421
maxhistory
maxhistory
0
10
8
1
1
NIL
HORIZONTAL

SWITCH
214
372
404
405
patch-announcement
patch-announcement
1
1
-1000

PLOT
559
505
1145
780
Interactions
NIL
# of interactions
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Millians" 1.0 0 -13360827 true "" "plot num-mill-interacted"
"Chums" 1.0 0 -8431303 true "" "plot num-chum-interacted"
"Believers" 1.0 0 -14070903 true "" "plot num-believer-interacted"

PLOT
558
301
1147
489
Loudness
NIL
Loudness
0.0
10.0
0.0
3.0
true
true
"" ""
PENS
"Millians" 1.0 0 -11783835 true "" "plot avg-millian-loudness"
"Chums" 1.0 0 -8431303 true "" "plot avg-chum-loudness"
"Believers" 1.0 0 -14070903 true "" "plot avg-believer-loudness"

SWITCH
217
423
378
456
believers-search
believers-search
1
1
-1000

SLIDER
301
556
473
589
truth-decay
truth-decay
0
1
0.7
0.05
1
NIL
HORIZONTAL

SLIDER
7
61
179
94
num-asci
num-asci
0
25
10
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -7500403 true true 135 285 195 285 270 90 30 90 105 285
Polygon -7500403 true true 270 90 225 15 180 90
Polygon -7500403 true true 30 90 75 15 120 90
Circle -1 true false 183 138 24
Circle -1 true false 93 138 24

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="betaexperiment" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <exitCondition>num-attitude-groups = 1 and mode-attitude-group = [[1]]</exitCondition>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <enumeratedValueSet variable="maxhistory">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="3"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="2"/>
      <value value="5"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="betaexperimentsmall" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>num-attitude-groups = 1 and mode-attitude-group = [[1]]</exitCondition>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <enumeratedValueSet variable="maxhistory">
      <value value="1"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="betaexperimenttiny" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>num-attitude-groups = 1 and mode-attitude-group = [[1]]</exitCondition>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <enumeratedValueSet variable="maxhistory">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="expS3M25C25B25L5H10PtV3" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>num-attitude-groups = 1 and mode-attitude-group = [[1]]</exitCondition>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="expS7M25C25B25L5H10PtV3" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>num-attitude-groups = 1 and mode-attitude-group = [[1]]</exitCondition>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="basic01" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="1"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="expS5L5H5_10PtV3" repetitions="25" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="1"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="basic02" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="3"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="5"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="1"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="nov14S5L5H5_10PtV3" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="50"/>
      <value value="75"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="nov15S5L5H5_10PtV3" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="chumsnmillians" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3500"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="chumsvsmilliansnbelievers" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3500"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="diversitytest" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="4000"/>
    <metric>max-truthdist-b</metric>
    <metric>max-truthdist-c</metric>
    <metric>max-truthdist-m</metric>
    <metric>min-truthdist-b</metric>
    <metric>min-truthdist-c</metric>
    <metric>min-truthdist-m</metric>
    <metric>tickof-first-max-truthdist-b</metric>
    <metric>tickof-first-max-truthdist-c</metric>
    <metric>tickof-first-max-truthdist-m</metric>
    <metric>tickof-last-max-truthdist-b</metric>
    <metric>tickof-last-max-truthdist-c</metric>
    <metric>tickof-last-max-truthdist-m</metric>
    <metric>tickof-first-min-truthdist-b</metric>
    <metric>tickof-first-min-truthdist-c</metric>
    <metric>tickof-first-min-truthdist-m</metric>
    <metric>tickof-last-min-truthdist-b</metric>
    <metric>tickof-last-min-truthdist-c</metric>
    <metric>tickof-last-min-truthdist-m</metric>
    <metric>median-truthdist-b</metric>
    <metric>median-truthdist-c</metric>
    <metric>median-truthdist-m</metric>
    <metric>mean-truthdist-b</metric>
    <metric>mean-truthdist-c</metric>
    <metric>mean-truthdist-m</metric>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="0"/>
      <value value="3"/>
      <value value="6"/>
      <value value="9"/>
      <value value="12"/>
      <value value="15"/>
      <value value="18"/>
      <value value="21"/>
      <value value="24"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="statstest1" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="200"/>
    <metric>current-avg-millian-disagree-truth</metric>
    <metric>current-avg-believer-disagree-truth</metric>
    <metric>current-avg-chum-disagree-truth</metric>
    <metric>current-avg-disagree-truth</metric>
    <enumeratedValueSet variable="init-max-believer-loudness">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-loudness">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="patch-announcement">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="vision">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="world-loudness-max">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-sci">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="maxhistory">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="plus-one-max-world-loudness">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-believers">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-chums">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-facters-opposite-attitude">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="set-init-believer-loudness-max">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-props-to-compare">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="believers-search">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-millians">
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
