GLOBALS
[ SAMPLE#
  VARI-COLOR
  BACKGROUND
  BCOLOR
  BCOLOR2
  VCOLOR
  BRIGHTNESS
  CHECKERED?
  TRANS?
  OPACITY
  ZOOM
  GALLERY-ROW-SIZE
  GALLERY-COUNT
  GALLERY-X
  GALLERY-Y
  OLD-PAGE
  PAGE-NUMBER
  PAGES-COUNT
  TITLE-PATCH
  PAGE-LABEL-PATCH
  COLOR-LABEL-PATCH
  SORT-SHAPES
  PIXEL
  ANIMATE-START
  ANIMATE-END
  ANIMATE-FPS
  ANIMATE-FRAME
  BACK1
  BACK2
  BIG-SAMPLE
  NETLOGO-SHAPES
  NETLOGO-LIBRARY-SHAPES
]

BREED [ SAMPLES   SAMPLE   ]
BREED [ BACKDROPS BACKDROP ]
BREED [ PREVIEWS  PREVIEW  ]
BREED [ HALOS     HALO     ]

SAMPLES-OWN [ MY-HALO   IDX  ]
HALOS-OWN   [ MY-SAMPLE ]

TO-REPORT UPPERCASE [ STRING ]
  SET STRING (WORD STRING)
  ;; CHARACTERS IN APPROX ENGLISH USAGE FREQUENCY ORDER
  LET UPP "ETAOINSHRDLCUMWFGYPBVKJXQZ"
  LET LOW "etaoinshrdlcumwfgypbvkjxqz"
  FOREACH RANGE LENGTH STRING
  [ I ->
    LET N POSITION (ITEM I STRING) LOW
    IF N != FALSE
    [ SET STRING REPLACE-ITEM I STRING (ITEM N UPP)
    ]
  ]
  REPORT STRING
END

TO-REPORT LOWERCASE [ STRING ]
  SET STRING (WORD STRING)
  ;; CHARACTERS IN APPROX ENGLISH USAGE FREQUENCY ORDER
  LET UPP "ETAOINSHRDLCUMWFGYPBVKJXQZ"
  LET LOW "etaoinshrdlcumwfgypbvkjxqz"
  FOREACH RANGE LENGTH STRING
  [ I ->
    LET N POSITION (ITEM I STRING) UPP
    IF N != FALSE
    [ SET STRING REPLACE-ITEM I STRING (ITEM N LOW)
    ]
  ]
  REPORT STRING
END


TO SETUP-WORLD
  SET GALLERY-ROW-SIZE 10
  SET GALLERY-COUNT GALLERY-ROW-SIZE * GALLERY-ROW-SIZE
  RESIZE-WORLD 0 (GALLERY-ROW-SIZE * 4 - 1) 0 (GALLERY-ROW-SIZE * 2) + 3
  SET-PATCH-SIZE 25
  SET PIXEL (1 / PATCH-SIZE)
  SET GALLERY-X MAX-PXCOR - (2 * GALLERY-ROW-SIZE) + 1
  SET GALLERY-Y MAX-PYCOR - 3
END

TO SETUP-GLOBALS
  SET SORT-SHAPES MAP LOWERCASE SORT SHAPES
  SET NETLOGO-SHAPES GET-NETLOGO-SHAPES
  SET NETLOGO-LIBRARY-SHAPES GET-NETLOGO-LIBRARY-SHAPES
  SET PAGES-COUNT 1 + INT (LENGTH SHAPES / GALLERY-COUNT)
  SET VARI-COLOR  GRAY
  SET BACKGROUND BLACK
  SET CHECKERED?  TRUE
  SET TRANS?     FALSE
  SET OPACITY        0
  SET BRIGHTNESS    20
  SET ZOOM         100
  SET SAMPLE#        0
  SET ANIMATE-START  0
  SET ANIMATE-END    0
  SET ANIMATE-FPS    4
  SET ANIMATE-FRAME  0
  SET BIG-SAMPLE NOBODY
  SET GALLERY-X  MIN-PXCOR + WORLD-WIDTH / 2
  SET GALLERY-Y  MAX-PYCOR - 3
  SET TITLE-PATCH PATCH (MIN-PXCOR) (MAX-PYCOR)
  SET PAGE-LABEL-PATCH PATCH (GALLERY-X - 2) (MAX-PYCOR)
  SET COLOR-LABEL-PATCH PATCH (MIN-PXCOR + 1) (MIN-PYCOR + 3)
END

TO SET-PAGE [ N ]
  SET OLD-PAGE PAGE-NUMBER
  SET PAGE-NUMBER MIN (LIST PAGES-COUNT MAX (LIST 0 N) )
  SET SAMPLE# PAGE-NUMBER * GALLERY-COUNT
  ASK SAMPLES [ SET HEADING 0 ]
  SET-TEXT PAGE-LABEL-PATCH (WORD "PAGE " (PAGE-NUMBER + 1)" OF " PAGES-COUNT " - " LENGTH SHAPES " SHAPES")
  SHOW-PREVIEW SAMPLE#
END

TO SHOW-PREVIEW [ N ]
  SET SAMPLE# N MOD LENGTH SHAPES
  LET NEW-PAGE INT (SAMPLE# / GALLERY-COUNT)
  IF NEW-PAGE != PAGE-NUMBER
  [ SET-PAGE NEW-PAGE
    STOP
  ]

  LET PREVIEW-SIZE (MIN LIST WORLD-WIDTH WORLD-HEIGHT) - 6
  IF NOT ANY? BACKDROPS
  [ CREATE-BACKDROPS 1
    [ HOME
      SET HEADING 0
      SET SIZE PREVIEW-SIZE
      LET CX MIN-PXCOR - .5 + SIZE / 2 + 1
      LET CY MIN-PYCOR - .5 + (WORLD-HEIGHT / 2)
      SETXY CX CY
      SET BACK1 SELF
      HATCH-BACKDROPS 1 [ SET BACK2      SELF ]
      HATCH-PREVIEWS  1 [ SET BIG-SAMPLE SELF ]
    ]
  ]
  SET ZOOM MAX (LIST 5 MIN (LIST 200 ZOOM))
  SET BACKGROUND BACKGROUND MOD 15
  SET VARI-COLOR VARI-COLOR MOD 17
  SET VCOLOR 0
  (
    IFELSE
    ( VARI-COLOR = 0 ) [ SET VCOLOR BLACK ]
    ( VARI-COLOR = 1 ) [ SET VCOLOR GRAY  ]
    ( VARI-COLOR = 2 ) [ SET VCOLOR WHITE ]
    [ SET VCOLOR 15 + 10 * ( VARI-COLOR - 2 ) ]
  )
  IF ( TRANS? )
  [ SET OPACITY 1 + ( ( OPACITY - 1 ) MOD 9 )
    SET VCOLOR LPUT INT ( 25.5 * OPACITY ) EXTRACT-RGB VCOLOR
  ]
  SET BRIGHTNESS BRIGHTNESS MOD 100
  SET BCOLOR SCALE-COLOR ( 5 + 10 * BACKGROUND )  BRIGHTNESS 0 100
  SET BCOLOR2 BCOLOR
  IF ( CHECKERED? ) [ SET BCOLOR BLACK ]
  SET-TEXT COLOR-LABEL-PATCH ( WORD "\n" "COLOR: " VCOLOR ", PCOLOR: " BCOLOR2 ",  ZOOM: " ZOOM "%" )
  ASK BACK1 [ SET SHAPE "SQUARE"       SET COLOR BCOLOR  ]
  ASK BACK2 [ SET SHAPE "CHECKS SMALL" SET COLOR BCOLOR2 ]
  ASK BIG-SAMPLE
  [
    SET SIZE PREVIEW-SIZE * ( ZOOM / 100 )
    SET SHAPE ITEM SAMPLE# SORT-SHAPES
    SET COLOR VCOLOR
    SET-TEXT TITLE-PATCH ( WORD "NETLOGO SHAPE LIBRARY VIEWER -- \"" SHAPE "\"")
  ]
  DISPLAY-SAMPLES
END

TO SETUP-SAMPLES
  LET OFFSET COUNT TURTLES
  ;; WITHOUT-INTERRUPTION
  ;; [
    CREATE-SAMPLES GALLERY-COUNT
    [ SET IDX WHO - OFFSET
      LET X GALLERY-X + 2 * (IDX MOD GALLERY-ROW-SIZE)
      LET Y GALLERY-Y - 2 * INT (IDX / GALLERY-ROW-SIZE)
      SET SHAPE "SQUARE"
      SET HEADING 0
      SET COLOR PCOLOR + 1
      SET SIZE 40 * PIXEL
      SETXY X Y
      ;; SHOW (WORD "X: " X "  Y: " Y )
    ;; ]
    ASK SAMPLES
    [
      HATCH-HALOS 1
      [ SET SHAPE "BLANK"
        SET COLOR WHITE
        SET SIZE 48 * PIXEL
        SET MY-SAMPLE MYSELF
        ASK MYSELF [ SET MY-HALO MYSELF ]
        HIDE-TURTLE
      ]
    ]
  ]
  SET OLD-PAGE -1
END

TO DISPLAY-SAMPLES
  IF NOT ANY? SAMPLES
  [ SETUP-SAMPLES ]
  IF OLD-PAGE != PAGE-NUMBER
  [ ;; UPDATE SHAPE IMAGES
    SET OLD-PAGE PAGE-NUMBER
    ASK SAMPLES
    [ LET SHAPE-NUM PAGE-NUMBER * GALLERY-COUNT + IDX
      ;; HIDE SAMPLE IF NO SHAPE (SAMPLE# IS BEYOND SHAPE LIST)
      ;; SHOW SHAPE-NUM
      IFELSE SHAPE-NUM >= LENGTH SHAPES
      [ SET SHAPE "BLANK"
        SET COLOR PCOLOR + 1
        HIDE-TURTLE
        ASK MY-HALO [ SET SHAPE "BLANK" SET COLOR WHITE HIDE-TURTLE ]
      ]
      [
        ;; ASSIGN SHAPE
        SET SHAPE ITEM SHAPE-NUM SORT-SHAPES
        SHOW-TURTLE
      ]
    ]
  ]
  ;; UPDATE COLORS AND HALOS
  ASK SAMPLES
  [
    SET COLOR VCOLOR
    LET NEW-HALO "BLANK"
    (IFELSE
      (SHAPE = [ SHAPE ] OF BIG-SAMPLE)
      [ SET NEW-HALO "SQUARE OPEN THICK" ]
      ( MEMBER? SHAPE NETLOGO-LIBRARY-SHAPES)
      [ SET NEW-HALO "SQUARE OPEN THIN" ]
      []
    )
    ASK MY-HALO
    [ SET SHAPE NEW-HALO
      SET COLOR WHITE
      SET HIDDEN? SHAPE = "BLANK"
    ]
  ]
END

TO SET-TEXT [ LOCATION TEXT ]
  LET JOIN [STRINGS -> WORD "\n" (REDUCE [ [ A B ] -> ( WORD A "\na" B ) ] ( SENTENCE STRINGS ) ) ]
  ASK LOCATION [ SET PLABEL ( RUN-RESULT JOIN TEXT ) ]
END

TO-REPORT TRIANGLE-WAVE [ X ]
  REPORT 2 * ABS( 2 * ( X - FLOOR( X + 0.5  ) ) ) - 1
END

TO-REPORT SAWTOOTH-WAVE [ X ]
  REPORT 2 * ( X - 0.5 - FLOOR X )
END

TO-REPORT SQUARE-WAVE [ X ]
  REPORT 2 * (2 * (FLOOR X) - (FLOOR (2 * X)) ) + 1
END

TO-REPORT SINE-WAVE [ X ]
  REPORT SIN (X * 360 )
END

TO-REPORT DC [ X ]
  REPORT (1 + X) / 2
END

TO ANIMATE
  SET ANIMATE-FPS FPS
  LET FRAME 1 + ANIMATE-END - ANIMATE-START
  IF FRAME = 0 [ SET FRAME 1 ]
  LET T (TIMER / FRAME * ANIMATE-FPS)
  IFELSE BOUNCE
  [ SET ANIMATE-FRAME FRAME * DC TRIANGLE-WAVE T ]
  [ SET ANIMATE-FRAME FRAME * DC SAWTOOTH-WAVE T ]
  SET ANIMATE-FRAME MIN LIST FRAME MAX LIST 0 ANIMATE-FRAME
  ASK BIG-SAMPLE [ SET SHAPE ITEM (ANIMATE-START + ANIMATE-FRAME) SORT-SHAPES ]
END

TO-REPORT GET-NETLOGO-SHAPES
  REPORT MAP LOWERCASE (LIST
    "AIRPLANE" "ARROW" "BOX" "BUG" "BUTTERFLY" "CAR"
    "CIRCLE" "CIRCLE 2" "COW" "CYLINDER" "DOT"
    "FACE HAPPY" "FACE NEUTRAL" "FACE SAD"
    "FISH" "FLAG" "FLOWER" "HOUSE" "LEAF" "LINE" "LINE HALF"
    "PENTAGON" "PERSON" "PLANT" "SHEEP" "SQUARE" "SQUARE 2"
    "STAR" "TARGET" "TREE" "TRIANGLE" "TRIANGLE 2" "TRUCK"
    "TURTLE" "WHEEL" "WOLF" "X")
END

TO-REPORT GET-NETLOGO-LIBRARY-SHAPES
  REPORT MAP LOWERCASE
  (LIST
;   567890123456789=123456789012345678901234567890123456789012345678901234567890
    "ACORN" "AIRPLANE 2" "AMBULANCE" "ANT" "ANT 2" "APPLE" "ARROW 2" "ARROW 3"
    "BALL BASEBALL" "BALL BASKETBALL" "BALL FOOTBALL" "BALL TENNIS" "BALLOON"
    "BALLPIN" "BANANA" "BEE" "BEE 2" "BIKE" "BIRD" "BIRD 2" "BIRD 3" "BIRD SIDE"
    "BOAT" "BOAT 2" "BOAT 3" "BOAT TOP" "BOOK" "BOTTLE" "BOWLING PIN" "BOX"
    "BOX 2" "BREAD" "BUILDING INSTITUTION" "BUILDING STORE" "BULLDOZER TOP"
    "BUS" "BUTTERFLY 2" "CACTUS" "CAMPSITE" "CANNON" "CANNON CARRIAGE" "CAR SIDE"
    "CAR TOP" "CAT" "CATERPILLAR" "CHECK" "CHECKER PIECE" "CHECKER PIECE 2"
    "CHESS BISHOP" "CHESS KING" "CHESS KNIGHT" "CHESS PAWN" "CHESS QUEEN"
    "CHESS ROOK" "CLOCK" "CLOUD" "COIN HEADS" "COIN TAILS" "COMPUTER SERVER"
    "COMPUTER WORKSTATION" "CONTAINER" "COW SKULL" "CRATE" "CROWN" "DART" "DIE 1"
    "DIE 2" "DIE 3" "DIE 4" "DIE 5" "DIE 6" "DOG" "DOLLAR BILL" "DROP" "EGG"
    "ELECTRIC OUTLET" "EMBLEM" "EXCLAMATION" "EYEBALL" "FACTORY" "FIRE"
    "FIRE DEPARTMENT" "FISH 2" "FISH 3" "FLOWER BUDDING" "FOOD" "FOOTPRINT HUMAN"
    "FOOTPRINT OTHER" "FROG TOP" "GARBAGE CAN" "GHOST" "HAWK" "HEX"
    "HEXAGONAL PRISM" "HOUSE BUNGALOW" "HOUSE COLONIAL" "HOUSE EFFICIENCY"
    "HOUSE RANCH" "HOUSE TWO STORY" "I BEAM" "KEY" "LANDER" "LANDER 2" "LEAF 2"
    "LETTER OPENED" "LETTER SEALED" "LIGHTNING" "LILY PAD" "LINK" "LOGS" "MAGNET"
    "MAMMOTH" "MOLECULE HYDROGEN" "MOLECULE OXYGEN" "MOLECULE WATER" "MONSTER"
    "MOON" "MOOSE" "MOOSE-FACE" "MORTAR PESTLE" "MOUSE SIDE" "MOUSE TOP"
    "MUSIC NOTES 1" "MUSIC NOTES 2" "MUSIC NOTES 3" "ORBIT 1" "ORBIT 2" "ORBIT 3"
    "ORBIT 4" "ORBIT 5" "ORBIT 6" "PAINTBRUSH" "PENCIL" "PERSON BUSINESS"
    "PERSON CONSTRUCTION" "PERSON DOCTOR" "PERSON FARMER" "PERSON GRADUATE"
    "PERSON LUMBERJACK" "PERSON POLICE" "PERSON SERVICE" "PERSON SOLDIER"
    "PERSON STUDENT" "PETALS" "PLANT MEDIUM" "PLANT SMALL" "POLICE" "PUMPKIN"
    "PUSHPIN" "RABBIT" "ROCKET" "SAILBOAT SIDE" "SHARK" "SHEEP 2" "SPIDER"
    "SPINNER" "SQUIRREL" "STRAWBERRY" "SUIT CLUB" "SUIT DIAMOND" "SUIT HEART"
    "SUIT SPADE" "SUN" "TANK" "TELEPHONE" "TILE BRICK" "TILE LOG" "TILE STONES"
    "TILE WATER" "TOOTH" "TRAIN" "TRAIN FREIGHT BOXCAR" "TRAIN FREIGHT ENGINE"
    "TRAIN FREIGHT HOPPER EMPTY" "TRAIN FREIGHT HOPPER FULL" "TRAIN PASSENGER CAR"
    "TRAIN PASSENGER ENGINE" "TRAIN SWITCHER ENGINE" "TREE PINE" "TRUCK CAB ONLY"
    "TRUCK CAB TOP" "TURTLE 2" "UFO SIDE" "UFO TOP" "VAN SIDE" "VAN TOP" "WARNING"
    "WOLF 2" "WOLF 3" "WOLF 4" "WOLF 5" "WOLF 6" "WOLF 7"
  )
END

TO _SETUP
  CA
  SETUP-WORLD
  SETUP-GLOBALS
  SET-TEXT TITLE-PATCH "NETLOGO SHAPE LIBRARY VIEWER"
  SET-PAGE 0
  ;; SETUP-SAMPLES
  SHOW-PREVIEW 0
END

TO STARTUP _SETUP END

TO SETUP STARTUP END

TO GO END
@#$#@#$#@
GRAPHICS-WINDOW
270
10
1278
619
-1
-1
25.0
1
20
1
1
1
0
0
0
1
0
39
0
23
0
0
1
ticks
30.0

BUTTON
5
10
75
44
RESET
STARTUP
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
165
95
221
129
▶
show-preview (sample# + 1)
NIL
1
T
OBSERVER
NIL
D
NIL
NIL
1

BUTTON
35
95
91
129
◀
show-preview (sample# - 1)
NIL
1
T
OBSERVER
NIL
A
NIL
NIL
1

BUTTON
5
240
160
274
CHANGE BACKGROUND
set background (background + 1) \nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
B
NIL
NIL
1

BUTTON
5
279
147
312
GRID BACKGROUND
SET CHECKERED? NOT CHECKERED?\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
G
NIL
NIL
1

BUTTON
165
55
221
89
▶▶
SET-PAGE PAGE-NUMBER + 1
NIL
1
T
OBSERVER
NIL
E
NIL
NIL
1

BUTTON
35
55
91
89
◀◀
set-page page-number - 1
NIL
1
T
OBSERVER
NIL
Q
NIL
NIL
1

BUTTON
5
340
84
374
ROTATE
EVERY 1 / 10 [\nASK SAMPLES [ RT 10 ]\nASK big-sample [ RT 10 ]\ndisplay\n]\n
T
1
T
OBSERVER
NIL
R
NIL
NIL
1

BUTTON
5
140
225
173
CHANGE COLOR
SET VARI-COLOR VARI-COLOR + 1\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
C
NIL
NIL
1

BUTTON
170
240
242
273
BRIGHT
SET bRIGHTNESS BRIGHTNESS + 10\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
N
NIL
NIL
1

BUTTON
95
95
157
128
▼
show-preview (sample# + GALLERY-ROW-SIZE)
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
95
55
157
88
▲
show-preview (sample# - GALLERY-ROW-SIZE)
NIL
1
T
OBSERVER
NIL
W
NIL
NIL
1

BUTTON
5
180
75
213
TRANS
SET TRANS? (TRANS? = FALSE)\nIF TRANS? AND OPACITY = 100 [ SET OPACITY 50 ]\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
T
NIL
NIL
1

BUTTON
80
180
150
213
MORE
SET OPACITY OPACITY - 1\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
M
NIL
NIL
1

BUTTON
160
305
260
338
ZOOM IN
SET ZOOM ZOOM + 5\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
=
NIL
NIL
1

BUTTON
160
375
260
408
ZOOM OUT
SET ZOOM ZOOM - 5\nshow-preview sample#
NIL
1
T
OBSERVER
NIL
-
NIL
NIL
1

BUTTON
10
430
107
463
START
set animate-start sample#
NIL
1
T
OBSERVER
NIL
I
NIL
NIL
1

BUTTON
10
470
107
503
END
set animate-end sample#
NIL
1
T
OBSERVER
NIL
O
NIL
NIL
1

SWITCH
125
470
228
503
BOUNCE
BOUNCE
0
1
-1000

BUTTON
125
430
227
463
PLAY
animate
T
1
T
OBSERVER
NIL
P
NIL
NIL
1

SLIDER
10
510
230
543
fps
fps
1
31
11.0
5
1
fps
HORIZONTAL

BUTTON
160
340
260
373
ZOOM RESET
SET ZOOM 100\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
0
NIL
NIL
1

BUTTON
155
180
225
213
LESS
SET OPACITY OPACITY + 1\nSHOW-PREVIEW SAMPLE#
NIL
1
T
OBSERVER
NIL
L
NIL
NIL
1

TEXTBOX
10
550
260
605
To animate: Select first shape, click START. Select final shape, click END. Click PLAY to play animation. 
12
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model displays all the shapes contained in the model, and can be used a a personal turtle shapes repository. 

## HOW TO USE IT

Use the various buttons to select shapes, change colors, even animate consecutive shapes.

You can add more shapes using the Turtle Shapes Editor to draw more shapes, or import shapes from your other models.


You can import the shapes, including the custom shapes by TurtleZero, in your own models.
@#$#@#$#@
default
true
3
Polygon -13840069 true false 75 255 30 225 45 225 45 210 60 210 60 195 90 240
Polygon -13840069 true false 135 60 120 30 135 0 165 0 180 30 165 60
Polygon -6459832 true true 120 60 180 60 210 75 225 105 225 210 210 240 180 255 120 255 90 240 75 210 75 120 90 75 120 60 120 90 180 90 105 210 120 225 195 105 195 210 180 225 120 225 105 210 105 105 120 90
Polygon -13840069 true false 135 255 150 270 135 300 165 270 165 255
Polygon -13840069 true false 225 255 270 225 255 225 255 210 240 210 240 195 210 240
Polygon -13840069 true false 225 90 270 60 255 60 255 45 240 45 240 30 210 75
Polygon -13840069 true false 75 90 30 60 45 60 45 45 60 45 60 30 90 75
Polygon -10899396 true false 105 210 105 105 120 90 180 90
Polygon -10899396 true false 120 225 195 105 195 210 180 225

0
false
0
Polygon -16777216 true false 60 45 75 30 90 15 105 15 120 30 210 30 255 75 255 240 270 270 240 300 75 300 45 270 30 165 45 60
Polygon -7500403 true true 60 77 93 76 93 242 119 257 185 255 193 282 120 285 64 260
Polygon -7500403 true true 74 41 213 281 243 262 96 25
Polygon -7500403 true true 127 59 182 60 200 76 204 185 226 218 229 77 201 36 111 35

1
false
0
Polygon -16777216 true false 45 60 105 0 195 0 195 210 225 210 240 285 210 300 75 300 45 270 60 210 75 210 75 90
Polygon -7500403 true true 76 272 78 237 119 236 121 59 73 61 116 15 167 15 166 243 216 237 206 287

2
false
0
Polygon -16777216 true false 45 135 15 75 60 15 105 0 150 0 225 0 270 75 270 135 195 195 270 195 285 285 150 300 15 285 30 210 105 150
Rectangle -7500403 true true 223 223 223 225
Polygon -7500403 true true 254 242 229 277 53 268 63 226 146 152 177 116 174 37 127 35 122 91 103 117 59 106 53 73 100 22 151 9 218 27 237 82 233 118 145 192 97 228 230 208

3
false
0
Polygon -16777216 true false 90 105 30 60 60 0 150 0 225 0 255 60 240 135 270 225 240 300 150 300 60 300 15 240 75 180
Polygon -7500403 true true 108 87 132 53 176 57 191 88 160 125 113 130 112 169 163 171 191 209 190 227 152 257 124 254 91 212 53 228 91 282 150 297 217 275 244 216 228 162 191 147 229 115 231 68 207 30 163 9 107 7 56 50

4
false
0
Polygon -16777216 true false 15 135 105 0 255 0 225 105 270 120 285 195 210 210 255 255 255 300 60 300 60 255 90 225 15 195
Polygon -7500403 true true 139 16 47 142 49 176 144 176 137 253 108 255 106 285 226 283 232 249 181 248 189 178 250 177 256 135 193 141 213 13 176 12 144 148 91 140 162 13

5
false
0
Polygon -16777216 true false 15 180 60 15 120 0 270 15 225 90 120 60 120 105 210 105 270 165 255 255 210 300 75 300 0 225 30 180
Polygon -7500403 true true 245 24 213 70 106 36 91 135 137 121 189 122 226 161 233 196 225 246 174 282 105 288 54 242 29 220 75 196 115 268 161 259 178 206 173 144 127 148 85 173 39 160 96 15

6
false
0
Polygon -16777216 true false 30 60 75 0 240 0 285 60 270 120 240 120 285 180 285 255 225 300 75 300 15 255 0 120
Polygon -7500403 true true 254 97 260 67 216 27 174 12 101 17 57 65 24 156 44 229 92 276 170 288 227 259 271 220 254 158 197 122 131 113 99 124 95 138 121 169 143 136 199 149 211 217 168 268 102 258 84 166 91 112 115 38 178 37 193 74 226 97

7
false
0
Polygon -16777216 true false 45 15 270 15 270 60 165 300 45 300 150 105 15 105
Polygon -7500403 true true 81 27 242 35 131 286 88 284 188 68 58 76

8
false
0
Polygon -16777216 true false 60 105 45 45 75 0 225 0 270 45 270 120 225 150 255 210 255 270 210 300 75 300 15 255 15 180
Polygon -7500403 true true 99 84 177 215 181 258 147 260 105 240 101 180 117 164 92 127 63 153 38 197 88 276 159 296 232 269 218 195 183 146 142 74 140 31 185 35 196 85 179 94 194 133 229 102 243 51 188 7 121 0 85 25 81 63

9
false
0
Polygon -16777216 true false 30 180 15 135 15 45 60 0 240 0 285 45 285 240 255 285 195 300 90 300 30 270 30 225 90 195 135 225 135 195
Polygon -7500403 true true 180 134 123 133 96 114 95 58 129 34 185 35 205 55 205 212 168 260 106 258 85 231 56 242 72 266 94 278 155 291 224 266 254 211 251 47 221 23 169 1 122 4 83 21 49 52 50 100 57 129 78 153 141 170 186 171

_10
false
0
Polygon -16777216 true false 30 90 60 30 105 15 255 15 300 60 300 255 285 285 240 300 45 300 15 270 45 225 75 210 75 135
Polygon -7500403 true true 41 88 62 109 98 72 95 255 47 254 50 282 150 285 159 253 129 249 135 53 109 26
Polygon -7500403 true true 168 77 191 52 264 50 293 82 290 241 265 275 229 279 228 243 265 235 267 88 210 88 195 233 215 246 214 279 179 269 164 240

_tool_car
false
0
Polygon -1 true false 75 135 75 105 180 105 225 150
Circle -7500403 true true 195 165 60
Circle -7500403 true true 45 165 60
Polygon -7500403 true true 45 195 45 180 60 165 75 165 90 165 105 180 105 195 195 195 195 180 210 165 225 165 240 165 255 180 255 195 270 180 255 150 45 135 45 165
Rectangle -7500403 true true 120 105 135 150
Polygon -7500403 true true 180 150 165 105 180 105 195 150
Polygon -7500403 true true 255 150 270 150 285 165 285 180 270 195 255 195
Circle -16777216 true false 210 180 30
Circle -16777216 true false 60 180 30
Polygon -7500403 true true 45 135 30 135 15 150 15 180 30 195 45 195
Polygon -7500403 true true 60 135 60 120 75 105 75 135
Polygon -16777216 false false 60 135 60 120 75 105 75 135 120 135 120 105 135 105 135 135 180 150 165 105 180 105 195 150 225 150 180 105 75 105

_tool_erase
false
0
Polygon -1184463 true false 270 15 240 75 165 30 180 0
Polygon -2064490 true false 120 120 150 60 225 105 195 165
Polygon -1 true false 150 60 165 30 240 75 225 105

_tri-1
true
0
Polygon -7500403 true true 0 300 300 0 300 300

_tri-2
true
0
Polygon -7500403 true true 300 300 0 0 0 300

acorn
false
0
Polygon -7500403 true true 146 297 120 285 105 270 75 225 60 180 60 150 75 105 225 105 240 150 240 180 225 225 195 270 180 285 155 297
Polygon -6459832 true false 121 15 136 58 94 53 68 65 46 90 46 105 75 115 234 117 256 105 256 90 239 68 209 57 157 59 136 8
Circle -16777216 false false 223 95 18
Circle -16777216 false false 219 77 18
Circle -16777216 false false 205 88 18
Line -16777216 false 214 68 223 71
Line -16777216 false 223 72 225 78
Line -16777216 false 212 88 207 82
Line -16777216 false 206 82 195 82
Line -16777216 false 197 114 201 107
Line -16777216 false 201 106 193 97
Line -16777216 false 198 66 189 60
Line -16777216 false 176 87 180 80
Line -16777216 false 157 105 161 98
Line -16777216 false 158 65 150 56
Line -16777216 false 180 79 172 70
Line -16777216 false 193 73 197 66
Line -16777216 false 237 82 252 84
Line -16777216 false 249 86 253 97
Line -16777216 false 240 104 252 96

air
false
0
Polygon -7500403 true true 15 135 90 90 195 135 285 90 285 90 195 150 90 105
Polygon -7500403 true true 15 165 90 120 195 165 285 120 285 120 195 180 90 135
Polygon -7500403 true true 15 195 90 150 195 195 285 150 285 150 195 210 90 165
Polygon -7500403 true true 15 225 90 180 195 225 285 180 285 180 195 240 90 195
Polygon -7500403 true true 15 105 90 60 195 105 285 60 285 60 195 120 90 75

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

airplane 2
true
0
Polygon -7500403 true true 150 26 135 30 120 60 120 90 18 105 15 135 120 150 120 165 135 210 135 225 150 285 165 225 165 210 180 165 180 150 285 135 282 105 180 90 180 60 165 30
Line -7500403 false 120 30 180 30
Polygon -7500403 true true 105 255 120 240 180 240 195 255 180 270 120 270

ambulance
false
0
Rectangle -7500403 true true 30 90 210 195
Polygon -7500403 true true 296 190 296 150 259 134 244 104 210 105 210 190
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Circle -16777216 true false 69 174 42
Rectangle -1 true false 288 158 297 173
Rectangle -1184463 true false 289 180 298 172
Rectangle -2674135 true false 29 151 298 158
Line -16777216 false 210 90 210 195
Rectangle -16777216 true false 83 116 128 133
Rectangle -16777216 true false 153 111 176 134
Line -7500403 true 165 105 165 135
Rectangle -7500403 true true 14 186 33 195
Line -13345367 false 45 135 75 120
Line -13345367 false 75 135 45 120
Line -13345367 false 60 112 60 142

animal  body
true
0
Polygon -7500403 false true 75 165 75 150 90 135 150 135 195 135 225 75 225 90 270 105 270 120 225 120 225 150 195 180 135 165 90 180

animal bone
true
0
Polygon -7500403 false true 150 300 120 150 135 120 165 120 180 150
Circle -7500403 false true 135 285 30

ant
true
0
Polygon -7500403 true true 136 61 129 46 144 30 119 45 124 60 114 82 97 37 132 10 93 36 111 84 127 105 172 105 189 84 208 35 171 11 202 35 204 37 186 82 177 60 180 44 159 32 170 44 165 60
Polygon -7500403 true true 150 95 135 103 139 117 125 149 137 180 135 196 150 204 166 195 161 180 174 150 158 116 164 102
Polygon -7500403 true true 149 186 128 197 114 232 134 270 149 282 166 270 185 232 171 195 149 186
Polygon -7500403 true true 225 66 230 107 159 122 161 127 234 111 236 106
Polygon -7500403 true true 78 58 99 116 139 123 137 128 95 119
Polygon -7500403 true true 48 103 90 147 129 147 130 151 86 151
Polygon -7500403 true true 65 224 92 171 134 160 135 164 95 175
Polygon -7500403 true true 235 222 210 170 163 162 161 166 208 174
Polygon -7500403 true true 249 107 211 147 168 147 168 150 213 150

ant 2
true
0
Polygon -7500403 true true 150 19 120 30 120 45 130 66 144 81 127 96 129 113 144 134 136 185 121 195 114 217 120 255 135 270 165 270 180 255 188 218 181 195 165 184 157 134 170 115 173 95 156 81 171 66 181 42 180 30
Polygon -7500403 true true 150 167 159 185 190 182 225 212 255 257 240 212 200 170 154 172
Polygon -7500403 true true 161 167 201 150 237 149 281 182 245 140 202 137 158 154
Polygon -7500403 true true 155 135 185 120 230 105 275 75 233 115 201 124 155 150
Line -7500403 true 120 36 75 45
Line -7500403 true 75 45 90 15
Line -7500403 true 180 35 225 45
Line -7500403 true 225 45 210 15
Polygon -7500403 true true 145 135 115 120 70 105 25 75 67 115 99 124 145 150
Polygon -7500403 true true 139 167 99 150 63 149 19 182 55 140 98 137 142 154
Polygon -7500403 true true 150 167 141 185 110 182 75 212 45 257 60 212 100 170 146 172

antenna
true
0
Polygon -7500403 false true 0 150 46 256 148 299 255 255 298 151 225 240 181 255 120 255 74 241
Polygon -7500403 false true 119 254 150 150 180 255

apple
false
0
Polygon -7500403 true true 33 58 0 150 30 240 105 285 135 285 150 270 165 285 195 285 255 255 300 150 268 62 226 43 194 36 148 32 105 35
Line -16777216 false 106 55 151 62
Line -16777216 false 157 62 209 57
Polygon -6459832 true false 152 62 158 62 160 46 156 30 147 18 132 26 142 35 148 46
Polygon -16777216 false false 132 25 144 38 147 48 151 62 158 63 159 47 155 30 147 18

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

arrow barbed
true
0
Polygon -7500403 true true 135 255 105 300 105 225 135 195 135 75 105 90 150 0 195 90 165 75 165 195 195 225 195 300 165 255

arrow down
false
4
Polygon -1184463 true true 195 30 195 165 240 165 150 270 60 165 105 165 105 30
Polygon -16777216 false false 195 30 195 165 240 165 150 270 60 165 105 165 105 30

arrow thin
true
0
Polygon -7500403 true true 150 0 60 150 120 150 120 293 180 293 180 150 240 150

arrow up
false
10
Polygon -13345367 true true 105 270 105 135 60 135 150 30 240 135 195 135 195 270
Polygon -16777216 false false 105 270 105 135 60 135 150 30 240 135 195 135 195 270

ball baseball
false
0
Circle -7500403 true true 30 30 240
Polygon -2674135 true false 247 79 243 86 237 106 232 138 232 167 235 199 239 215 244 225 236 234 229 221 224 196 220 163 221 138 227 102 234 83 240 71
Polygon -2674135 true false 53 79 57 86 63 106 68 138 68 167 65 199 61 215 56 225 64 234 71 221 76 196 80 163 79 138 73 102 66 83 60 71
Line -2674135 false 241 149 210 149
Line -2674135 false 59 149 90 149
Line -2674135 false 241 171 212 176
Line -2674135 false 246 191 218 203
Line -2674135 false 251 207 227 226
Line -2674135 false 251 93 227 74
Line -2674135 false 246 109 218 97
Line -2674135 false 241 129 212 124
Line -2674135 false 59 171 88 176
Line -2674135 false 59 129 88 124
Line -2674135 false 54 109 82 97
Line -2674135 false 49 93 73 74
Line -2674135 false 54 191 82 203
Line -2674135 false 49 207 73 226

ball basketball
false
0
Circle -7500403 true true 26 26 247
Polygon -16777216 false false 30 150 30 165 45 195 75 225 120 240 180 240 225 225 255 195 270 165 270 150 270 135 255 105 225 75 180 60 120 60 75 75 45 105 30 135
Line -16777216 false 30 150 270 150
Circle -16777216 false false 26 26 247

ball football
false
0
Polygon -7500403 false true 301 133 301 164 275 192 229 224 167 236 137 236 74 224 30 194 3 162 2 138 30 104 76 74 134 62 168 62 228 74 274 105
Polygon -7500403 true true 300 150 300 165 270 195 225 225 163 236 134 236 75 225 30 195 2 162 2 140 30 105 75 75 136 63 165 63 225 75 270 105 300 135
Line -16777216 false 300 155 5 155
Polygon -1 true false 28 193 28 107 51 91 51 209
Rectangle -1 true false 90 150 210 160
Rectangle -1 true false 198 141 205 170
Rectangle -1 true false 183 141 190 170
Rectangle -1 true false 168 141 175 170
Rectangle -1 true false 153 141 160 170
Rectangle -1 true false 138 141 145 170
Rectangle -1 true false 123 141 130 170
Rectangle -1 true false 108 141 115 170
Rectangle -1 true false 93 141 100 170
Polygon -1 true false 272 193 272 107 249 91 249 209

ball tennis
false
0
Circle -7500403 true true 30 30 240
Circle -7500403 false true 30 30 240
Polygon -16777216 true false 50 82 54 90 59 107 64 140 64 164 63 189 59 207 54 222 68 236 76 220 81 195 84 163 83 139 78 102 72 83 63 67
Polygon -16777216 true false 250 82 246 90 241 107 236 140 236 164 237 189 241 207 246 222 232 236 224 220 219 195 216 163 217 139 222 102 228 83 237 67
Polygon -1 true false 247 79 243 86 237 106 232 138 232 167 235 199 239 215 244 225 236 234 229 221 224 196 220 163 221 138 227 102 234 83 240 71
Polygon -1 true false 53 79 57 86 63 106 68 138 68 167 65 199 61 215 56 225 64 234 71 221 76 196 80 163 79 138 73 102 66 83 60 71

ball-pin
false
0
Polygon -1 true false 150 135 150 150 165 150 255 60 240 45 150 135
Circle -7500403 true true 181 31 86

balloon
false
0
Circle -7500403 true true 73 0 152
Polygon -7500403 true true 219 104 205 133 185 165 174 190 165 210 165 225 150 225 147 119
Polygon -7500403 true true 79 103 95 133 115 165 126 190 135 210 135 225 150 225 154 120
Rectangle -6459832 true false 129 241 173 273
Line -16777216 false 135 225 135 240
Line -16777216 false 165 225 165 240
Line -16777216 false 150 225 150 240

balloon0
false
0
Circle -2674135 true false 75 0 150
Circle -2674135 true false 88 43 122
Polygon -1184463 true false 150 180 180 225 180 270 135 315 165 270 165 225
Circle -2674135 true false 105 90 90

balloon1
false
0
Circle -2674135 true false 90 0 150
Circle -2674135 true false 88 43 122
Polygon -1184463 true false 105 165 135 210 135 255 90 300 120 255 120 210
Circle -2674135 true false 90 90 90

balloon2
false
0
Circle -2674135 true false 75 0 150
Circle -2674135 true false 88 43 122
Polygon -1184463 true false 150 180 120 225 120 270 165 315 135 270 135 225
Circle -2674135 true false 105 90 90

balloon3
false
0
Circle -2674135 true false 60 0 150
Circle -2674135 true false 90 43 122
Polygon -1184463 true false 195 165 165 210 165 255 210 300 180 255 180 210
Circle -2674135 true false 120 90 90

banana
false
0
Polygon -7500403 false true 25 78 29 86 30 95 27 103 17 122 12 151 18 181 39 211 61 234 96 247 155 259 203 257 243 245 275 229 288 205 284 192 260 188 249 187 214 187 188 188 181 189 144 189 122 183 107 175 89 158 69 126 56 95 50 83 38 68
Polygon -7500403 true true 39 69 26 77 30 88 29 103 17 124 12 152 18 179 34 205 60 233 99 249 155 260 196 259 237 248 272 230 289 205 284 194 264 190 244 188 221 188 185 191 170 191 145 190 123 186 108 178 87 157 68 126 59 103 52 88
Line -16777216 false 54 169 81 195
Line -16777216 false 75 193 82 199
Line -16777216 false 99 211 118 217
Line -16777216 false 241 211 254 210
Line -16777216 false 261 224 276 214
Polygon -16777216 true false 283 196 273 204 287 208
Polygon -16777216 true false 36 114 34 129 40 136
Polygon -16777216 true false 46 146 53 161 53 152
Line -16777216 false 65 132 82 162
Line -16777216 false 156 250 199 250
Polygon -16777216 true false 26 77 30 90 50 85 39 69

banana0
false
0
Polygon -7500403 false true 78 275 86 271 95 270 103 273 122 283 151 288 181 282 211 261 234 239 247 204 259 145 257 97 245 57 229 25 205 12 192 16 188 40 187 51 187 86 188 112 189 119 189 156 183 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       