; adapted from models library by Lada Adamic (see copyright below)
; for the purposes of SI708/CSCS608
; also now contains major improvements by Eytan Bakshy

;Finally, the model is constructed by Alon Sela (2016)

extensions [nw]
globals
[
  new-node  ;; the last node we created
  degrees   ;; this is an array that contains each node in
            ;; proportion to its degree
  time
  num-infected
  previous-num-infected
  tree-mode?
  spreading-group

]

turtles-own
[
  infected?        ;; true if agent has been infected
]

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  set tree-mode? false
  set-default-shape turtles "circle"
  set degrees []   ;; initialize the array to be empty
  ;; make the initial network of two turtles and an edge


  make-node ;; add the very first node

  let first-node new-node  ;; remember that its the first node

  ;; the following few lines create a cycle of length 5
  ;; this is just an arbitrary way to start a network

  let prev-node new-node
  repeat 4 [
    make-node ;; second node
    make-edge new-node prev-node ;; make the edge
    set degrees lput prev-node degrees
    set degrees lput new-node degrees
    set prev-node new-node
  ]
  make-edge new-node first-node

  set time 0
  set num-infected 0
  set previous-num-infected 0

  repeat (num-nodes / 2) [create-preferential-net]


  set spreading-group n-of (num-nodes * spreading-group-percent / 100 )turtles
  ask spreading-group [set color orange set size 1]
  repeat spreadingGroupRepet [create-spreading-group]

  repeat (num-nodes / 2 - 4) [create-preferential-net]
display
end

to create-preferential-net
    no-display
    make-node  ;; add one new node

    ;; it's going to have m edges
    repeat m [
      let partner find-partner new-node      ;; find a partner for the new node
      ask partner [set color gray + 2]    ;; set color of partner to gray
      make-edge new-node partner     ;; connect it to the partner we picked before
    ]
    if layout? [ do-layout ]
    if plot? [ do-plotting ]
end


to create-spreading-group
  ask spreading-group
    [let first-node [who] of one-of spreading-group
      let second-node [who] of one-of spreading-group
      if (first-node != second-node)
        [if not is-link? link first-node second-node [
          ask turtle first-node [
            set size 2
            create-link-with turtle second-node[
              set color orange
              set thickness 0.5]
          ]
        ]
        ]
    ]
  repeat 5 [layout-spring (spreading-group) (links with [color = red]) 5 0.5 0.5]
end





;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Runtime Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

; reset diffusion simulation

to reinfect-once
  clear-plot
  reset-ticks
  set num-infected num-infected-init
  set time 0
  set previous-num-infected 0
  ask turtles [set color grey
    set infected? false
    set size 1]

  if (reinfect-type = "random")
  [ask n-of num-infected-init turtles
    [set color red
      set size 2
      set infected? true
    ]
  ]

  if (reinfect-type = "group")
  [ask n-of num-infected-init spreading-group
    [set color red
      set size 2
      set infected? true
    ]
  ]

  if (reinfect-type = "eigenval-centrality")
  [ask max-n-of num-infected-init turtles [nw:eigenvector-centrality]
    [set color red
      set size 2
      set infected? true
    ]
  ]

  if (reinfect-type = "PageRank-Centrality")
    [ask max-n-of num-infected-init turtles [ nw:page-rank]
      [set color red
        set size 2
        set infected? true
      ]
    ]



end

;; toggle infection tree mode
;; when tree-mode is on, only links responsible for contagion and infected nodes
;; are displayed. tree-mode also affects layout
to toggle-tree
  ifelse tree-mode?
  [
    ask turtles with [not infected?] [show-turtle]
    ask links with [color != red ] [show-link]
    set tree-mode? false
  ]
  [
    ask turtles with [not infected?] [hide-turtle]
    ask links with [color != red] [hide-link]
    set tree-mode? true
  ]
end

to spread
  ;; infection can't take place while in infection tree mode
  ;; or if every agent has already been infected
  if all? turtles [infected?]
    [stop]

  ask turtles with [ infected? = true ]
  [let mysize [size] of turtle who
    let prob 0
    ;; infect neighbors
    ask link-neighbors with [infected? = false]
    [ifelse (Retention-loss = true)
      [set prob p * mysize]
      [set prob p]
    if ( random-float 1 <= prob)  ;; infect with probability p or with prob p * size
      [ set infected? true
        show-turtle
        set color red
      ;; color the link with the node doing the infection
        ask link-with myself [show-link]
        ;; increment the total number of infected agents
        set num-infected num-infected + 1
      ]
    ]
  ]

    ;; resize node so that the area is proportional to the current number of infections


  let tmp count turtles with [infected? = true]
  ifelse (tmp = previous-num-infected)
  [stop]
  [set  previous-num-infected tmp]

  forgetness
  do-plotting

  tick
end

;; used for creating a new node
to make-node
  create-turtles 1  ;; don't know what this is - lada
  [
    set color gray + 2
    set size 0.5
    set infected? false
    set new-node self ;; set the new-node global
  ]
end



;; Find a node to attach to
;; the degree of a node
;; 0 < gamma < 1 means gamma*100 percent of the
;; time attach randomly, rest of the time attach
;; preferentially

to-report find-partner [node1]
  ;; set a local variable called ispref that
  ;; determines if this link is going to be
  ;; preferential of not
  let ispref (random-float 1 >= gamma)

  ;; initialize partner to be the node itself
  ;; this will have to be changed
  let partner node1

  ;; if preferential attachment then choose
  ;; from our degrees array
  ;; otherwise chose one of the turtles at random
  ifelse ispref
  [
    set partner one-of degrees
   ]
   [
     set partner one-of turtles
     ]

   ;; but need to check that partner chosen isn't
   ;; the node itself and also isn't a node that
   ;; our node is already connected to
   ;; if this is the case, it will try another
   ;; partner and try again
  let checkit true
  while [checkit] [
    ask partner [
      ifelse ((link-neighbor? node1) or (partner = node1))
        [
          ifelse ispref
          [
            set partner one-of degrees
           ]
           [
             set partner one-of turtles
           ]
            set checkit true
         ]
         [
           set checkit false
         ]
       ]
    ]
  report partner
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Edge Operations ;;;
;;;;;;;;;;;;;;;;;;;;;;;

;; connects the two turtles
to make-edge [node1 node2]
  ask node1 [
    ifelse (node1 = node2)
    [
      show "error: self-loop attempted"
    ]
    [
      create-link-with node2 [ set color grey + 2 ]
     ;; position the new node near its partner
      setxy ([xcor] of node2) ([ycor] of node2)
      rt random 360
      fd 8
      set degrees lput node1 degrees
     set degrees lput node2 degrees
     ]
  ]
end


;;;;;;;;;;;;;;;;
;;; Plotting ;;;
;;;;;;;;;;;;;;;;

to do-plotting
     ;; plot the number of infected individuals at each step
     set-current-plot "Number infected"
     set-current-plot-pen "inf"

     plotxy ticks num-infected
end

;;;;;;;;;;;;;;
;;; Layout ;;;
;;;;;;;;;;;;;;
;; resize-turtles, change back and forth from size based on degree to a size of 1

;; spring layout of infection tree while in tree mode
;; otherwise, layout all nodes and links
to do-layout
  ifelse tree-mode?
    [repeat 5 [layout-spring (spreading-group) (links) 5 0.5 0.5]]
    [repeat 5 [layout-spring turtles links 0.2 4 3]]
  display
end

to forgetness
  ask turtles
    [set size size / size-reduction
      if size < 0.1 [set infected? false]
    ]


end

; *** NetLogo 3.1.3 Model Copyright Notice ***
;
; Copyright 2005 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2005).  NetLogo Preferential Attachment model.
; http://ccl.northwestern.edu/netlogo/models/PreferentialAttachment.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2005 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/PreferentialAttachment
; for terms of use.
;
; *** End of NetLogo 3.1.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
340
10
730
421
45
45
4.18
1
10
1
1
1
0
0
0
1
-45
45
-45
45
1
1
1
ticks
30.0

BUTTON
6
25
72
58
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
225
141
326
174
spread
spread
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
119
141
219
174
spread once
spread
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
176
26
266
59
plot?
plot?
0
1
-1000

SWITCH
81
26
171
59
layout?
layout?
0
1
-1000

MONITOR
284
215
334
260
time
ticks
3
1
11

BUTTON
7
102
109
135
layout
do-layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
153
64
325
97
m
m
1
5
2
1
1
NIL
HORIZONTAL

SLIDER
8
176
152
209
num-nodes
num-nodes
5
10000
200
1
1
NIL
HORIZONTAL

PLOT
8
213
280
415
Number infected
time
n
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"inf" 1.0 0 -2674135 true "" ""

SLIDER
10
65
145
98
p
p
0
1
0.11
0.01
1
NIL
HORIZONTAL

SLIDER
155
176
300
209
gamma
gamma
0
1
0.5
0.01
1
NIL
HORIZONTAL

MONITOR
1074
19
1147
72
nodes
count turtles
3
1
13

BUTTON
8
140
106
173
reinfect one
reinfect-once
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
119
101
262
134
toggle infection tree
toggle-tree
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1735
27
1858
60
crt SpreadGroup
create-spreading-group
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
772
73
944
106
num-infected-init
num-infected-init
0
50
5
1
1
NIL
HORIZONTAL

CHOOSER
12
430
193
475
reinfect-type
reinfect-type
"random" "group" "eigenval-centrality" "PageRank-Centrality"
2

MONITOR
977
19
1065
72
Group Size
count spreading-group
17
1
13

MONITOR
276
447
368
500
net-infected
num-infected  - num-infected-init
17
1
13

SLIDER
776
121
948
154
spreadingGroupRepet
spreadingGroupRepet
0
10
2
1
1
NIL
HORIZONTAL

SWITCH
776
216
911
249
Retention-loss
Retention-loss
0
1
-1000

SLIDER
777
167
994
200
spreading-group-percent
spreading-group-percent
0
5
5
0.05
1
NIL
HORIZONTAL

SLIDER
946
218
1118
251
size-reduction
size-reduction
1
10
1.5
0.25
1
NIL
HORIZONTAL

TEXTBOX
778
263
1120
471
1. Chose number of nodes - num-nodes, and the level of preferential attachment (gamma).\n\n2. Press setup, untill network with Spreading Grop is formed.\n\n3. Select a seeding method by the \"reinfect-type\" chooser.\n\n4. Press \"spread\" to spread a message.\n
13
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model studies the topic of "Spreading Group".
These are synchronized groups that post a message on Twitter or Facebook together, in order to increase the message`s spread.
We believe such Spreading Groups are mainly constructed of bots; - computerized programs that mimic humans.
The model show that such a strategy of using a spreading group of size k is more effective than reaching a similarly large number of hubs.
## THE BEHAVIOR
1.	Nodes have retention loss; which is modified by the slider "size-reduction".
2.	The size of the node reflects how much time it will still be infectious.
3.	The Spreading Group is plot in an orange line within the network.
Constructing the speeding groups
1.	The density of the Spreading Group is modified by the slider "spreadingGroupRepet" which determines how many additional links would be within the spreading group.
2.	It is also modified by the slider "spreading-group-percent", which determines
 what is the rate of nodes in the spreading group within the network.

## HOW IT WORKS
The model starts with two nodes connected by an edge.
At each step, a new node is added.  After n/2 nodes were added, a step of formation of the spreading group is performed, followed by another n/2 steps of preferential attachment.

## HOW TO USE IT

1.	Create a network by pressing <SETUP> after setting the network parameters.  The NUM-NODES slider controls the size of the network. The GAMMA parameter determines whether the attachment is preferential (gamma = 0 means entirely preferential, gamma = 1 means entirely random). Choose num-nodes and gamma and press SETUP.

2.	Also set the <spreading-group-repeat> and <spreading-group-percent> to determine the size of the spreading group.

3.	Select the <reinfect-type> which can be:
a.	"random" – select k nodes randomely
b.	"group" – select k nodes from the spreading group
c.	"eigenval-centrality"- select k nodes with the highest Eigenvector centrality measure.
d.	"PageRank-Centrality" - select k nodes with the highest PageRank centrality measure.

4.	Press the spread to inspect the spreading.Now to allow the disease to spread, you can advance on time step at a time (each infected node will infect each of its neighbors with probability p) with the "spread once" button. To let the disease run its full course, you can click the "spread" button.

## THINGS TO NOTICE
1.	Chose the spread with and without the retention loss.
2.	Compare the spread by random k nodes, random k nodes from the spreading group, k nodes of the highest eigenvalues.

## RELATED MODELS
See other models in the Networks section of the Models Library, such as Giant Component.
See also Network Example, in the Code Examples section.

## CREDITS AND REFERENCES
This model is based on:
 Wilensky, U. (2005).  NetLogo Preferential Attachment model.
Modified by Lada Adamic 2007
Modified by Alon Sela 2016 in order to inspect the topic of spreading gorups.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   