globals [daVersion ; For displaying the version info from the CVS repository
         myEpsilon ; myEpsilon is simply a small floating point number to handle numerical
                   ; comparisons
         replicationsCompleted ; a counter to hold the number of replications completed of a given experiment
         episodeRunCounter ; a counter to hold the number of episodes completed
         ;producer0Color producer1Color
         versionID ; Holds the Subversion ID string.
         ;retainedEarnings0 ; holds retained earnings of firm 0 across replications
         ;retainedEarnings1 ; holds retained earnings of firm 1 across replications
         NumProducers ; The internal variable; NumberOfProducers is only  for the Interface tab
         

         ProducerWhos ; The who values of the producers; assumed to begin at 0 and go to NumProducers - 1
         RunID ; set once with date-and-time
         StringToPrint ; a global variable to be used as a string
         DaProbe ; variable used for Monte Carlo sensitivity studies
         ;;;;;; For Monte Carlo Sensitivity Analysis: ;;;;;;
         NumCustomers-Fixed ; The fixed value of NumCustomers; used for perturbing in sensitivity analysis
         NumCustomers-Used ; The internal variable; NumberOfCustomers is only  for the Interface tab
         Demand0-Fixed Demand0-Used   
         Demand1-Fixed Demand1-Used      
         RetainedEarningsMultiplier-Fixed RetainedEarningsMultiplier-Used
         BoltzmanFactor-Fixed BoltzmanFactor-Used
         AmbidexterityCostMultiplier-Fixed AmbidexterityCostMultiplier-Used
         Producer0Product0InitialProduction-Fixed Producer0Product0InitialProduction-Used
         Producer1Product0InitialProduction-Fixed Producer1Product0InitialProduction-Used
         ProbSuccessIncrementalInvestment-Fixed ProbSuccessIncrementalInvestment-Used
         ProbSuccessRadicalInvestment-Fixed ProbSuccessRadicalInvestment-Used
]

breed [producers producer]
breed [customers customer]

producers-own [; First product 0:
               supply0 ; the count of product 0 on hand and available for sale
               price0 ; the unit price of product 0
               value0 ; the unit value to the customer of product 0
               unitCost0 ; the cost of producing one product 0
               netSales0 ; sum of (price - unitCost) for sales made of product 0 during an episode
               countSales0 ; number of sales units for product 0 during the run
               countSuccessfulIncrementalProjects ; the a total count of incremental projects that were successful during the run
               product0production ; the amount of product 0 that a producer produces in 1 episode (period)
               ; Next product 1:
               supply1 ; the count of product 0 on hand and available for sale
               price1 ; the unit price of product 1
               value1 ; the unit value to the customer of product 1
               unitCost1 ; the cost of producing one product 1
               netSales1 ; sum of (price - unitCost) for sales made of product 1 during an episode
               product1production ; the amount of product 1 that a producer produces in 1 episode (period)
               LocusOfIncrementalImprovement ; where the improvement comes, in value or cost or both
               incrementalProjMaturation ; a list of maturation times (ticks) for incremental projects
               radicalProjMaturation ; a list of maturation times (ticks) for radical projects
               
               strategy ; the strategy being followed by the firm, from StrategyFirmX on the Interface
               retainedEarnings ; netsales minus investment costs
               
               countOfIncrementalInvestments ; the number of incremental investments the producer firm has made
               countOfRadicalInvestments ; the number of radical investments the producer firm has made
               countOfSuccessfulRadicalInvestments ; the number of successful radical investments the producer firm has made
               
               totalSales0 totalSales1 ; accumulation of per period netSales0 and netSales1
               endIncrementalMode ; For a producer that has a sequential strategy the ticks value at which incremental mode ends, or -1
               endRadicalMode ; For a producer that has a sequential strategy the ticks value at which radical exploration mode ends, or -1
               ]
customers-own [FocalSupplier ; Should be on the list of ProducerWhos
               OtherSupplier ; The idea is that at any given time a customer has a primary and a secondard supply.
               ; The OtherSupplier is randomly at the beginning of each epoch (or episode)
               ; First, product 0 
               Demand0 ; the count of product 0 units demanded by a given customer per episode (period)
               PurchasedProduct0Producer0 PurchasedProduct0Producer1 ; the number of units purchased during
                     ; an epoch from producer 0 (focal) /1 (other)
               Value0Producer0 Value0Producer1 ; the accumulation of the value of the units purchased during
                     ; an epoch from producer 0 (focal) /1 (other)
               ; Next, product 1
               Demand1 ; the count of product 0 units demanded by a given customer per episode (period)
               PurchasedProduct1Producer0 PurchasedProduct1Producer1 ; the number of units purchased during
                     ; an epoch from producer 0 (focal) /1 (other)
               Value1Producer0 Value1Producer1 ; the accumulation of the value of the units purchased during
                     ; an epoch from producer 0 (focal) /1 (other)
               EpochLength ; The number of episodes tried for a focal supplier choice, before reconsidering
              ]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SetupAndGo ;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to SetupAndGo
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks ; Clear everything, reset variables, reset plots, etc.
; Determine the random seed to use and print out the first random-float:
if (RecordMovie?)
  [movie-start "out.mov"
   movie-grab-interface
  ]
ifelse (RandomNumberSeed = "System Clock")
   [random-seed new-seed]
   [random-seed RandomNumberSeed]
;print (word "The first (0,1) random float is " random-float 1)   
set daVersion "$Id: AmbidexterityStrategyExplorer.nlogo 3035 2012-07-16 16:11:17Z sok $"
set myEpsilon 0.000001
SetupARun ; I'm calling this here to get parameter values for creating the file header.
  ; Notice that it is called again below, in the while [ReplicationsCompleted < NumberOfReplications] loop.
;;;;;;;;;;;;;;;;; If we are logging, ... ;;;;;;;;;;;;;
if (logging?) [
 set RunID date-and-time
 CreateRunsOutFileHeader
  if (file-exists? "AmbidexterityCustomerLogFile.txt")
     [file-close
      file-delete "AmbidexterityCustomerLogFile.txt"]
  if (file-exists? "AmbidexterityProducerLogFile.txt")
     [file-close
      file-delete "AmbidexterityProducerLogFile.txt"]
 CreateProducerLogFile
 CreateCustomerLogFile
     ]    
  ;;;; Now do a run of NumberOfReplications replications: ;;;;;
  set ReplicationsCompleted 0  
  while [ReplicationsCompleted < NumberOfReplications]
   [SetupARun
    if (RecordMovie?)
    [movie-grab-interface]
    GoNEpisodes
    set replicationsCompleted (replicationsCompleted + 1)
    if (Logging?)[
     RecordRunOutput
     ]
   ]
   if (RecordMovie?)
   [movie-close]
end ; of SetupAndGo

to Setup
  ; Copied from the beginning of SetupAndGo
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks ; Clear everything, reset variables, reset plots, etc.
; Determine the random seed to use and print out the first random-float:
ifelse (RandomNumberSeed = "System Clock")
   [random-seed new-seed]
   [random-seed RandomNumberSeed]
;print (word "The first (0,1) random float is " random-float 1)   
set daVersion "$Id: AmbidexterityStrategyExplorer.nlogo 3035 2012-07-16 16:11:17Z sok $"
set myEpsilon 0.000001
SetupARun ; I'm calling this here to get parameter values for creating the file header.
  ; Notice that it is called again below, in the while [ReplicationsCompleted < NumberOfReplications] loop.
;;;;;;;;;;;;;;;;; If we are logging, ... ;;;;;;;;;;;;;
if (logging?) [
 set RunID date-and-time
 CreateRunsOutFileHeader
  if (file-exists? "AmbidexterityCustomerLogFile.txt")
     [file-close
      file-delete "AmbidexterityCustomerLogFile.txt"]
  if (file-exists? "AmbidexterityProducerLogFile.txt")
     [file-close
      file-delete "AmbidexterityProducerLogFile.txt"]
 ;CreateProducerLogFile
 ;CreateCustomerLogFile
     ]    
end ; of Setup

to GoNReplications
  ; Copied from SetupAndGo
    if (logging?) [
      set RunID date-and-time
      ;CreateRunsOutFileHeader
      CreateProducerLogFile
      CreateCustomerLogFile
     ]    
  set ReplicationsCompleted 0  
  while [ReplicationsCompleted < NumberOfReplications]
   [SetupARun
    GoNEpisodes
    set replicationsCompleted (replicationsCompleted + 1)
    if (Logging?)[
     RecordRunOutput
     ]
   ]  
end

to GoNReplicationsMonteCarlo
  ; Copied from SetupAndGo
    if (logging?) [
      set RunID date-and-time
      ;CreateRunsOutFileHeader
      CreateProducerLogFile
      CreateCustomerLogFile
     ]    
  set ReplicationsCompleted 0  
  while [ReplicationsCompleted < NumberOfReplications]
   [MonteCarlo
    SetupARun
    GoNEpisodes
    set replicationsCompleted (replicationsCompleted + 1)
    if (Logging?)[
     RecordRunOutput
     ]
   ]  
end

to MonteCarlo
  set DaProbe (random-float 1) * 20
  set NumberOfCustomers round (190 + DaProbe)
end

to GoFactorial
    if (logging?) [
      set RunID date-and-time
      CreateProducerLogFile
      CreateCustomerLogFile
     ]    
foreach (list 200 220 230) [
  let DaFirst ?
foreach (list 6500 7000 7500) [
  let DaSecond ?
  set ReplicationsCompleted 0  
  while [ReplicationsCompleted < NumberOfReplications]
   [SetupARun
    set NumCustomers-Used DaFirst
    set RadicalInvestmentCost DaSecond
    GoNEpisodes
    set replicationsCompleted (replicationsCompleted + 1)
    if (Logging?)[
     RecordRunOutput
     ]
   ]    
] ; end of foreach 2
] ; each of foreach 1
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SetupARun ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to SetupARun
reset-ticks
set daVersion "$Id: AmbidexterityStrategyExplorer.nlogo 3035 2012-07-16 16:11:17Z sok $"
;set producer0Color red
;set producer1Color  blue
; We can't use clear-all (ca) and clear everything, reset variables, reset plots, etc.
; because we want to conduct multiple runs and we want Setup to set things up for a 
; singe run. So we
clear-all-plots
clear-output
clear-turtles
; We could use the built-in tick function and ticks reporter:
set episodeRunCounter 0 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SetGlobalParameters
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Create and initialize the producers
CreateAndInitializeProducers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;; Now create and initialize the customers
CreateAndInitializeCustomers
end ; of SetupARun
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GoNEpisodes ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to GoNEpisodes
;      if (Perturbing?) [
;        PerturbParameters
;      ]
while [episodeRunCounter < episodesPerRun]
[if (RecordMovie?)
    [movie-grab-interface]
  Go
 set episodeRunCounter (episodeRunCounter + 1) ; since we've completed an episode
 ]
;print (word "Finished. episodeRunCounter = " episodeRunCounter)
if (RecordMovie?)
    [movie-grab-interface]
end

to Go
tick
ask producers [set supply0 product0production
               set supply1 product1production
  ] ; At the start of each episode, producers update their supply on hand
ask customers
  [let firstSupplier -100 ; local variables declared
   let secondSupplier -101
   set demand0 Demand0-Used ; InitialDemand0 ; reset demand for the new episode
   set demand1 InitialDemand1 ;
   ifelse (random-float 1 < epsilon)
     [set firstSupplier otherSupplier
      set secondSupplier focalSupplier]
     [set firstSupplier focalSupplier
      set secondSupplier otherSupplier]
   ;print (word "In Go, firstSupplier=" firstSupplier)
   ; Declare presentSupplier
   let presentSupplier FocalSupplier ; or anything. 
     ; This is just to declare the variable.

 ; Attempts to fill its demand for product 0 from its firstSupplier. 
 ; and then (if the supplier is exhausted) from its secondSupplier.
 foreach (list firstSupplier secondSupplier)
  [set presentSupplier ?    
   while [([supply0] of producer presentSupplier > 0) and demand0 > 0]
   ;if ([supply0] of producer presentSupplier > 0)
   [; increment purchase
   ifelse (presentSupplier = FocalSupplier)
     [set purchasedProduct0Producer0 (purchasedProduct0Producer0 + 1)
      set value0Producer0 (value0Producer0 + [value0] of producer FocalSupplier)]
     [set purchasedProduct0Producer1 (purchasedProduct0Producer1 + 1)
      set value0Producer1 (value0Producer1 + [value0] of producer OtherSupplier)]    
   ; decrement supply
   ask producer presentSupplier [set supply0 (supply0 - 1)]
   ; decrement demand
   set demand0 (demand0 - 1)
   ; increment netSales
   ask producer presentSupplier [set netSales0 (netSales0 + (price0 - unitCost0))
     set countSales0 (countSales0 + 1)]
   ] ; end of while ....  
   ] ; end of foreach
 ;;;;;;;;;;;;;;;;;;;;;;;; Demand for Product 1 ;;;;;;;;;;;;;;;;;;;;;;;;;;
 ; Attempts to fill its demand for product 1 from its {\tt firstSupplier}  
 ; and then (if the supplier is exhausted) from its {\tt secondSupplier} .
 foreach (list firstSupplier secondSupplier)
  [set presentSupplier ? 
   while [([supply1] of producer presentSupplier > 0) and demand1 > 0]
   [; increment purchase
   ifelse (presentSupplier = 0)
     [set purchasedProduct1Producer0 (purchasedProduct1Producer0 + 1)
      set value1Producer0 (value1Producer0 + [value1] of producer 0)]
     [set purchasedProduct1Producer1 (purchasedProduct1Producer1 + 1)
      set value1Producer1 (value1Producer1 + [value1] of producer 1)]
   ; decrement supply
   ask producer presentSupplier [set supply1 (supply1 - 1)]
   ; decrement demand
   set demand1 (demand1 - 1)
   ; increment netSales
   let unitProfit ([price1] of producer presentSupplier - [unitCost1] of producer presentSupplier)
   ask producer presentSupplier [set netSales1 (netSales1 + (price1 - unitCost1))]
   ] ; end of while ....
   ] ; end of foreach [firstSupplier secondSupplier]
  ] ; end of ask customers
  
  PlotFocalSuppliers
  PlotRetainedEarnings
  ; PlotProduct0Values
  ask customers [CustomerPostPareEpisode]
  ask producers [ProducerPostPareEpisode]
end ; of Go

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  CustomerPostPareEpisode   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to CustomerPostPareEpisode
 ; Reset demand
 set demand0 Demand0-Used ; InitialDemand0
 set demand1 InitialDemand1
 ;print (word "demand0=" demand0 " demand1=" demand1")
 ; Have we completed an epoch for this turtle? 
 ; If so, reconsider focalSupplier and reset accummulators to 0. 
 ; If not, simply continue.
 if (ticks mod epochLength = 0)
  [;print "Starting new epoch in CustomerPostPareEpisode"
    let daProb0 ProbabilitySupplierFocal(value0Producer0)(purchasedProduct0Producer0)(value0Producer1)(purchasedProduct0Producer1) 
   ; value0Producer0 is the value received for product 0 from the focal supplier, called 0
   ;print (word "daProb0=" daProb0)
   if (daProb0 < 0)
    [print "Product is exhausted. Stop the simulation."
     ;stop
     ]
   ifelse (random-float 1 < daProb0)
   [; (Keep FocalSupplier, draw a new OtherSupplier)
    set OtherSupplier one-of remove-item FocalSupplier ProducerWhos
   ]
   [set FocalSupplier OtherSupplier
    set color [color] of producer FocalSupplier
    set OtherSupplier one-of remove-item FocalSupplier ProducerWhos
    ] 
   set value0Producer0 0
   set purchasedProduct0Producer0 0
   set value0Producer1 0
   set purchasedProduct0Producer1 0
   set value1Producer0 0
   set purchasedProduct1Producer0 0
   set value1Producer1 0
   set purchasedProduct1Producer1 0
  ] ; end of if (ticks mod epochLength = 0)
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  ProducerPostPareEpisode   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to ProducerPostPareEpisode
;if (is-producer? self) [
 set retainedEarnings (retainedEarnings + netSales0)
 set retainedEarnings (retainedEarnings + netSales1)
 set totalSales0 (totalSales0 + netSales0)
 set totalSales1 (totalSales1 + netSales1)
 set netSales0 0
 set netSales1 0
 if (strategy = "Max Incremental Investment" and (RetainedEarningsMultiplier-Used * IncrementalInvestmentCost < retainedEarnings) and length incrementalProjMaturation < MaxSimultaneousProjects)
  [set incrementalProjMaturation lput (ticks + MaturationEpisodesIncrementalInvestment) incrementalProjMaturation
   set retainedEarnings (retainedEarnings - IncrementalInvestmentCost)
   set countOfIncrementalInvestments (countOfIncrementalInvestments + 1)
  ]
 if (strategy = "Max Incremental Investment Limited" and 
   (RetainedEarningsMultiplier-Used * IncrementalInvestmentCost < retainedEarnings) and 
   length incrementalProjMaturation < MaxSimultaneousProjects
     and countOfIncrementalInvestments < IncrementalLimit)
  [set incrementalProjMaturation lput (ticks + MaturationEpisodesIncrementalInvestment) 
         incrementalProjMaturation
   set retainedEarnings (retainedEarnings - IncrementalInvestmentCost)
   set countOfIncrementalInvestments (countOfIncrementalInvestments + 1)
  ]
  ; "Competitive Incremental Investment"
 let p1 ([value0] of producer 0 / [price0] of producer 0)
 let p2 ([value0] of producer 1 / [price0] of producer 1)
 let competitiveInvest " "
 ifelse ([who] of self = 0)
  [ifelse (p1 > p2)
   [set competitiveInvest false]
   [set competitiveInvest true]]
  [ifelse (p1 > p2)
   [set competitiveInvest true]
   [set competitiveInvest false]
  ]
 if (strategy = "Competitive Incremental Investment" and (RetainedEarningsMultiplier-Used * IncrementalInvestmentCost < retainedEarnings) and length incrementalProjMaturation < MaxSimultaneousProjects
     and competitiveInvest)
  [set incrementalProjMaturation lput (ticks + MaturationEpisodesIncrementalInvestment) incrementalProjMaturation
   set retainedEarnings (retainedEarnings - IncrementalInvestmentCost)
   set countOfIncrementalInvestments (countOfIncrementalInvestments + 1)
  ]  
 if (strategy = "Max Radical Investment" and 
     (RetainedEarningsMultiplier-Used * RadicalInvestmentCost < retainedEarnings) and 
      countOfSuccessfulRadicalInvestments < 1)
  [set radicalProjMaturation lput (ticks + MaturationEpisodesRadicalInvestment) radicalProjMaturation
   set retainedEarnings (retainedEarnings - RadicalInvestmentCost)
   set countOfRadicalInvestments (countOfRadicalInvestments + 1)
  ] 
  
  
  if (strategy = "Max Radical Investment Limited" and 
     (RetainedEarningsMultiplier-Used * RadicalInvestmentCost < retainedEarnings) and 
      countOfSuccessfulRadicalInvestments < 1 and 
      countOfRadicalInvestments <= RadicalLimit)
  [set radicalProjMaturation lput (ticks + MaturationEpisodesRadicalInvestment) 
      radicalProjMaturation
   set retainedEarnings (retainedEarnings - RadicalInvestmentCost)
   set countOfRadicalInvestments (countOfRadicalInvestments + 1)
  ] 
 if (strategy = "Max Incremental Limited & Radical Investment Limited" and
    ((RadicalInvestmentCost) * AmbidexterityCostMultiplier-Used * 
      RetainedEarningsMultiplier-Used < retainedEarnings) 
    and countOfSuccessfulRadicalInvestments < 1  and 
    countOfRadicalInvestments <= RadicalLimit)
  [set radicalProjMaturation lput (ticks + MaturationEpisodesRadicalInvestment) 
       radicalProjMaturation
   set retainedEarnings (retainedEarnings - 
     (RadicalInvestmentCost * AmbidexterityCostMultiplier-Used))
   set countOfRadicalInvestments (countOfRadicalInvestments + 1)
  ] 
 if (strategy = "Max Incremental Limited & Radical Investment Limited" and 
   (RetainedEarningsMultiplier-Used * (IncrementalInvestmentCost) * 
     AmbidexterityCostMultiplier-Used < retainedEarnings) 
    and countOfIncrementalInvestments < IncrementalLimit) 
  [set incrementalProjMaturation lput (ticks + MaturationEpisodesIncrementalInvestment) 
    incrementalProjMaturation
   set retainedEarnings (retainedEarnings - (IncrementalInvestmentCost * 
       AmbidexterityCostMultiplier-Used))
   set countOfIncrementalInvestments (countOfIncrementalInvestments + 1)
  ] 
  
  if (strategy = "Sequential Ambidexterity"  and 
    ticks <= endIncrementalMode ; Behave as Max Incremental Investment Limited
     and (RetainedEarningsMultiplier-Used * IncrementalInvestmentCost < retainedEarnings) 
     and length incrementalProjMaturation < MaxSimultaneousProjects
     and countOfIncrementalInvestments < IncrementalLimit)
  [set incrementalProjMaturation lput (ticks + MaturationEpisodesIncrementalInvestment) 
       incrementalProjMaturation
   set retainedEarnings (retainedEarnings - IncrementalInvestmentCost)
   set countOfIncrementalInvestments (countOfIncrementalInvestments + 1)
  ]
  if (strategy = "Sequential Ambidexterity"  and 
    ticks <= endRadicalMode  ; Behave as Max Radical Investment Limited
     and (RetainedEarningsMultiplier-Used * RadicalInvestmentCost < retainedEarnings) and 
      countOfSuccessfulRadicalInvestments < 1 and countOfRadicalInvestments <= RadicalLimit)
  [set radicalProjMaturation lput (ticks + MaturationEpisodesRadicalInvestment) 
       radicalProjMaturation
   set retainedEarnings (retainedEarnings - RadicalInvestmentCost)
   set countOfRadicalInvestments (countOfRadicalInvestments + 1)
  ]  
  
  ; Now postpare any boundary changes:
  if (endIncrementalMode = ticks)
    [set endRadicalMode (ticks + SequentialRadicalEpochLength)
     set endIncrementalMode -1]
  if (endRadicalMode = ticks)
    [set endIncrementalMode (ticks + SequentialIncrementalEpochLength)
     set endRadicalMode -1]
     
  ; Process any matured incremental investments:
  if (not empty? incrementalProjMaturation and ticks = first incrementalProjMaturation)
  [set incrementalProjMaturation but-first incrementalProjMaturation
   if (random-float 1 <= ProbSuccessIncrementalInvestment-Used)
    [set countSuccessfulIncrementalProjects (countSuccessfulIncrementalProjects + 1)
      if (LocusOfIncrementalImprovement = "Value")
      [set value0 (value0 + IncrementalProjectValueIncrement)]
     if (LocusOfIncrementalImprovement = "Cost")
      [;set unitCost0 (unitCost0 * (1 - (IncrementalProjectCostIncrement / 100.0)))
        set unitCost0 (unitCost0 - IncrementalProjectCostIncrement)
        ]
     if (LocusOfIncrementalImprovement = "Cost and Value")
      [set unitCost0 (unitCost0 * (1 - (IncrementalProjectCostIncrement / 100.0)))
       set value0 (value0 + IncrementalProjectValueIncrement)]
     if (LocusOfIncrementalImprovement = "Cost and Price")
      [set unitCost0 (unitCost0 * (1 - (IncrementalProjectCostIncrement / 100.0)))
       set price0 (price0 * (1 - (IncrementalProjectCostIncrement / 150.0)))]
    ]
    ] ; end of if (not empty? incrementalProjMaturation ...
    
  if (not empty? radicalProjMaturation and ticks = first radicalProjMaturation)
  [set radicalProjMaturation but-first radicalProjMaturation
   if (random-float 1 <= ProbSuccessRadicalInvestment-Used)
    [set countOfSuccessfulRadicalInvestments (countOfSuccessfulRadicalInvestments + 1)
    set product1production RadicalProductionLimit]
    ]    
end ; end of to ProducerPostPareEpisode

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  ProbabilitySupplierFocal  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to-report ProbabilitySupplierFocal [valueP0 purchasedP0 valueP1 purchasedP1]
  ; Returns the probability of going with the focal supplier, 0
; 1 + to prevent division by 0
let daRatioS0 (valueP0 / (1 + (purchasedP0 * [price0] of producer 0)))
let daRatioS1 (valueP1 / (1 + (purchasedP1 * [price0] of producer 0)))
if (daRatioS0 = 0 and daRatioS1 = 0)
  [report -1]

; One option is to make switching an absolute thing.
; Go with the best value per buck supplier of product 0:
let p0 ([value0] of producer FocalSupplier / [price0] of producer FocalSupplier)
let p1 ([value0] of producer OtherSupplier / [price0] of producer OtherSupplier)
if (SwitchingPolicy = "Absolute on value0 / price0")
 [ifelse (p0 > p1)
  [report 1]
  [report 0]
 ]
; Here, below, is the option used in the default setting.
; daProb is the probability of focusing on supplier 0.
; From above, p0 is the value/price ratio for producer 0
; of product 0, p1 is the value/price ratio for producer 1
; of product 0. The code, above, to create these values was:
; let p0 ([value0] of producer 0 / [price0] of producer 0)
; let p1 ([value0] of producer 1 / [price0] of producer 1)
if (SwitchingPolicy = "Boltzman on value / price")
  [let daProb (1 + exp(-1 * (p0 - p1) * 10 / BoltzmanFactor-Used)) ^ -1
   report daProb]

if (SwitchingPolicy = "Boltzman on purchased value / price")
  [let daRawRatio (daRatioS0 / (daRatioS0 + daRatioS1))
   let daProb (1 + exp(-1 * (daRawRatio - 0.5) * BoltzmanFactor-Used)) ^ -1
   report daProb]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  PlotFocalSuppliers  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to PlotFocalSuppliers
  set-current-plot "Focal Suppliers"
  foreach ProducerWhos [
   let DaGuy (min (list ? 6) )
   set-current-plot-pen (word "producer" DaGuy)
   plot-pen-down
   plot count customers with [focalsupplier = DaGuy]
  ]
end ; of to PlotFocalSuppliers

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;  PlotRetainedEarnings  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to PlotRetainedEarnings
  set-current-plot "Retained Earnings"
  foreach ProducerWhos [
   let DaGuy (min (list ? 6) )
   set-current-plot-pen (word "producer" DaGuy)
   plot-pen-down
   plot [retainedEarnings] of producer  DaGuy
  ]

end ; of to PlotRetainedEarnings

to PlotProduct0Values
  set-current-plot "Producer Product 0 Values"
  set-current-plot-pen "producer0"
  plot-pen-down
  plot [value0] of producer 0
  set-current-plot-pen "producer1"
  plot-pen-down
  plot [value0] of producer 1
end ; of to PlotProduct0Values

to SetInterfaceCaseValues ; SetDefaultValues
  ;;;;;;;;;; Run parameters ;;;;;;;;;;;;;;;;;;;;
  set NumberOfReplications 100 ; The number of times the
  ; basic program is executed per fixed setting of the 
  ; parameters. The default number for serious experiments is
  ; 100.
  set RandomNumberSeed "System Clock" ; Use this value to seed
  ; the (pseudo)random number generator for the run.
  set Logging? false ; Turn logging of dat                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 