extensions [matrix]
globals [input-data agents data-matrix data-row-list
  exercised-powers saliences positions influences
  positions-normalized
  weighted-median weighted-median-position 
  apa-table
  agent-max parameter-list
  p1 p2 ; mnemononic for parameter 1, parameter 2; dummies
  ]

;; This procedure is being depricated so that a single Netlogo
;; file can be uploaded to the Modeling Commons.
;to load-input-data
;  ifelse ( file-exists? "BuenodeMesquita1984.txt" )
;  [
;  set input-data []
;  ;; This opens the file, so we can use it.
;  file-open "BuenodeMesquita1984.txt"
;  let file-header file-read-line
;  show file-header
;  while [ not file-at-end? ]
;  [  
;    set input-data sentence input-data (list (list file-read file-read file-read file-read))
;  ]
;  ;show input-data
;  file-close
;  make-data-structures
;  ]
;  [user-message "There is no BuenodeMesquita1984.txt file in current directory!" ]
;end

to load-default-data
   let default-data [["Agent" "Position" "Salience" "Influence"] ["UMC" 0 0.8 1.1] ["TEC" 0 2.5 0.6] ["MCR" 2.1 2.5 0.9] ["SOV" 3 10.3 0.6] ["PM" 4.7 6.8 9] ["BAZ" 5.1 0.8 5.6] ["REV" 5.1 8.5 12.4] ["JC" 5.1 10.3 11.3] ["PRE" 6.4 10.3 10.7] ["UP" 7.3 2.5 4.5] ["LCR" 7.3 3.4 4.5] ["KUR" 8.6 4.3 2.3] ["COM" 9.8 8.5 11.8] ["SC" 11.1 6 4.5] ["CG" 11.1 4.3 9] ["MON" 12.4 9.4 0.1] ["TMC" 12.4 9.4 3.4] ["QUM" 12.4 9.4 4.5]]
   set input-data default-data
   make-data-structures
end

;; This procedure does the same thing as the above one, except it lets the user choose
;; the file to load from.  Note that we need to check that it isn't false.  This because
;; it will return false if the user cancels the file dialog.  There is currently only
;; one file to load from, but you can create your own using the function save-patch-data
;; near the bottom which saves all the current patches into a file.
to load-own-input-data
  let file user-file

  if ( file != false )
  [
    set input-data []
    file-open file
    let file-header file-read-line
    show file-header
    while [ not file-at-end? ]
      [ set input-data sentence input-data (list (list file-read file-read file-read file-read)) ]

    user-message "File loading complete!"
    file-close
    make-data-structures
  ]
end

to show-input-data
  ifelse ( is-list? input-data )
    [ clear-output
      foreach input-data [ output-print ? ]]
    [ user-message "You need to load in patch data first!" ]
end

to show-current-data
  ifelse ( is-list? agents )
    [ clear-output
      output-print (word "Agent Position Salience Influence")
      output-print "-------------------------------------"
      foreach n-values length agents [?] [ output-print (word item ? agents " " item ? positions " " item ? saliences " " item ? influences)]]
    [ user-message "You need to load in data first!" ]
end

to model-report
  ifelse ( is-list? input-data )
  [ clear-output
    foreach input-data [ output-print ? ]
  ;; Now do the report on the selected model.
  if model = 1 [
    user-message "Valid model! Will run report."
    model1
  ]
  if model = 2 [
    user-message "Valid model! Will run report."
    model2
  ]
  ]
    [ user-message "You need to load in input data first!" ]
end



to get-agent-list
  ifelse ( is-list? input-data )
  [ clear-output
    set agents []
    foreach input-data [ set agents lput item 0 ? agents ]
  ;; Now do the report on the selected model.
  set agents but-first agents
  ;show agents
  ]
  [ user-message "You need to load in input data first!" ]
end

to make-row-list
  ;; Of the input-data
  ifelse ( is-list? input-data )
  [ clear-output
    set data-row-list []
    foreach input-data [ set data-row-list lput but-first ? data-row-list ]
  set data-row-list but-first data-row-list
  ;output-show data-row-list
  ]
  [ user-message "You need to load in input data first!" ]
end  

to make-data-array
  make-row-list
  set data-matrix matrix:from-row-list data-row-list
end

to make-data-structures
  get-agent-list
  make-data-array
  ;; The following all report lists, not matrices.
  ;; Of course the lists can be easily converted to matrices as needed.
  set positions matrix:get-column data-matrix 0
  set saliences matrix:get-column data-matrix 1
  set influences matrix:get-column data-matrix 2
  ;; Now normalize the positions
;  set positions-normalized []
;  let damax max positions
;  let damin min positions
;  foreach positions [
;   set positions-normalized lput ((? - damin) / (damax - damin)) positions-normalized
;  ]
  set positions-normalized normalize-list (positions)
  set agent-max  length agents - 1
end

to-report normalize-list [to-normalize]
  let normalized []
  let damax max to-normalize
  let damin min to-normalize
  foreach to-normalize [
   set normalized lput ((? - damin) / (damax - damin)) normalized
  ]
  report normalized
end

to model1
  clear-output
  output-print "Results from model 1"
  make-exercised-powers
  make-weighted-median-position
  output-print (word "Weighted median value: " (round (100 * weighted-median) / 100))
  output-print (word "Weighted median position: " weighted-median-position)
end

to model2
  clear-output
  output-print "Results from model 2"
  let row-sums-list model2prediction (positions)
  ;let row-sums matrix:from-column-list (list agents row-sums-list)
  output-print "The group attractiveness sums are:"
  foreach n-values length agents [?] [
  output-print (word item ? agents " " ((round (100 * item ? row-sums-list)) / 100 ) ) ; matrix:pretty-print-text row-sums
  ]
  output-print "The maximum attractiveness sum is:"
  output-print max row-sums-list
end

to make-exercised-powers
  ifelse ( is-list? input-data )
  [ let s matrix:from-column-list (list saliences)
    let i matrix:from-column-list (list influences)
    set exercised-powers matrix:times-element-wise s i
    ;; exercised-powers is now a matrix.
    ;; Convert it to a list
    set exercised-powers first matrix:to-column-list exercised-powers
  ]
  [ user-message "You need to load in input data first!" ]
end

to-report get-exercised-powers [s i]
  ;; s ~ saliences
  ;; i ~ influences
  let ss matrix:from-column-list (list s)
  let ii matrix:from-column-list (list i)
  let ep matrix:times-element-wise ss ii
  ;; exercised-powers is now a matrix.
  ;; Convert it to a list
  let eplist first matrix:to-column-list ep
  ;show eplist
  report eplist
end

to make-weighted-median-position
  ifelse (exercised-powers = 0)
  [user-message "You need to create exercised-powers first! Use: make-exercised-powers"]
  [set weighted-median (sum exercised-powers) / 2
   let sofar 0
   let found []
   foreach exercised-powers [
     set sofar sofar + ?
     ifelse sofar <= weighted-median
     [set found lput 0 found]
     [set found lput 1 found]
   ]
    ;show found
    let pos position 1 found
    set weighted-median-position item pos agents
    ;show weighted-median-position
    ]
end

to-report get-weighted-median-position [expow]
   let wt-median (sum expow) / 2
   let sofar 0
   let found []
   foreach expow [
     set sofar sofar + ?
     ifelse sofar <= wt-median
     [set found lput 0 found]
     [set found lput 1 found]
   ]
    ;show found
    let pos position 1 found
    report item pos agents
    
end

to test
;  set bob matrix:from-column-list (list agents)
;  show bob
let bobw (list 1 2 3 "not bob")
let carol bobw
set carol lput 4 carol
set bobw fput 19 bobw
show carol
show bobw
end

to display-agents
  let start (length agents) + 1
  foreach agents [
    ask patch 1 start [set plabel ?]
    set start (start - 1)
  ]
end

to individual-exp [x-percent variable]
  clear-patches
  display-agents
  if (model = 1) [
  let hold-values []
  if runresult variable = saliences
  [ ;; So we fix influences and vary saliences
    ;;
    ;; First we modify the salience value for the agent.
    ;; Then we get the exercised power for the agent.
    ;; Then we get the weighted median position for the group,
    ;; and append it to hold-values.
    ;; Then we reset the salience value for the agent.
    ;; We continue this way until all agents have been processed.
    ;; The we print out the hold-values list.
    foreach n-values length agents [?]
    [
    ;; ok, once through
    let temp runresult variable
    ;show temp
    let target-value item ? temp
    ;show target-value
    let factor (1 + (x-percent / 100)) ;1.1
    ;show (word "factor = " factor)
    let new-value (target-value * factor) 
    ;show new-value
    set temp replace-item ? temp new-value
    ;show runresult variable
    ;show temp
    ;; OK, now get the new exercised powers
    let ex-powers get-exercised-powers(temp)(influences)
    ;show ex-powers
    ;; Now get the weighted median position for the group,
    ;; and append it to hold-values.
    set hold-values lput get-weighted-median-position(ex-powers) hold-values
    ]
   ] ; end of if runresult variable = saliences
  if runresult variable = influences
  [ foreach n-values length agents [?]
    [
    ;; ok, once through
    let temp runresult variable
    ;show temp
    let target-value item ? temp
    ;show target-value
    let factor (1 + (x-percent / 100)) ;1.1
    ;show (word "factor = " factor)
    let new-value (target-value * factor) 
    ;show new-value
    set temp replace-item ? temp new-value
    ;show runresult variable
    ;show temp
    ;; OK, now get the new exercised powers
    let ex-powers get-exercised-powers(saliences)(temp)
    ;show ex-powers
    ;; Now get the weighted median position for the group,
    ;; and append it to hold-values.
    set hold-values lput get-weighted-median-position(ex-powers) hold-values
    ]
    
    ]
   paint-values(hold-values)(3)
   if runresult variable = positions
   [user-message "Positions are not relevant to this model for post-solution analysis."]  
  ] ; end of if (model = 1)
  ;; Now, the next model, model 2.
  if (model = 2) [
    ;; A more complicated model.
    ;; We begin by constructing the APA table (agent position attractiveness)
    ;; This table is n by n where n is the number of agents = number of postions.
    ;; We'll make it with a matrix, initially of 0s
;    let dasize length agents
;    set apa-table matrix:make-constant dasize dasize 0
;    foreach n-values dasize [?]
;    [let row ?
;     foreach n-values dasize [?]
;      [let col ? 
;       let row-position item row positions-normalized
;       let theta item col positions-normalized
;       matrix:set apa-table row col 1 - abs(row-position - theta)
;      ]
;    ]
    ;print matrix:pretty-print-text apa-table
    ;; Now, get the row sums.
    let row-sums-list model2prediction (positions)
;    let row-sums matrix:from-column-list (list agents row-sums-list)
;    print matrix:pretty-print-text row-sums
;    print max row-sums-list
  let hold-values-model2 []
  if runresult variable = positions
  [ ;; So we fix influences and vary saliences
    ;;
    ;; First we modify the salience value for the agent.
    ;; Then we get the exercised power for the agent.
    ;; Then we get the weighted median position for the group,
    ;; and append it to hold-values.
    ;; Then we reset the salience value for the agent.
    ;; We continue this way until all agents have been processed.
    ;; The we print out the hold-values list.
    foreach n-values length agents [?]
    [
    ;; ok, once through
    let temp runresult variable
    ;show temp
    let target-value item ? temp
    ;show target-value
    let factor (1 + (x-percent / 100)) ;1.1
    ;show (word "factor = " factor)
    let new-value (target-value * factor) 
    ;show new-value
    set temp replace-item ? temp new-value
    ;show runresult variable
    ;show temp
    ;; OK, now get the new exercised powers
    let row-sums-list-new model2prediction (temp)
    ;show ex-powers
    ;; Now get the weighted median position for the group,
    ;; and append it to hold-values.
    set hold-values-model2 lput (item (position (max row-sums-list-new) row-sums-list-new) agents) hold-values-model2
    ]
    paint-values(hold-values-model2)(3)
   ] ; end of if runresult variable = positions    
   if runresult variable = saliences
   [user-message "Saliences are not relevant to this model."]
   if runresult variable = influences
   [user-message "Influences are not relevant to this model."]   
  ] ; end of if (model = 2)
end

to-report model2prediction [thepositions]
  ;; First, normalize the positions
  let thepositions-normalized normalize-list (thepositions)
  let dasize length agents
  set apa-table matrix:make-constant dasize dasize 0
  foreach n-values dasize [?]
  [let row ?
   foreach n-values dasize [?]
    [let col ? 
     let row-position item row thepositions-normalized
     let theta item col thepositions-normalized
     matrix:set apa-table row col 1 - abs(row-position - theta)
    ]
  ]  
  ;; Now, get the row sums.
  let row-sums []
  foreach n-values dasize [?]
  [set row-sums (lput sum matrix:get-row apa-table ? row-sums)]
  ;; Now we have to find the max and get the associated position.
  ;; Complicating this is the possibility of ties.
  ;; I think the best thing to do is to report the whole thing,
  ;; as follows.
  ;let max-row-sum-value max row-sums
  report row-sums
  ;report apa-table
end

to paint-values [value-list column]
  let start (length agents) + 1
  foreach value-list [
    ask patch column start [set plabel ?]
    set start (start - 1)
  ]
end

to group-sampling-exploration [x-percent variable]
  clear-patches
  display-agents
  ;; set the outcome counts to 0
  foreach n-values length agents [?] [
    ask patch 5 (length agents + 1 - ?) [set plabel 0]
  ]

  if (model = 1) [
  if runresult variable = saliences
  [runresults-saliences-model1 (x-percent) ] ; end of if runresult variable = saliences  
  ;; Ok, now do influences
  if runresult variable = influences
  [runresults-influences-model1 (x-percent) ] ; end of if runresult variable = influences
  if runresult variable = positions
  [user-message "Positions do not apply for post-solution exploration in model 1."]
  
  
  ] ; end of if (model = 1)
  
  ;; Now model 2. key is: model2prediction (positions)
  if (model = 2) [
  if runresult variable = positions 
  [runresults-positions-model2 (x-percent)] ; end of if runresult variable = positions
  if runresult variable = influences
  [user-message "Influences do not apply for post-solution exploration in model 2."]
  if runresult variable = saliences
  [user-message "Saliences do not apply for post-solution exploration in model 2."]
  ] ; end of if (model = 2)
end

to runresults-positions-model2 [x-percent]
  repeat runresult numtrials [
  ;; Copy positions to a new variable,new-values-positions
  let new-values-positions positions
  ;; Modify all of the positions randomly, uniformly in
  ;; plus/minus x-percent/100.
  foreach n-values length agents [?] [
    let upper item ? new-values-positions * (1 + (abs(x-percent) / 100))
    let lower max (list 0 (item ? new-values-positions * (1 - (abs(x-percent) / 100))))
    let new-value random-float (upper - lower)
    set new-value (lower + new-value)
    set new-values-positions replace-item ? new-values-positions new-value
  ]  
  ;; Solve the model, yielding a list of the summed position evaluations.
  let summed-position-evaluations model2prediction (new-values-positions)
  ;; Now we need to get the location of the first maximum value.
  ; set hold-values-model2 lput (item (position (max row-sums-list-new) row-sums-list-new) agents) hold-values-model2
  let new-position-index position (max summed-position-evaluations) summed-position-evaluations
  let new-position item new-position-index agents
  ;print (word "New outcome is " new-position)
  add-sample-count (new-position)
  ] ; end of repeat runresult numtrials
end

to runresults-saliences-model1 [x-percent ]
  repeat runresult numtrials [    
    ;; First we modify the salience values for every agent.
    let new-values-saliences saliences
    foreach n-values length agents [?] [
      let upper item ? new-values-saliences * (1 + (abs(x-percent) / 100))
      let lower max (list 0 (item ? new-values-saliences * (1 - (abs(x-percent) / 100))))
      let new-value random-float (upper - lower)
      set new-value (lower + new-value)
      set new-values-saliences replace-item ? new-values-saliences new-value
    ]
    ;; Ok, now we solve the model to get the predicted position
    ;; OK, now get the new exercised powers
    let ex-powers get-exercised-powers(new-values-saliences)(influences)   
    ;; new-outcome refers to the agent (a string)
    let new-outcome get-weighted-median-position(ex-powers)
    add-sample-count (new-outcome)
  ] ; end of repeat runresult
end

to runresults-influences-model1 [x-percent]
  repeat runresult numtrials [    
  ;; First we modify the salience values for every agent.
  let new-values-influences influences
  foreach n-values length agents [?] [
    let upper item ? new-values-influences * (1 + (abs(x-percent) / 100))
    let lower max (list 0 (item ? new-values-influences * (1 - (abs(x-percent) / 100))))
    let new-value random-float (upper - lower)
    set new-value (lower + new-value)
    set new-values-influences replace-item ? new-values-influences new-value
  ]
  ;; Ok, now we solve the model to get the predicted position
  ;; OK, now get the new exercised powers
  let ex-powers get-exercised-powers(saliences) (new-values-influences)  
  ;; new-outcome refers to the agent (a string)
  let new-outcome get-weighted-median-position(ex-powers)
  add-sample-count (new-outcome)
] ; end of repeat numtrials 
end
    

to add-sample-count [outcome]
    let new-agent position outcome agents  
    let x-index 5
    let y-index (length agents + 1 - new-agent)
    ask patch x-index y-index [set plabel (plabel + 1)]
end
@#$#@#$#@
GRAPHICS-WINDOW
316
10
956
641
-1
-1
30.0
1
10
1
1
1
0
1
1
1
0
20
0
19
0
0
1
ticks
30.0

BUTTON
40
44
206
77
NIL
load-default-data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
144
211
177
NIL
show-input-data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
42
108
211
141
load-own-input-data
\nuser-message \"See the Info tab for information about valid file formats.\"\nload-own-input-data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

OUTPUT
647
10
955
637
12

CHOOSER
52
416
144
461
Model
Model
1 2 3
1

BUTTON
201
417
317
450
NIL
model-report
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
50
509
316
542
exploration-range-percent
exploration-range-percent
-100
200
177
1
1
NIL
HORIZONTAL

CHOOSER
51
464
171
509
exploration-variable
exploration-variable
"saliences" "influences" "positions"
2

BUTTON
49
543
259
576
Individual exploration
individual-exp(exploration-range-percent)(exploration-variable)\n\nclear-output\noutput-print \"Individual exploration report.\"\noutput-print \"---------------------------------------\"\noutput-print (word \"In model \" model \", varying the \" exploration-variable)\noutput-print (word \"variable by \" exploration-range-percent \" percent for the agent\")\noutput-print (word \"in the left-hand column results in the\")\noutput-print (word \"group decision position in the \")\noutput-print (word \"right-hand column.\")\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
40
10
206
43
Initialize
clear-all\nset agent-max 12\nset parameter-list (list \"positions\" \"saliences\" \"influences\")
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
16
14
42
32
(1)\n
14
0.0
1

TEXTBOX
11
82
34
100
(2)
14
0.0
1

TEXTBOX
116
85
141
108
or
12
0.0
1

TEXTBOX
13
154
35
172
(3)
14
0.0
1

TEXTBOX
10
419
41
441
(4a)
14
0.0
1

TEXTBOX
9
475
37
495
(5a)
14
0.0
1

TEXTBOX
11
514
41
532
(5b)
14
0.0
1

TEXTBOX
11
550
42
577
(6)
14
0.0
1

TEXTBOX
158
422
192
440
(4b)
14
0.0
1

SLIDER
4
221
176
254
agent
agent
0
agent-max
7
1
1
NIL
HORIZONTAL

MONITOR
175
209
256
254
Agent name
item agent agents
17
1
11

MONITOR
5
301
112
346
Current value
item agent runresult item parameter parameter-list
17
1
11

BUTTON
5
353
149
386
Change current value
if parameter = 0\n[set positions replace-item agent positions what-if-value]\nif parameter = 1\n[set saliences replace-item agent saliences what-if-value]\nif parameter = 2\n[set influences replace-item agent influences what-if-value]\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
3
265
175
298
parameter
parameter
0
2
2
1
1
NIL
HORIZONTAL

MONITOR
175
253
300
298
Parameter name
item parameter parameter-list
17
1
11

SLIDER
114
313
316
346
what-if-value
what-if-value
0
100
24.9
0.1
1
NIL
HORIZONTAL

BUTTON
154
353
314
386
NIL
show-current-data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
8
178
289
206
------------------------------------------\n---------- Optional what-ifs ---------------
11
0.0
1

TEXTBOX
9
392
320
417
--------- End of optional what-ifs -------------\n--------------------------------------------
11
0.0
1

BUTTON
120
608
317
641
Group sampling exploration
group-sampling-exploration(exploration-range-percent)(exploration-variable)\n\nclear-output\noutput-print \"Group sampling exploration report.\"\noutput-print \"---------------------------------------\"\noutput-print (word \"In model \" model \", varying the \" exploration-variable)\noutput-print (word \"variable uniformly randomly by \")\noutput-print (word \"plus/minus \" exploration-range-percent \" percent for every agent\")\noutput-print (word \"and solving \" numtrials \" times results in the\")\noutput-print (word \"distribution of group decision \")\noutput-print (word \"positions shown in the right-hand\")\noutput-print (word \"column.\")\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
2
598
53
632
(7a, b)
14
0.0
1

INPUTBOX
49
581
121
641
NumTrials
1000
1
0
String

@#$#@#$#@
## WHAT IS IT?

The IranBargaining NetLogo model implements group decision making models for an example discussed in:

    Bueno de Mesquita, Bruce. "Forecasting Policy Decisions: An Expected Utility
    Approach to Post-Khomeini Iran" PS, vol. 17, No. 2 (spring 1984), pp. 226-236. 
    Available from JSTOR: http://www.jstor.org/stable/418786.

The Bueno de Mesquita paper does not specify the decision models actually employed to make the predictions reported in the paper. A good conjecture is some form of generalized voting model, which is what we explore here in the IranBargaining model. 

In addition to merely implementing conjectured decision models, the IranBargaining NetLogo model provides three **post-solution** analysis features, which can be used for analyzing the decision models. Moreover, the IranBargaining model is generic in the sense that it can be used for **group decision prediction (GDP)** problems that are similar to Bueno de Mesquita's formulation of the Iranian decision problem. 

## BACKGROUND 

Bueno de Mesquita (1984) provides a well-known instance of using  voting models to forecast negotiated outcomes. We are, of course, aware of controversy attached to this paper; resolving this controversy is well beyond the scope of this NetLogo model. Instead, we present (Bueno de Mesquita 1984) as an example (a particularly accessible example) of how modeling can be, and in fact is, used to provide insight on the important area of forecasting negotiation outcomes. 

Published during the Iran-Iraq War (1980-1988; aka the First Persian Gulf War) and seeking to model decision making on the Iranian side, the paper identifies 27 agents of interest (which he calls groups), of which 18 are actually used in his model to predict the position eventually arrived at by these agents.

Each of the agents is given a two or three letter abbreviation for its name, e.g., SC for Supreme Court, LCR for Lower Class Rural Peasants; see Table 1 in (Bueno de Mesquita 1984) for the full listing. We use these abbreviations in the input data file for the case (BuenodeMesquita1984.txt) to identify the  agents in the models; for the purpose of our explanation the true identity of these agents is not important.  In his paper Bueno de Mesquita forecasted that the war would continue but in a more economical fashion with the hardliners of MON, TMC and QUM sidelined. In the end, the fighting on the battlefield ended only in August 1988 with Resolution 598, a UN-brokered ceasefire, but the hostilities continued into the peace-negotiating chamber until a peace was finally signed in 1990.

In line with our description of how agents hold opinions, (Bueno de Mesquita 1984) assigns three numeric data values to each agent. He calls them **issue position**,   **salience**, and **influence**. These map to our introduced terminology. What we call **exercised power** will be modeled as the product of the **influence** and **salience** values from Bueno de Mesquita's data.

## POST-SOLUTION ANLAYSIS

It is a commonplace among modelers that the real work for decision making begins _after_ a model has been conceived, designed, implemented, tested, validated, and exercised to obtain a solution. The term _post-solution analysis_ refers to what is done during this phase of the modeling life-cycle. See the accompanying paper/chapter for a general discussion.

The IranBargaining model implements three very general capabilities for post-solution analysis. _What-if_ is the first of these capabilities. 

Using the what-if features of the NetLogo model the user may change one or more parameter values and then execute an associated model to see what the effect is of the change(s). If, for example, we change the influence  value of agent JC from its default value of 11.3 to 24.9 and execute model 1, we will see that the position predicted of the group changed from PRE to JC. The increase in JC's influence has been sufficient to alter the outcome of the group's deliberations, according to the model.
 
Second, a form of _individual exploration analysis_ is supported in the IranBargaining Netlogo model with the code associated with the "Individual exploration" button, labeled (6) in the display. 

Try executing individual exploration on model 1 with an exploration range of 177 percent on the salience values for the 18 agents. The meaning of the resulting output, shown in white lettering on a black background in the view, is as follows. The left-hand column of the output arrays the short names of the 18 agents in the data for model 1. The order is in their position values, increasing downwards. So UMC has the smallest position value and QUM the largest. The values in the right-hand column are the decisions reached by the model when the corresponding agent in the left-hand column has its salience score enlarged by 177 percent. For example, for REV in the left-hand column, we find JC in the right-hand column. This means that if we keep the input data (perhaps as changed by what-if operations) constant, but increase the salience value for REV by 177 percent, then the group is predicted to resolve its decision by choosing the JC position.
If, for example, we set the exploration range to 177 percent on the salience values for the 18 agents we get a report whose meaning is as follows. For each of the 18 positions we see  the decision reached by the model when the corresponding agent  has its salience score enlarged by 177 percent. For example, for REV, we find JC is the new decision. This means that if we keep the input data (perhaps as changed by what-if operations) constant, but increase the salience value for REV by 177 percent, then the group is predicted to resolve its decision by choosing the JC position.

Overall, what the NetLogo model model is telling us here is that even with such a large change PRE still occurs most often. However, there are several cases in which it is altered. Note that the output reported contains information from 18 distinct solutions of model 1.  This is valuable not only for saving analyst time by avoiding a one-a-time what-if analysis; it also presents a higher-level pattern for viewing by the analyst and decision makers. This is a simple instance of application of the principle of **solution pluralism** for post-solution analysis.


In individual exploration we systematically make changes to one variable at a time and observe the behavior of the model. In _group sampling exploration_ we randomly change a number of variables at once and record the behavior of the model. We repeat this process a large number of times and observe the distribution or pattern of behavior of the model.

A form of group sampling exploration analysis is supported in the IranBargaining NetLogo model. 
with the code associated with the "Group sampling exploration" button, labeled (7b) on the Interface tab. Try executing group sampling exploration on model 1 with an exploration range of plus or minus 75 percent on the salience values for the 18 agents. 
For example, if we set the exploration range to plus or minus 75 percent on the salience values for the 18 agents we can get a report of the consequences.

The meaning of the report, shown in white lettering on a black background in the view, 
is as follows. The left-hand column of the output arrays the short names of the 18 agents in the data for model 1. The order is in their position values, increasing downwards. So UMC has the smallest position value and QUM the largest. The values in the right-hand column are the number of times the decisions reached by the model for the corresponding agent position in the left-hand column. This is under perturbation of the salience values in which the salience value for every agent is randomly perturbed in its $\pm$75 percent range and model 1 is executed to predict an outcome.   For example, for REV in the left-hand column, we find 2 in the right-hand column. This means that in 10,000 trials (see "NumTrials" on the Interface, labeled (7a)) exactly 2 produced joint salience values resulting in a predicted position of REV as the outcome.

Overall, what the NetLogo model model is telling us here is that even with such a large change PRE still occurs about 70 percent of the time. However, there is definitely a distribution of outcomes.  JC will occur about 20 percent of the time and the other outcomes are concentrated  on the high side (lower in the display) of the PRE position (i.e., favoring vigorously pursuing the war).


## RELATED MODELS

Here are helpful files/tutorials from the NetLogo models library:
File Input Example
File Output Example

## INPUT FILE FORMAT

Here is a valid input file for this model. In fact it contains the data extracted from the Bueno de Mesquita 1984 article that is used as the default data with "load-default-data".

    Bueno d Mesquita article PS, vol. 17, No. 2 (spring 1984), pp. 226-236.
    "Agent" "Position" "Salience" "Influence"
    "UMC" 0.0 0.8 1.1
    "TEC" 0.0 2.5 0.6
    "MCR" 2.1 2.5 0.9
    "SOV" 3.0 10.3 0.6
    "PM" 4.7 6.8 9.0
    "BAZ" 5.1 0.8 5.6
    "REV" 5.1 8.5 12.4
    "JC" 5.1 10.3 11.3
    "PRE" 6.4 10.3 10.7
    "UP" 7.3 2.5 4.5
    "LCR" 7.3 3.4 4.5
    "KUR" 8.6 4.3 2.3
    "COM" 9.8 8.5 11.8
    "SC" 11.1 6.0 4.5
    "CG" 11.1 4.3 9.0
    "MON" 12.4 9.4 0.1
    "TMC" 12.4 9.4 3.4
    "QUM" 12.4 9.4 4.5

Points arising:

1.  The first line should not be empty. It can be as long as you wish.
2.  The second line should be exactly as shown here.
3.  The third line begins the actual data. You should follow the format shown:
	1. Four items per line, separated by spaces.
	2. The first item should be a string in quotes.
	3. Items 2 through 4 should be numbers
	4. All items should be separated by spaces.
4.  Do not start a new (empty) line after the last data line.
5.  You may have as many data lines as you wish. However, the world and its view are currently configured to have no more than 18 data lines. If you need more, you will need to adjust the world and its view.

## HOW TO CITE

If you mention this model in a publication, we ask that you include these citations for the model itself and for the NetLogo software:

* Kimbrough, Steven O. (2014). NetLogo Iran Bargaining model.  University of Pennsylvania, Philadelphia, PA. IranBargaining.nlogo

## COPYRIGHT AND LICENSE

Copyright 2014 Steven O. Kimbrough.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Steven O. Kimbrough at kimbrough@wharton.upenn.edu.

Support for this model, in part, was provided by KAPSARC, http://www.kapsarc.org. We gratefully acknowledge the support.

Version: $Id: IranBargaining.nlogo 4264 2014-07-20 21:45:22Z sok $.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
need-to-manually-make-preview-for-this-model
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
