globals [
  ;; mouse-state variables
  click?
  down-patch
  up-patch
  ;; display variable
  pixel ;; set to fraction of patch = 1 pixel, i.e. 1 / patch-size
]

breed [ blocks block ]

blocks-own
[ state ;; "sliding" or anything else
  start ;; where block came from
  destination ;; where block is going
  travel-time;; how long it takes to get there
  arrival-time ;; arrival-time - timer used to slide blocks
]

to startup setup end

to-report color-from-who report 15 + 10 * (who mod 13) end

to setup
  clear-all
  set pixel 1 / patch-size
  ask patches
  [ sprout-blocks 1
    [ set color color-from-who
      set pcolor color + 2 ;; pale border around square
      set shape "square" ;; a funky square,
      set heading 90 * random 4 ;; display purposes only, for that funky look
    ]
  ]
  ;; remove one block
  ask one-of blocks [ set pcolor black  die ]
  set click? false
  reset-ticks
end

;; use reporters to wrap tests in meaningful names.
;; this is what we mean by "self-documenting code"
to-report mouse-went-down? report (mouse-down? and not click?) end
to-report mouse-went-up? report (not mouse-down? and click?) end
to-report mouse-clicked? report (is-patch? down-patch and up-patch = down-patch) end

to do-click-action
  ;; if a turtle that is next to an empty patch is clicked,
  ;; start sliding that turtle
  if ( any? (blocks-on up-patch) with [ state != "sliding" ] )
  [ ;; get this block
    let this-block one-of blocks-on up-patch
    ;; gather empty patches
    let empty-patches [ neighbors4 with [ pcolor != gray and not any? turtles-here ] ] of this-block
    ;; any
    if any? empty-patches
    [ let empty-patch one-of empty-patches
      ask this-block
      [ set state "sliding"
        ask my-links [ die ]
        set destination empty-patch
        set start patch-here
        set travel-time slide-duration
        set arrival-time timer + (travel-time * .001)
        ask destination [ set pcolor black + .1 ]
        ask start [ set pcolor black ]
      ]
    ]
  ]
end

to go-animation
  ask blocks with [ state = "sliding" ]
  [ ifelse ( timer >= arrival-time )
    [ ;; arrived
      set state "waiting"
      move-to destination
      ;; visuals
      set pcolor color + 2
      create-links-with ( (turtles-on neighbors4 ) with [ color = [ color ] of myself ])
      [ set shape "plain"
        set color [ color ] of myself - 2
        set thickness min (list 1 (5 * pixel) )
      ]
    ]
    [

      let ratio (arrival-time - timer) / ( travel-time * .001)
      set xcor [ pxcor ] of start * ratio + [ pxcor ] of destination * (1 - ratio)
      set ycor [ pycor ] of start * ratio + [ pycor ] of destination * (1 - ratio)
    ]
  ]
end


to do-mouse-down
  set click? true
  set down-patch patch mouse-xcor mouse-ycor
  set up-patch nobody
end

to do-mouse-up
  set click? false
  set up-patch patch mouse-xcor mouse-ycor
  if mouse-clicked? [ do-click-action ]
  set down-patch nobody
  set up-patch nobody
end


to go
  ( ifelse
    ( mouse-went-down? ) [ do-mouse-down ]
    ( mouse-went-up? ) [ do-mouse-up ]
   )
   go-animation
end


@#$#@#$#@
GRAPHICS-WINDOW
181
10
469
299
-1
-1
40.0
1
10
1
1
1
0
1
1
1
-3
3
-3
3
0
0
1
ticks
30.0

BUTTON
10
10
73
50
reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
86
10
149
49
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
17
69
167
144
Click go to activate.\n\nClick on a block to cause the block to slide into the empty space.
11
0.0
1

SLIDER
11
154
159
187
slide-duration
slide-duration
0
3000
300.0
100
1
milliseconds
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

A demo.

Feaures a basic mouse interface, animation
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

square
true
0
Polygon -7500403 true true 30 45 255 30 255 270 30 255
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

plain
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
false
0
@#$#@#$#@
0
@#$#@#$#@
